---
layout: post
title:  第149期
---
# C++ 中文周刊 2024-02-17 第149期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)   或评论区留言

本期文章由 不语 黄亮Anthony Tudou kenshin 赞助

勉强算半期吧，返程没时间了，简单更新一下

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2024-02-14 第241期 ](https://mp.weixin.qq.com/s/3uOA2RGAWKcqIorIDodplA)

[二月邮件](https://open-std.org/jtc1/sc22/wg21/docs/papers/2024/#mailing2024-02)

其实重点比较明朗，就execution reflect graph这些，剩下的基本都是修正

fiber_context也好久了

## 文章

#### [Clang 出了 Bug 怎么办？来一起修编译器吧！](https://zhuanlan.zhihu.com/p/659944720)

看一遍基本就把clang llvm这套东西串起来了。都学一下吧，llvm战未来朋友们

#### [C++20的constexpr string为什么无法工作](https://www.zhihu.com/question/643989678/answer/3393477151)

感受抽象的gcc sso优化实现

另外clang本来是没做constexpr sso优化的，[最近又给加上了](https://www.zhihu.com/question/643989678/answer/3393744969)

微信群里也讨论了，咨询了maskray老师意见，可能就是为了对齐libstdcxx的行为

我和这个想法相同，你都constexpr了，还sso干啥

#### [C++ 中 constexpr 的发展史!](https://zhuanlan.zhihu.com/p/682031684)

感觉有点不认识const了

#### [ Velox: Meta’s Unified Execution Engine](https://zhuanlan.zhihu.com/p/682036952)

还挺有意思的

#### [too dangerous for c++](https://blog.dureuill.net/articles/too-dangerous-cpp/)

对比rust c++的shared_ptr没有太限制生命周期，可能会用错，c++还是太自由了


####  [On the virtues of the trailing comma](https://devblogs.microsoft.com/oldnewthing/20240209-00/?p=109379)

就是这种行尾的逗号，对于git merge也友好


```cpp
// C, C++
Thing a[] = {
    { 1, 2 },
    { 3, 4 },
    { 5, 6 },
    //      ^ trailing comma
};

// C#
Thing[] a = new[] {
    new Thing {
        Name = "Bob",
        Id = 31415,
        //        ^ trailing comma
    },
    new Thing {
        Name = "Alice",
        Id = 2718,
        //       ^ trailing comma
    },
//   ^ trailing comma
};

Dictionary d = new Dictionary<string, Thing>() {
    ["Bob"] = new Thing("Bob") { Id = 31415 },
    ["Alice"] = new Thing("Alice", 2718),
    //                                  ^ trailing comma
};

```

感觉这是个不成文规定实现

#### [Formatting User-Defined Types in C++20](https://www.modernescpp.com/index.php/formatting-user-defined-types-in-c20/)


简单实现

```c++
#include <format>
#include <iostream>

class SingleValue {
 public: 
    SingleValue() = default;
    explicit SingleValue(int s): singleValue{s} {}
    int getValue() const {
        return singleValue;
    }
 private:
    int singleValue{};
};

template<>
struct std::formatter<SingleValue> : std::formatter<int> {             // (1)
  auto format(const SingleValue& singleValue, std::format_context& context) const {
    return std::formatter<int>::format(singleValue.getValue(), context);
  }
};

int main() {
    SingleValue singleValue0;
    SingleValue singleValue2020{2020};
    SingleValue singleValue2023{2023};

    std::cout << std::format("{:*<10}", singleValue0) << '\n';
    std::cout << std::format("{:*^10}", singleValue2020) << '\n';
    std::cout << std::format("{:*>10}", singleValue2023) << '\n';
}
```

#### [Visual overview of a custom malloc() implementation](https://silent-tower.net/projects/visual-overview-malloc)

典型内存池实现介绍

#### [Vectorizing Unicode conversions on real RISC-V hardware](https://camel-cdr.github.io/rvv-bench-results/articles/vector-utf.html)

哥们看不懂rsicv 不太懂

#### [C++20 Concepts Applied – Safe Bitmasks Using Scoped Enums](https://accu.org/journals/overload/32/179/fertig/)

直接贴代码吧

```cpp
template<typename T>
constexpr std::
  enable_if_t<
    std::conjunction_v<std::is_enum<T>,
      // look for enable_bitmask_operator_or
      // to  enable this operator ①
      std::is_same<bool,
        decltype(enable_bitmask_operator_or(
          std::declval<T>()))>>,
  T>
operator|(const T lhs, const T rhs) {
  using underlying = std::underlying_type_t<T>;
  return static_cast<T>(
    static_cast<underlying>(lhs) |
    static_cast<underlying>(rhs));
}
namespace Filesystem {
  enum class Permission : uint8_t {
    Read = 1,
    Write,
    Execute,
  };
  // Opt-in for operator| ②
  constexpr bool 
    enable_bitmask_operator_or(Permission);
} // namespace Filesystem
```

这个玩法就是针对部分提供enable_bitmask_operator_or 的enum class 提供 operator |

现在是2024了，有没有新的玩法

concept
```cpp
template<typename T>
requires(std::is_enum_v<T>and requires(T e) {
  // look for enable_bitmask_operator_or to
  // enable this operator ①
  enable_bitmask_operator_or(e);
}) constexpr auto
operator|(const T lhs, const T rhs) {
  using underlying = std::underlying_type_t<T>;
  return static_cast<T>(
    static_cast<underlying>(lhs) |
    static_cast<underlying>(rhs));
}
namespace Filesystem {
  enum class Permission : uint8_t {
    Read    = 0x01,
    Write   = 0x02,
    Execute = 0x04,
  };
  // Opt-in for operator| ②
  consteval 
    void enable_bitmask_operator_or(Permission);
} // namespace Filesystem

```

c++23  有to_underlying了

```cpp

template<typename T>
requires(std::is_enum_v<T>and requires(T e) {
  enable_bitmask_operator_or(e);
}) constexpr auto
operator|(const T lhs, const T rhs)
{
  return static_cast<T>(std::to_underlying(lhs) |
                        std::to_underlying(rhs));
}
```

简洁一丢丢



## 开源项目介绍

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [graphiz](https://github.com/statisch/graphiz) 一个图遍历演示库，挺好玩的
- [mantis](https://github.com/Janos95/mantis) [P2M: A Fast Solver for Querying Distance from Point to Mesh Surface](https://yuemos.github.io/Projects/P2M/pdf/P2M_author.pdf) 的实现


## 互动环节

我不想返工啊

---

[上一期](https://wanghenshui.github.io/cppweeklynews/posts/148.html)