---
layout: post
title:  第147期
---
# C++ 中文周刊 2024-01-26 第147期

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)   或评论区留言

本期文章由 不语 沧海  彩虹蛇皮虾 赞助

jetbrain发布了23年 c++ 生态回顾 https://blog.jetbrains.com/clion/2024/01/the-cpp-ecosystem-in-2023/

感兴趣的可以看看，没啥意思

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

一月邮件

https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/#mailing2024-01


## 文章

#### [全新的构造函数，C++ 中的 relocate 构造函数 ](https://zhuanlan.zhihu.com/p/679782886)

其实这个概念之前讨论了很久，老熟人Arthur O’Dwyer 提了很多相关的提案 patch。大家感兴趣的可以读一下。算是一个优化的点

之前也提到过，比如

- [Polymorphic types aren’t trivially relocatable](https://quuxplusone.github.io/blog/2023/06/24/polymorphic-types-arent-trivially-relocatable/)

- [STL algorithms for trivial relocation](https://quuxplusone.github.io/blog/2023/03/03/relocate-algorithm-design/)

讲trivial relocation的现状以及开源实现

<table class="smaller">
<tr><td></td> <td></td> <td>T.r. types</td> <td>Non-t.r. types</td> <td>Throwing-move types</td> <td>Rightward motion (`insert`)</td> <td>Leftward motion (`erase`)</td> <td>Non-pointer iterators</td> </tr>
<tr><td rowspan="3">STL Classic (non-relocating)</td>
                                  <td><code>std::copy</code></td>                       <td>N/A</td> <td>N/A</td>  <td>✓</td>      <td>UB</td> <td>✓</td>  <td>✓</td>      </tr>
<tr>                              <td><code>std::copy_n</code></td>                     <td>N/A</td> <td>N/A</td>  <td>✓</td>      <td>UB</td> <td>UB</td> <td>✓</td>      </tr>
<tr>                              <td><code>std::copy_backward</code></td>              <td>N/A</td> <td>N/A</td>  <td>✓</td>      <td>✓</td>  <td>UB</td> <td>✓</td>      </tr>
<tr><td rowspan="2">cstring</td>  <td><code>memcpy</code></td>                          <td>✓</td> <td>UB</td>     <td>✓</td>      <td>UB</td> <td>UB</td> <td>SFINAE</td> </tr>
<tr>                              <td><code>memmove</code></td>                         <td>✓</td> <td>UB</td>     <td>✓</td>      <td>✓</td>  <td>✓</td>  <td>SFINAE</td> </tr>
<tr><td rowspan="2">Qt</td>       <td><code>q_uninitialized_relocate_n</code></td>      <td>✓</td> <td>✓</td>      <td>✓?</td>     <td>UB</td> <td>UB</td> <td>SFINAE</td> </tr>
<tr>                              <td><code>q_relocate_overlap_n</code></td>            <td>✓</td> <td>✓</td>      <td>✓</td>      <td>✓</td>  <td>✓</td>  <td>SFINAE</td> </tr>
<tr><td rowspan="1">BSL</td>      <td><code>destructiveMove</code></td>                 <td>✓</td> <td>✓</td>      <td>✓</td>      <td>UB</td> <td>UB</td> <td>SFINAE</td> </tr>
<tr><td rowspan="3">P2786R0</td>  <td><code>trivially_relocate</code></td>              <td>✓</td> <td>SFINAE</td> <td>SFINAE</td> <td>✓</td>  <td>✓</td>  <td>SFINAE</td> </tr>
<tr>                              <td><code>relocate</code></td>                        <td>✓</td> <td>✓</td>      <td>SFINAE</td> <td>✓</td>  <td>✓</td>  <td>SFINAE</td> </tr>
<tr>                              <td><code>move_and_destroy</code></td>                <td>✓</td> <td>✓</td>      <td>SFINAE</td> <td>UB</td> <td>?</td>  <td>✓</td>      </tr>
<tr><td rowspan="2">P1144R6</td>  <td><code>uninitialized_relocate</code></td>          <td>✓</td> <td>✓</td>      <td>✓</td>      <td>UB</td> <td>✓</td>  <td>✓</td>      </tr>
<tr>                              <td><code>uninitialized_relocate_n</code></td>        <td>✓</td> <td>✓</td>      <td>✓</td>      <td>UB</td> <td>✓</td>  <td>✓</td>      </tr>
<tr><td rowspan="1">P1144R7</td>  <td><code>uninitialized_relocate_backward</code></td> <td>✓</td> <td>✓</td>      <td>✓</td>      <td>✓</td>  <td>UB</td> <td>✓</td>      </tr>
</table>


还给人folly提MR https://github.com/facebook/folly/pull/1934

- [`std::relocate`’s implementation is cute](https://quuxplusone.github.io/blog/2022/05/18/std-relocate/)

等等，周边信息很多


#### [why gcc and clang sometimes emit an extra mov instruction for std::clamp on x86 ](https://1f6042.blogspot.com/2024/01/stdclamp-still-generates-less-efficient.html)

直接贴代码  https://godbolt.org/z/rq9dsGxh5

```c++
#include <algorithm>

double incorrect_clamp(double v, double lo, double hi){
    return std::min(hi, std::max(lo, v));
}

double official_clamp(double v, double lo, double hi){ 
    return std::clamp(v, lo, hi); 
}

double official_clamp_reordered(double hi, double lo, double v){ 
    return std::clamp(v, lo, hi); 
}

double correct_clamp(double v, double lo, double hi){
    return std::max(std::min(v, hi), lo);
}

double correct_clamp_reordered(double lo, double hi, double v){
    return std::max(std::min(v, hi), lo);
}
```

对应的汇编

```asm
incorrect_clamp(double, double, double):
        maxsd   xmm0, xmm1
        minsd   xmm0, xmm2
        ret
official_clamp(double, double, double):
        maxsd   xmm1, xmm0
        minsd   xmm2, xmm1
        movapd  xmm0, xmm2
        ret
official_clamp_reordered(double, double, double):
        maxsd   xmm1, xmm2
        minsd   xmm0, xmm1
        ret
correct_clamp(double, double, double):
        minsd   xmm2, xmm0
        maxsd   xmm1, xmm2
        movapd  xmm0, xmm1
        ret
correct_clamp_reordered(double, double, double):
        minsd   xmm1, xmm2
        maxsd   xmm0, xmm1
        ret
```
为什么正确的代码多了一条 mov xmm？

浮点数 +-0的问题，标准要求返回第一个参数，比如 `std::clamp(-0.0f, +0.0f, +0.0f)`

如果配置了`-ffinite-math-only -fno-signed-zeros` 最终汇编是一样的 https://godbolt.org/z/esMY18a5z

#### [Fuzzing an API with libfuzzer ](https://playfulprogramming.blogspot.com/2024/01/fuzzing-api-with-libfuzzer.html)

举一个fuzz例子，大家都学一下

你看这个接口感觉可能无从下手

```c++
extern "C"
int LLVMFuzzerTestOneInput(const uint8_t *data, size_t size)
```

我们要测试的接口长这样

```cpp
template <typename T, size_t Capacity>
requires (std::is_nothrow_move_constructible_v<T> && std::is_nothrow_move_assignable_v<T>)
class fixed_stack
{
public:
    T& push(T t) {
        if (size() == capacity()) throw size_error("push on full stack");
        return data_[++size_] = std::move(t);
    }
    T& back() {
        if (empty()) throw size_error("back on empty stack");
        return data_[size_];
    }
    T pop() {
        if (empty()) throw size_error("pop on empty stack");
        return std::move(data_[size_--]);
    }
    [[nodiscard]] bool empty() const { return size() == 0; }
    [[nodiscard]] size_t size() const { return size_; }
    [[nodiscard]] static size_t capacity() { return Capacity; }
private:
    size_t size_ = 0;
    std::array<T, Capacity> data_{};
};
```

考虑一下测试代码

可能长这样

```c++
truct failure : std::string {
    using std::string::string;
};

#define REQUIRE(...) if (__VA_ARGS__) {;} else throw failure #__VA_ARGS__)
#define FAIL(...) throw failure(__VA_ARGS__)

int main() {
    unsigned fail_count = 0;
    struct test {
        const char* name;
        std::function<void()> f;
    };
    test tests[] {
            { "default constructed stack is empty",
              []{
                fixed_stack<int, 8> s;
                REQUIRE(s.size() == 0);
                REQUIRE(s.empty());
            }},
            { "Each push grows size by one",
              [] {
                fixed_stack<int, 8> s;
                s.push(3);
                REQUIRE(s.size() == 1);
                s.push(2);
                REQUIRE(s.size() == 2);
                s.push(8);
                REQUIRE(s.size() == 3);
              }
            },
            { "Pop returns the pushed elements in reverse order",
              []{
                fixed_stack<int, 8> s;
                s.push(3);
                s.push(2);
                s.push(8);
                REQUIRE(s.pop() == 8);
                REQUIRE(s.pop() == 2);
                REQUIRE(s.pop() == 3);
            }
            },
            { "pop on empty throws",
              []{
                fixed_stack<int, 8> s;
                s.push(3);
                s.pop();
                try {
                    s.pop();
                    FAIL("didn't throw");
                }
                catch (const size_error&)
                {
                    // good!
                }
            }}
    };
    for (auto& t : tests){
        try {
            std::cout << std::setw(60) << std::left << t.name << "\t";
            t.f();
            std::cout << "PASS!";
        } catch (const failure& f) {
            std::cout << "FAILED!\nError: " << f << '\n';
            ++fail_count;
        } catch (...) {
            std::cout <<  "FAILED!\nUnknown reason!";
            ++fail_count;
        }
        std::cout << '\n';
    }
}
```

现在咱们考虑怎么把这个测试代码改写成fuzz test?

简单来说输入的就是一段二进制，怎么根据这个二进制拆解出不同的动作，拆解出不同的输入？

```cpp
struct exhausted {};
struct source {
    std::span<const uint8_t> input;
    template <typename T>
    requires (std::is_trivial_v<T>)
    T get() {
        constexpr auto data_size = sizeof(T);
        if (input.size() < data_size) throw exhausted{};
        alignas (T) uint8_t buff[data_size];
        std::copy_n(input.begin(), data_size, buff);
        input = input.subspan(data_size);
        return std::bit_cast<T>(buff);
    }
};
extern "C" int LLVMFuzzerTestOneInput(const uint8_t *data, size_t size) {
    source s{{data, size}};
    std::vector<int> comparison;
    std::optional<fixed_stack<std::unique_ptr<int>, 8>> stack;
    try {
        for (;;) {
            if (!stack.has_value()) {
                stack.emplace();
            }
            //   通过source 拿一个u8来枚举动作
            const auto action = s.get<uint8_t>();
            switch (action) {
                case 0: // push
                {
                    // 通过source拿到需要的输入数据
                    const int v = s.get<int>();
                    const auto size = stack->size();
                    try {
                        stack->push(std::make_unique<int>(v));
                        comparison.push_back(v);
                        assert(stack->size() == comparison.size());
                        assert(stack->back() != nullptr);
                        assert(*stack->back() == v);
                    } catch (size_error) {
                        assert(size == stack->capacity());
                        assert(stack->size() == size);
                    }
                }
                break;
                case 1: // pop
                {
                    if (!stack->empty()) {
                        auto v = stack->pop();
                        assert(v);
                        assert(*v == comparison.back());
                        comparison.pop_back();
                    }
                }
                break;
                case 2: // destroy
                {
                    stack.reset();
                    comparison = {};
                }
            }
        }
    } catch (exhausted) { /* done */ }
    return 0;  // Values other than 0 and -1 are reserved for future use.
}
```
编译带上`-fsanitize=address,undefined,fuzzer --coverage `

能抓到错误，抓到错误调试就是另一个流程了，gdb挂上去调就行了。留做作业吧

#### [C++ 实现 shared_ptr / weak_ptr /enable_shared_from_this](https://zhuanlan.zhihu.com/p/680068428)

学吧，学无止境

主要是控制块的管理


#### [C++ Lifetime Profile Static Analyzer](https://zhuanlan.zhihu.com/p/678944217)


这个哥们把一个工具优化到能用的水平，并介绍了相关设计

这个精力投入令人佩服，代码在这里 https://github.com/qqiangwu/cppsafe

感兴趣的可以体验一下


#### [Linux kernel中有哪些奇技淫巧](https://www.zhihu.com/question/471637144/answer/3377224126)

介绍static key的

[130期](https://wanghenshui.github.io/cppweeklynews/posts/130.html) 咱们提到过[Bounded dynamicism with cross-modifying code](https://pvk.ca/Blog/2021/12/19/bounded-dynamicism-with-cross-modifying-code/)

也是类似的玩意，也有现成的库提供，https://github.com/backtrace-labs/dynamic_flag

#### [分享一个asio下使用channel来实现无需队列的安全的连续async_write的方法](https://zhuanlan.zhihu.com/p/679175397)

不明觉厉

#### [Detecting multiple instantiations](https://www.think-cell.com/en/career/devblog/detecting-multiple-instantiations)

利用statufull template来检查，算了吧，不看了

#### [GDB反向调试：让程序逆序执行，代码调试原来这么简单！体验时光旅行的快感！](https://zhuanlan.zhihu.com/p/673279895)

其实就是record录制

## 视频

#### [C++ Weekly - Ep 412 - Possible Uses of C++23's [[assume]] Attribute ](https://www.youtube.com/watch?v=Frl8XKhvA4Q&ab_channel=C%2B%2BWeeklyWithJasonTurner)

可能的一种用法

```cpp
#ifdef NDEBUG
#define assert(x) [[assume(x)]]
#else
#define assert(x) /* unreach, abort都行，自定义 */
#endif
```

感觉不如builtin_expect，暂时别用

#### [Data Storage in Entity Component Systems - Mathieu Ropert - Meeting C++ 2023](https://www.youtube.com/watch?v=b9hNKFj5R3Y&ab_channel=MeetingCpp)

讲ecs框架和entt的

讲entt的视频，最近我看到一个不错的 b站 BV1X841127Rq


#### [Regular, revisited - Victor Ciura - Meeting C++ 2023](https://www.youtube.com/watch?v=9ilirLg9TzM&ab_channel=MeetingCpp)

讲value的。听困了    

## 开源项目介绍

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- https://github.com/kamchatka-volcano/figcone 一个反射库，处理配置文件的
- https://github.com/HenryAWE/PapilioCharontis 之前群里说过的带逻辑控制的format，现在基本功能搞定了，欢迎试用体验


## 热门库最近更新了什么


- boost 新的scope库被合入 https://lists.boost.org/Archives/boost/2024/01/255717.php
 
- seastar 最近改动较少

主要是代码规范化 比如 https://github.com/scylladb/seastar/pull/2054

```cpp
@@ -224,11 +225,7 @@ template <typename T, size_t Capacity>
 inline
 circular_buffer_fixed_capacity<T, Capacity>::circular_buffer_fixed_capacity(circular_buffer_fixed_capacity&& x) noexcept
         : _begin(x._begin), _end(x._end) {
-    // This is std::uninitialized_move, but that is c++17 only
-    auto dest = begin();
-    for (auto& obj : x) {
-        new (&*dest++) T(std::move(obj));
-    }
+    std::uninitialized_move(x.begin(), x.end(), begin());
 }
```
另外就是修复bug，延长请求，请求没结束不释放handler https://github.com/scylladb/seastar/pull/2044/


- folly

folly类似seastar 把版本切17之后做了很多的适配和bugfix

比较好玩的是folly::tape 类似`vector<vector>` 但性能更好，常见场景就是 `vector<vector<char>>`

https://github.com/facebook/folly/pull/2109/

在使用场景上做了取舍

实现思路就是拍扁，一维，比如`tape<vector<char>>` 就是`vector<char>`, 记录所有元素的index和offset

没有SSO优化的话，这种形态比`vector<vector<char>>`局部性要好

感兴趣大家可以以及看一看


- brpc

改动非常多，一月改动如下

- 支持内存内置服务，web可查 tcmalloc https://github.com/apache/brpc/pull/2505)
- fuzz测试，上面讲过的fuzz不会写，可以学学这个 https://github.com/apache/brpc/pull/2420
- gdb脚本修复libc++ 符号问题，以及lldb脚本 https://github.com/apache/brpc/pull/2516/ https://github.com/apache/brpc/pull/2514
- 一个mpsc队列实现 https://github.com/apache/brpc/pull/2492
- 支持 c++20 coroutine 不过暂时没人用 https://github.com/apache/brpc/pull/2121
- 使用tcmalloc的 GetStackTrace 比backtrace 省点计算 https://github.com/apache/brpc/pull/2488
- 修 LoadBalancerWithNaming 内存泄漏 https://github.com/apache/brpc/pull/2503
- 给bthread 加tag分组调度 https://github.com/apache/brpc/pull/2476

还是有很多可以学习的地方都


另外rocksdb我也会更新，这个更新的内容不会放在这里，会单独发

也会放在 https://wanghenshui.github.io/rocksdb-doc-cn 里


## 互动环节

寒冬了兄弟们。最近在群里聊天探讨活路，感叹数据库行业之难活，dead business。

贴近业务才能活，但业务有时候都活不下去。大家都在瞎几把忙

另外就是知识的诅咒吧，沟通尽量实事求是 有可能信息不对等大家不同

所以说读者读到不懂的地方，一定要评论，喷我，不对话交换共识，没有进步

另外最近的每日一题有点难，啥也不是，散会！

---

[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/147.html)
