---
layout: post
title:  第145期
---
# C++ 中文周刊 第145期

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等评论区留言

本期文章由 黄亮Anthony HNY 赞助

2024 01 07

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2024-01-03 第235期](https://mp.weixin.qq.com/s/uf1Sa5YZDZn9DZIP6zIX3Q)


## 文章

#### [现代分支预测：从学术界到工业界](https://zhuanlan.zhihu.com/p/675456587?utm_psn=1727335890022830082)

看个乐呵, 了解概念对于CPU运行还是有点理解的

#### [LLVM中指令选择的流程是啥样的？](https://zhuanlan.zhihu.com/p/675543769?utm_psn=1727335764789129217)


LLVM知识，学吧，都是知识，早晚碰到

#### [【数据结构】Jemalloc中的Radix Tree](https://zhuanlan.zhihu.com/p/675177015?utm_psn=1727335511331631104)
#### [解析Jemalloc的关键数据结构](https://zhuanlan.zhihu.com/p/671608149?utm_psn=1727335367877697536)
jemalloc最新知识，学吧

#### [Optimizing the unoptimizable: a journey to faster C++ compile times](https://vitaut.net/posts/2024/faster-cpp-compile-times/)

编译很慢，怎么抓？

```cpp
#include <fmt/core.h>

int main() {
  fmt::print("Hello, {}!\n", "world");
}
// c++ -ftime-trace -c hello.cc -I include -std=c++20
```

ftime-trace的数据可以放到浏览器的tracing里，比如 chrome://tracing/

![](https://wanghenshui.github.io/assets/2024-trace.png)

firefox可以用这个 https://profiler.firefox.com/from-url/https%3A%2F%2Fvitaut.net%2Ffiles%2F2024-hello-before.json/marker-chart/?globalTrackOrder=0&hiddenLocalTracksByPid=65312-fwx3&thread=0&timelineType=category&v=10

我没看懂他是怎么分析出头文件的耗时的，总之，把string前向声明一下

```cpp

#ifdef FMT_BEGIN_NAMESPACE_STD
FMT_BEGIN_NAMESPACE_STD
template <typename Char>
struct char_traits;
template <typename T>
class allocator;
template <typename Char, typename Traits, typename Allocator>
class basic_string;
FMT_END_NAMESPACE_STD
#else
# include <string>
#endif
```

但是这种接口编译不过

```cpp

template <typename... T>
 FMT_NODISCARD FMT_INLINE auto format(format_string<T...> fmt, T&&... args)
    -> basic_string<char> {
   return vformat(fmt, fmt::make_format_args(args...));
 }
```

因为`basic_string<char>`找不到实现，怎么破？

```cpp
template <typename... T, typename Char = char>
 FMT_NODISCARD FMT_INLINE auto format(format_string<T...> fmt, T&&... args)
    -> basic_string<Char> {
   return vformat(fmt, fmt::make_format_args(args...));
 }

```

然后这个操作就省掉了大量编译时间

#### [Why doesn’t my code compile when I change a shared_ptr<T>(p) to an equivalent make_shared<T>(p)?](https://devblogs.microsoft.com/oldnewthing/20240103-00/?p=109228)

结构是这样的

```c++
class WidgetContainer : IWidgetCallback
{
    //    
};

    auto widget = std::shared_ptr<Widget>(new Widget(this));
```
能不能换成make_shared？不能，因为是private继承

怎么破？
```cpp

    auto widget = std::make_shared<Widget>(
        static_cast<IWidgetCallback*>(this));
```
#### [Did you know about C++26 static reflection proposal (2/N)?](https://github.com/tip-of-the-week/cpp/blob/master/tips/362.md)

```cpp
struct foo {
  int a{};
  int b{};
  int c{};
};

static_assert(3 == std::size(std::meta::nonstatic_data_members_of(^foo)));
```

#### [Inside STL: The deque, implementation](https://devblogs.microsoft.com/oldnewthing/20230810-00/?p=108587)

deque msvc实现有坑爹的地方

|    | gcc          | clang            | msvc  |
| ------------------- | ----------- | ------------------------ | ----------------------- |
| Block size                  | as many as fit in 512 bytes but at least 1 element                               | as many as fit in 4096 bytes but at least 16 elements                                               | power of 2 that fits in 16 bytes but at least 1 element           |
| Initial map size            | 8                                                                                | 2                                                                                                   | 8                                                                 |
| Map growth                  | 2×                                                                              | 2×                                                                                                 | 2×                                                               |
| Map shrinkage               | On request                                                                       | On request                                                                                          | On request                                                        |
| Initial first/last          | Center                                                                           | Start                                                                                               | Start                                                             |
| Members                     | block** map; size_t map_size;<br>iterator first;<br>iterator last;                     | block** map;<br>block** first_block;<br>block** last_block;<br>block** end_block;<br>size_t first;<br>size_t size; | block** map; size_t map_size;<br>size_t first;<br>size_t size;          |
| Map layout                  | counted array                                                                    | simple_deque                                                                                        | counted array                                                     |
| Valid range                 | Pair of iterators                                                                | Start and count                                                                                     | Start and count                                                   |
| Iterator                    | T* current;<br>T* current_block_begin;<br>T* current_block_end;<br>block** current_block; | T* current; block** current_block;           | deque* parent;<br>size_t index;                                      |
| begin()/end() | Copy first and last.                                                    | Break first and first + size into block index and offset.                                   | Break first and first + size into block index and offset. |
| Spare blocks                | Aggressively pruned                                                              | Keep one on each end                                                                                | Keep all                                                          |


 block size太小了



#### windows相关

- [How to allocate address space with a custom alignment or in a custom address region](https://devblogs.microsoft.com/oldnewthing/20231229-00/?p=109204)
- [How do I prevent my ATL class from participating in COM aggregation? DECLARE_NOT_AGGREGATABLE didn’t work](https://devblogs.microsoft.com/oldnewthing/20240101-00/?p=109214)
- [The case of the vector with an impossibly large size](https://devblogs.microsoft.com/oldnewthing/20240105-00/?p=109242)

## 视频

#### [What we've been (a)waiting for? - Hana Dusíková - Meeting C++ 2023 ](https://www.youtube.com/watch?v=_Q9tiEa-jG4&ab_channel=MeetingCpp)

介绍协程并写了个co curl 有点意思，视频我也传B站了 https://www.bilibili.com/video/BV1NG411B7Fy/

代码在这里 https://github.com/hanickadot/co_curl

## 开源项目更新/新项目介绍

- [fmt](https://github.com/fmtlib/fmt/releases) 10.2更新，支持duration打印 %j 还支持这么玩

```cpp
#include <fmt/chrono.h>

int main() {
  fmt::print("{}\n", std::chrono::days(42)); // prints "42d"
}
```

- [mp-units 2.1.0 released!](https://mpusz.github.io/mp-units/2.2/blog/2023/12/09/mp-units-210-released/)

编译期物理计算的

- [nanobind](https://nanobind.readthedocs.io/en/latest/benchmark.html) 一个python binding，速度性能都不错，群友kenshin推荐
- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂

## 工作招聘

https://job.toutiao.com/s/i8Tv36Jf
字节杭州虚拟机v8研发

字节的音视频团队，主要负责剪映上的音视频/非线性编辑相关工作，业务前景也比较好，目前有三个方向的岗位

- 桌面端音视频研发 https://job.toutiao.com/s/i8enPrw5
- 多端音视频引擎研发 https://job.toutiao.com/s/i8enr7Es
- C++工程基础架构研发 https://job.toutiao.com/s/i8enjTHT

base北上广深杭都可以，薪资open，有兴趣的同学可以通过链接投递

## 互动环节

新的一年开始了，本周刊也走过了三个年头，希望大家都健康我也继续保持更新下去

---

[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/145.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
