---
layout: post
title:  第138期
---
# C++ 中文周刊 第138期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [手机qq点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)


最近在找工作准备面试题，更新可能有些拖沓，见谅


本期文章由 不语 黄亮 赞助

---


## 资讯

标准委员会动态/ide/编译器信息放在这里

c++26进展如火如荼 反射又又又又又一次被端了出来，给了一堆符号语法，我说婷婷吧，感觉够呛

感兴趣的可以看看这个 [C++26静态反射提案解析](https://zhuanlan.zhihu.com/p/661692275)

我觉得我不是第一个讨厌这个语法的人

boost 1.84预览版出炉 https://www.boost.org/users/history/version_1_84_0.html

新加入cobalt协程组件和redis客户端两个库，都是堆在asio上面的。可以偷学一下，卷死同行

什么！你说asio你都没研究过，算了还是别研究了，周末应该休息，看一乐就行了

编译器信息最新动态推荐关注hellogcc公众号 [OSDT Weekly 2023-11-15 第228期 ](https://mp.weixin.qq.com/s/4hU89AP-EDfHii5je3Fz_A)
    
## 文章

- [Coroutine 重构数据库算子——以 hash join probe 为例](https://zhuanlan.zhihu.com/p/666465496)

这个是我第一次见到计算层引入协程的实践，之前有个corobase论文，另外像scylladdb redpanda更多是把协程放在简单任务逻辑以及文件处理上

这个还是挺精彩的

- [Why does calling a coroutine allocate a lot of stack space even though the coroutine frame is on the heap?](https://devblogs.microsoft.com/oldnewthing/20231115-00/?p=109020)

为啥coroutine需要额外的栈空间？协程栈不应该在heap上吗？

比如这坨代码

```c++
#include <coroutine>
#include <exception>

// Define a coroutine type called "task"
// (not relevant to scenario but we need *something*.)
struct task { void* p; };

namespace std
{
    template<typename...Args>
    struct coroutine_traits<task, Args...>
    {
        struct promise_type
        {
            task get_return_object() { return { this }; }
            void unhandled_exception() { std::terminate(); }
            void return_void() {}
            suspend_never initial_suspend() { return {}; }
            suspend_never final_suspend() noexcept { return {}; }
        };
    };
}
// End of "task" boilerplate.

void consume(void*);

task sample()
{
    char large[65536];
    consume(large);
    co_return;
}
```

因为这个coroutine并不会suspend，能走heap allocation elision优化HALO

可能这种场景你可能得关注栈溢出问题，如果你是msvc用户，恭喜你，msvc有bug，没做优化，还是在堆heap上

为什么没做优化？做了，但是没完全生效，代码里写了生成 __coro_elision_buffer 

但没判断出__coro_elision_buffer 完全没用没彻底优化掉。[已经在修了](https://developercommunity.visualstudio.com/t/Coroutine-reserves-stack-space-for-heap/10270583) 

当然这种优化是好的，只是提醒你注意你的协程局部对象生命周期而已，你要是害怕，这么玩也不是不行

```c++
task sample()
{
    auto large = std::make_unique_for_overwrite<char[]>(65536);
    consume(large.get());
    co_return;
}
```

- [莫非我遇到了传说中的bug](https://zhuanlan.zhihu.com/p/665981703)

很精彩的bit反转，客户端确实少见

- [深入浅出 LLVM之 Value 、User 、Use 源码解析](https://zhuanlan.zhihu.com/p/666016704)
- [LLVM源码阅读之 BasicBlock 遍历](https://zhuanlan.zhihu.com/p/664407911)

了解llvm的，看一乐, 作者还是学生，挺厉害的

- [C++ Pitfall : shared_future](https://sheep.horse/2023/11/c++_pitfall_-_shared_future.html)

shared_future::get有复制，注意T的复制是否过重

作者建议干脆别用

- [深入理解基于 eBPF 的 C/C++ 内存泄漏分析](https://zhuanlan.zhihu.com/p/665778795)

其实就是memcheck

- [std::source_location is Broken](https://www.elbeno.com/blog/?p=1738)

std::source_location本应该是编译期字符串，但是却只提供一个const char *

脑瘫接口

- [C++23 Characters](https://euroquis.nl//blabla/2023/11/16/cpp.html)


```c++
QString getSheep() {
  return QStringLiteral("🐑");
}
```

这个🐏怎么打呢

```c++
QString getSheep() {
  return QStringLiteral("\N{SHEEP}");
}
```

目前这种用法也就clang15支持

- [Why Do Peephole Optimizations Work?](https://blog.regehr.org/archives/2485)

首先要知道peephole优化是啥，

简单说就是小汇编代码段重写，删除，代数优化，降低寄存器复用提高吞吐 简化控制流 指令合一



- [Generating arrays at compile-time in C++ with lambdas](https://lemire.me/blog/2023/11/07/generating-arrays-at-compile-time-in-c-with-lambdas/)

考虑一个打表

```c++
constexpr static bool is_forbidden_host_code_point_table[] = {
  1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
bool is_forbidden_host_code_point(char c) {
  return is_forbidden_host_code_point_table[uint8_t(c)];
}
```


一个一个敲，眼睛都花了。怎么生成？感谢constexpr

```c++
constexpr static std::array<uint8_t, 256> is_forbidden_array = []() {
  std::array<uint8_t, 256> result{};
  for (uint8_t c : {'\0', '\x09', '\x0a','\x0d', ' ', '#', '/', ':',
    '<', '>', '?', '@', '[', '\\', ']', '^', '|'}) {
   result[c] = true;
  }
  return result;
}();

bool is_forbidden_host_code_point_array(char c) {
  return is_forbidden_array[uint8_t(c)];
}
```

编译器帮我打表。快说谢谢constexpr

- [“Memset” in O1](https://www.dyx.name/notes/memset-o1.html)

加个flag标记初始化过了

好好好你这么整是吧

## 开源项目介绍

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

最近进展，优化JIT/基础组件调优，对于做语言的还是能见识到一点东西的

- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂
- https://github.com/hggq/paozhu 一个网络框架
- https://gitee.com/okstar-org/ok-edu-desktop 一个IM通信软件，做IM的可以关注，现在正在做全面整合阶段，开始组建商业团队阶段，年底开始融资，你参加了就快发财了，会的快来
- https://github.com/volt-software/Ichor/tree/v0.3.0 一个c++20 服务框架

有个哥们给gcc加上了特殊的翻译 https://github.com/Mosklia/gcc-hentai

预览效果 喜剧效果比较强 

![](https://user-images.githubusercontent.com/8872493/282465333-8a2073bf-565a-4051-b6e6-0f805e5cb3ed.jpg)

## 视频

- `*(char*)0 = 0;` - What Does the C++ Programmer Intend With This Code? - JF Bastien - C++ on Sea 2023 https://www.youtube.com/watch?v=dFIqNZ8VbRY

这哥们非常夸张

其实这个在嵌入式比较常见，就是给内存0的地方清零

由于众所周知的问题，nullptr的值是0，linux windows访问0地址直接崩溃，毕竟UB

你为啥这么写？作者讲这个为什么讲了一个小时我靠

精彩是精彩，有点长了，喜欢脱口秀的可以看看


## 互动环节

最近看到俩bug

一个是存储引擎 字符串比较用strcmp

一个是编解码 string.substr(0,0)

另外在知乎看到的 https://www.zhihu.com/question/630025869

```c++
std::vector<int> vec{10,2,2,10};
auto max_iter = std::max_element(vec.begin(), vec.end());
vec.erase(std::remove(vec.begin(), vec.end(), *max_iter), vec.end());
// vec中的元素变成了{2,10}
```

这个是经典alias语义问题，也是为啥大家实现decay_copy的源头，还是有人能遇到

读者们有没有好玩的bug，欢迎评论区反馈

话说我也写过不同基类虚函数同名字导致查找莫名其妙匹配的bug，哈哈。互坑