---
layout: post
title:  第135期
---
# C++ 中文周刊 第135期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [手机qq点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢  不语  赞助

最近在找工作准备面试题，更新可能有些拖沓，见谅

---

## review request

@_AWE_ 写的一个库https://github.com/HenryAWE/PapilioCharontis

大概是一个增加了控制逻辑的fmt（比如可以根据格式化参数的数值，决定输出的字符串中某个单词是否须为复数形式）

现在还在很初期的阶段，请求大家意见，有空的可以狠狠的批评一下

## 资讯

标准委员会动态/ide/编译器信息放在这里

编译器信息最新动态推荐关注hellogcc公众号 [OSDT Weekly 2023-10-25 第225期 ](https://mp.weixin.qq.com/s/pw-3tApqW-26cKuBGladyQ)

#### 语雀崩了七个小时了

这个和之前gitlab崩溃几天那个问题有点像，数据库下线然后全量回滚数据库耽误太多时间

测试环境没测，多地多中心没做，回滚备份太慢

还有啥角度可以批判批判？

#### BS tour c++再版

笔者不太推荐哈，BS写书太絮絮叨叨了，现代C++白皮书看了没，那个没看就别看他新书了

#### 除夕不放假

额。。。感觉说啥都不太好

## 文章

#### [雾里看花：真正意义上的理解C++模板(Template)](https://zhuanlan.zhihu.com/p/655902377)

评论区倒是值得一看

#### [复杂 C++ 项目堆栈保留以及 ebpf 性能分析](https://selfboot.cn/2023/10/17/c++_frame_pointer/)

编译要带上 `-fno-omit-frame-pointer` 方便perf bcc 抓堆栈

#### [一剑破万法：noexcept与C++异常导致的coredump](https://zhuanlan.zhihu.com/p/609434714)

尽可能加noexcept 帮助定位函数问题


#### [读《C++ Core Guidelines》有感 ](https://zhuanlan.zhihu.com/p/662859288)

很多typo说是

#### [modern C++真的很烂: variant篇](https://zhuanlan.zhihu.com/p/645810896)

看一乐

#### [【XMake】02 如何优雅的编写C++代码](https://zhuanlan.zhihu.com/p/655452448)

学学xmake

#### [C++ 内存问题排查：创建 Zip 压缩包，解压后内容错乱](https://selfboot.cn/2023/10/19/c++_zip_memory_problem/)

我直接贴代码吧

```c++
zip* archive = zip_open(tmpFile, ZIP_CREATE | ZIP_TRUNCATE, &error);
if (archive == NULL) {
    printf("fail to open %s err %d", tmpFile, error);
    return 1;
}

zip_source* s = NULL;
for (auto item : FileInfos) {
    if (NULL == (s = zip_source_buffer(archive, item.htmltemlate.c_str(), item.htmltemlate.size(), 0)) ||
        zip_file_add(archive, (item.filename + "_temp.xhtml").c_str(), s, ZIP_FL_ENC_UTF_8 | ZIP_FL_OVERWRITE) < 0) {
        zip_source_free(s);
        printf("fail to add info.txt err %s", zip_strerror(archive));
        error = -1;
    }
}

if (zip_close(archive) < 0) {
    printf("fail to close %s ret %d", tmpFile, error);
    return 1;
}
```
你能看出来问题出在哪里吗 ~~buffer archive生命周期问题~~

看不出来的话，原博客教你手把手gdb定位

#### [为什么C++20是最awesome的网络编程语言](https://zhuanlan.zhihu.com/p/662972177?utm_id=0)

asio结合coroutine演化，有点意思

#### [How do I add a non-copyable, non-movable object to a std::map or std::unordered_map?](https://devblogs.microsoft.com/oldnewthing/20231023-00/?p=108916)

简单来说就是

```c++
struct weird {
    int value;
    std::mutex mtx;
};

std::map<int, weird> table;

table.insert({ 1, {} }); // nope
table.insert_or_assign(1, weird{}); // nope
table.emplace({ 1, {} }); // nope
table.emplace(1, weird{}); // nope
table.try_emplace(1, weird{}); // nope
```
mutex不能拷贝，这种怎么在map中构建？placement_construct


```c++
table.emplace(std::piecewise_construct,
    std::forward_as_tuple(1),
    std::forward_as_tuple("used to construct weird"));
```

你学会了吗

另外map的try_emplace 有优化效果，最优场景O1 熟悉一下API

#### [Implementing #embed for C and C++](https://thephd.dev/implementing-embed-c-and-c++)

手把手实现#embed

## 视频


### 2023 purecpp大会ppt和视频

ppt在这

http://purecpp.cn/detail?id=2390

视频

https://live.csdn.net/room/csdnlive4/AeyB4tmD


maskray讲的lld优化比较有意思

压轴的coro http案例/代码调优也有点意思

感兴趣的可以看看

### 其他

- P99 CONF 2023 | Adventures in Thread-per-Core Async with Redpanda and Seastar by Travis Downs

redpanda有一些coroutine实践，有点意思

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂
- https://gitee.com/okstar-org/ok-edu-desktop 一个IM通信软件，做IM的可以关注，现在正在做全面整合阶段，开始组建商业团队阶段，年底开始融资，你参加了就快发财了，会的快来

## 新的开源项目

- trpc-cpp开源了。腾讯用的挺多的，还是值得一学的，类似brpc，但是调度不同 worksteal有taskflow那种类似的设计

## 工作招聘

- 金山找写qt的，详情点链接 https://app.mokahr.com/m/recommendation-apply/wps/29467?recommendCode=NTAA6lb&code=001hEK0w3Mxvx13gAN1w3Auy1f3hEK0a&state=3#/job/a713bff8-9e6d-433e-b923-4bbcf593284b?from=qrcode&isRecommendation=true

- 华为云数据库老东家一直在招人，nosql方向

华为云数据库团队广纳英才，社会招聘火热进行中（华为自有岗！！！）。

年底冲刺，HC开放，只限两周，有兴趣直接联系我，具体产品的华为云NoSQL数据库方向。

这边用上C++20了，技术上非常open。可以加irelandken帮忙推荐

老东家，技术大牛还是有很多的



## 互动环节

列几个面试题，群里激烈讨论了半天，考考大家

- 三个文件 分别是1g 5g 10g，每行存ip，机器限制内存500m 磁盘空间可以理解成无限，找出同时在三个文件中存在的出现次数最多的ip

设计一个算法

其实这个属于比较常规的大数据题

- 用一个每次抛出正面向上概率为P的硬币生成等概率01随机变量？

数学题我超，答案可以看这里 https://www.zhihu.com/question/304075115

- 考虑一个投掷硬币问题

背景:小P和小H分别选择一个4个硬币组成的序列(正面由U表示，反面由D表示)，一枚硬币每次会公正的投掷并记录结果，先出现的序列为获胜者。

问题:给定小P选择的一个序列,请为小H设法给出胜率最大的对应序列,并给出C++/python代码

实例:小P选择 DDDD，小H可以选择UDDD

扩展:将4改为任意有限正整数，你会如何优化你的计算？


