---
layout: post
title:  第131期
---
# C++ 中文周刊 第131期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [手机qq点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢许琦赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-09-06 第218期 ](https://mp.weixin.qq.com/s/CxkDMSIND4tn2Ad5LgT4mw)


## 文章

#### [std::mdspan for C++23入门](https://zhuanlan.zhihu.com/p/653155513)

之前也介绍过很多次了

#### [C++ 编译期多态 - poly 实现剖析](https://zhuanlan.zhihu.com/p/654397993)

介绍poly的原理


#### [优雅的实现多线程环境下的协程调度 - 再谈 ASIO 与 Coroutine](https://zhuanlan.zhihu.com/p/654363849)

对ASIO和coroutine 分析很深，值得一看涨涨见识

#### [从无栈协程到C++异步框架](https://zhuanlan.zhihu.com/p/654360600)

对协程讨论很深，值得一看


#### [现代 C++ 及其在 ClickHouse 中的应用](https://zhuanlan.zhihu.com/p/655663455)

讲一些c++的使用。值得一看
#### [基于 eBPF 的内存泄漏（增长）通用分析方法探索](https://zhuanlan.zhihu.com/p/652850051)

有点意思
#### [Formatting Text in C++: The Old and The New Ways](https://mariusbancila.ro/blog/2023/09/12/formatting-text-in-c-the-old-and-the-new-ways/)

压测了一下几种格式化，format/format_to还是比printf之类的更快的 (还用你说？)



#### [Did you know that C++26 allows constexpr cast from void*](https://github.com/tip-of-the-week/cpp/blob/master/tips/345.md)

c++26可以硬转const *了

比如

```c++
struct Animal_View {
    const void *animal;
    std::string_view (*speak_func)(const void *animal);

    template <class Animal>
    Animal_View(const Animal &animal)
        : animal(&animal), speak_func([](const void *animal) {
              return static_cast<const Animal *>(animal)->speak();
          }) {}

    constexpr std::string_view speak() { return speak_func(animal); }
};
```

#### [Did you know that C++26 added more constexpr for cmath and complex](https://github.com/tip-of-the-week/cpp)


```cpp
#include <cmath>
constexpr auto positive = std::abs(-2);
static_assert(positive == 2);

```

没啥说的


#### [Did you know that C++26 added testing for success or failure of functions?](https://github.com/tip-of-the-week/cpp/blob/master/tips/346.md)

以前to_chars要判断接受两个返回值处理另一个，c++26加一个operator bool

类似这种

```cpp
constexpr std::to_chars_result result{{}};
static_assert(result);
```


#### [Transcoding Unicode strings at crazy speeds with AVX-512](https://lemire.me/blog/2023/09/13/transcoding-unicode-strings-at-crazy-speeds-with-avx-512/)

SIMD时间，其实可以理解成 https://github.com/simdutf/simdutf 的推销帖


#### [Making Gaussian Splats smaller](https://aras-p.info/blog/2023/09/13/Making-Gaussian-Splats-smaller/)

图像算法的玩意，没看懂    


####  [Compile-time sizes for range adaptors](https://www.foonathan.net/2023/09/compile-time-sizes-range-adaptors/)


```cpp
template <auto Fn, typename ... Rng>
constexpr auto compute_range_adaptor_size(Rng&&... rng)
{
    if constexpr ((tc::has_constexpr_size<Rng> && ...))
    {
        auto constexpr value = Fn(tc::constexpr_size<Rng>()...);
        return std::integral_constant<std::size_t, value>{};
    } else
    {
        auto const value = Fn(tc::size(std::forward<Rng>(rng))...);
        return value;
    }
}

template <typename ... Rng>
struct concat_adaptor
{
    constexpr auto size() const
        requires (tc::has_size<Rng> && ...)
    {
        return std::apply([](auto const& ... base_rng) {
            return tc::compute_range_adaptor_size<[](auto const ... n) {
                return (n + ...);
            }>(base_rng...);
        }, base_rng_tuple);
    }
};

```

我看不懂

#### [Constexpr functions for smaller binary size?](https://www.sandordargo.com/blog/2023/09/13/constexpr-and-binary-sizes)

有人发帖说constexpr简化代码能让二进制代码更小，作者反驳

其实主要和优化有关系，和constexpr关系不是很大

#### [Yet Another C++ Coroutine Tutorial](https://theshoemaker.de/posts/yet-another-cpp-coroutine-tutorial) 

这哥们写了个库 https://github.com/pfirsich/aiopp/

总结了个教程，手把手教你写task。我觉得还是值得一看的


#### [Small String Optimization (SSO) in C++](https://rrmprogramming.com/article/small-string-optimization-sso-in-c/)

这个应该没人不知道吧

## 视频

#### [C++ Weekly - Ep 393 - C++23's std::unreachable](https://www.youtube.com/watch?v=ohMyb4jPIAQ&ab_channel=C%2B%2BWeeklyWithJasonTurner)

这玩意没堆栈信息


####  [Exceptions in C++: Better Design Through Analysis of Real World Usage - Peter Muldoon - CppNow 2023](https://www.youtube.com/watch?v=HXJmrMnnDYQ&ab_channel=CppNow)

值得一看，介绍坑爹execption的方方面面

b站链接 https://www.bilibili.com/video/BV16C4y1f79m/


## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂


## 新项目介绍/版本更新

- https://github.com/lemire/simdcomp simd 整数压缩
  
一些封装liburing的库

https://github.com/pfirsich/aiopp/

https://github.com/cmazakas/fiona

https://github.com/CarterLi/liburing4cpp

https://github.com/pabloariasal/couring 这个还有博客 https://pabloariasal.github.io/2022/11/12/couring-1/ 介绍设计

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/131.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
