---
layout: post
title:  第125期
---
# C++ 中文周刊 第125期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">


RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)


---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-08-02 第213期 ](https://mp.weixin.qq.com/s/OTXzjzx1RpsqZLbkJDDafQ)


## 文章

- [RocksDB 源码阅读系列](https://zhuanlan.zhihu.com/p/646776844)

写的不错

- [Understanding Ranges Views and View Adaptors Objects in C++20/C++23 ](https://www.cppstories.com/2023/cpp20-understanding-views-impl/)

```cpp
#include <ranges>
#include <vector>
#include <iostream>

int main() {
    std::vector<int> r = {1, 2, 3, 4, 5};
    auto reversed = r | std::views::reverse;
    for (auto i : reversed)
        std::cout << i << " ";
        
    // same as:
    //for (auto i : r | std::views::reverse)
        //std::cout << i << " ";
    
    std::cout << '\n';
    std::ranges::reverse_view rv(r);
    for (auto i : rv)
        std::cout << i << " ";
}
```

探讨这玩意是怎么实现的

- [soagen: A Structure-of-Arrays generator for C++ ](https://marzer.github.io/soagen/) 

帮你把结构体组成的数组这种行存转换为数组结构体模式列存

是代码帮你生成tuple。有点繁琐

- [Did you know that C++26 added user-generated static_assert messages?](https://github.com/tip-of-the-week/cpp)

```c++
static_assert(false, std::string_view{"message"});

```

既然能string_view 也就可以fmt

```cpp
template<auto... Cs>
constexpr auto format(const string<Cs...> fmt, auto&&... args) {
    std::array<char, sizeof...(Cs)> a{};
    for (auto i = 0; i < sizeof...(Cs); ++i) {
        if (fmt.str[i] == '{' and fmt.str[i+1] == '}') {
            a[i] = '0'+(args,...);
            a[++i] = ' ';
        } else {
            a[i] = fmt.str[i];
        }
    }
    return a;
};

struct foo {};
static_assert(sizeof(foo) == 0, format("Unexpected sizeof: expected 0, got {}"_s, sizeof(foo)));

```

- [Inside STL: The pair and the compressed pair](https://devblogs.microsoft.com/oldnewthing/20230801-00/?p=108509)

没啥说的。能省点空间

```cpp
template<typename T1, typename T2>
struct compressed_pair {
    [[no_unique_address]] T1 first;
    [[no_unique_address]] T2 second;
};

```

- [Inside STL: The string](https://devblogs.microsoft.com/oldnewthing/20230803-00/?p=108532)

介绍string对小字符串做的优化，类似clang::string的实现分析

- [ A Gentle Introduction to LLVM IR](https://mcyoung.xyz/2023/08/01/llvm-ir/)

光速入门

- [MySQL · 源码剖析 · LF_HASH无锁实现](https://zhuanlan.zhihu.com/p/452849776)

亮点还是扩容不需要迁移，很有意思

- [Misinterpreting the misleadingly-named STATUS_STACK_BUFFER_OVERRUN](https://devblogs.microsoft.com/oldnewthing/20230731-00/?p=108505)

看不懂

## 视频

meeting cpp推荐了十个，我把我感兴趣的列一下

[Daniel Withopf - Compile-time Is the New Constexpr: Leveraging Compile-time Sparsity for Vectors and Matrices](https://www.youtube.com/watch?v=PybIAMIZrVE&ab_channel=CppNow)

大概意思是利用constexpr算某些场景比elgen快

[Filipp Gelman - What I learned From Sockets](https://www.youtube.com/watch?v=DA6AGCadH60&ab_channel=ACCUConference)

讲了一堆设计。没有代码，听个乐


## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂


## 新项目介绍/版本更新

- [battery-embed](https://github.com/batterycenter/embed)

std::embed没有之前能对付用的替代品

- https://tavianator.com/2023/bfs_3.0.html1

这哥们写了个find，和bfs一个原理，并发宽度优先遍历，find默认是dfs。

实际效果比find快百倍。很有意思。可以装一个玩玩

- https://github.com/jll63/yomm2/blob/master/reference/virtual_ptr.md

一个fat pointer实现

- https://github.com/DeveloperPaul123/thread-pool/tree/0.6.2

一个实现了work steal的线程池

关于 work steal，道理都懂，可能还需要看看https://www.youtube.com/watch?v=iLHNF7SgVN4&ab_channel=CppCon 了解下
## 工作招聘

有没有可以远程的工作可以推荐给我，我也快失业了

## API Design

最近群里收集了一些想要讨论的点子，大家比较关注API设计，我这里把一些资料放在这里。可能后面会做个视频

https://www.youtube.com/watch?v=zL-vn_pGGgY&ab_channel=CppCon

https://www.youtube.com/watch?v=2UmDvg5xv1U&ab_channel=CppNow

https://www.acodersjourney.com/top-25-cplusplus-api-design-mistakes-and-how-to-avoid-them/

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/125.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
