---
layout: post
title:  第124期
---
# C++ 中文周刊 第124期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢 `振羽` `不语` 赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

七月邮件列表

https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2023/#mailing2023-07

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-07-26 第212期 ](https://mp.weixin.qq.com/s/1xam__Dwb5FAeZyTBUItWA)



## 文章

- [理论上所有编程语言都可以编译成LLVM IR，请问为什么他们之间还会存在性能差异呢](https://www.zhihu.com/question/545005023/answer/3132407932)

有点意思

- [Did you know that C++26 added bind front and back to NTTP callables? ](https://github.com/tip-of-the-week/cpp/blob/master/tips/340.md)

```c++
struct foo {
  auto bar(int v) { return v; }
};

static_assert(42 == std::bind_front<&foo::bar>(foo{}, 42));
```

不懂啥意思

- [Notes on float and multi-byte delta compression](https://cbloomrants.blogspot.com/2023/07/notes-on-float-and-multi-byte-delta.html)
- [Float to int casts for data compression ](http://cbloomrants.blogspot.com/2023/07/float-to-int-casts-for-data-compression.html)

讲浮点数压缩的，没看懂。这里标记个TODO后面研究一下

- [Decoding base16 sequences quickly](https://lemire.me/blog/2023/07/27/decoding-base16-sequences-quickly/)

SIMD时间，这回不贴代码了。https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/tree/master/2023/07/27


- [Nubbing lists in C++](https://0xd34df00d.me//posts/2023/07/nubbing-lists.html)



作者想把

`constexpr std::tuple<int, double, int, double, float> { 1, 2.0, 1, 3.0, 2.0 }` 

变成 `constexpr std::tuple<int, double, double, float> { 1, 2.0, 3.0, 2.0 }`
简单方案就是`boost::mp_list`,或者看这个 https://stackoverflow.com/questions/55941964/how-to-filter-duplicate-types-from-tuple-c

但作者想要的是如果值相等才把类型吃掉，有点点难

直接贴代码吧，我看不懂，作者推导了半天

```cpp
#include <functional>
#include <tuple>

template<typename T1, typename T2>
consteval bool JMEq(const T1& v1, const T2& v2) {
	if constexpr (!std::is_same_v<T1, T2>)
		return false;
	else
		return v1 == v2;
}

template<const auto& F>
constexpr auto Nub() {
	constexpr auto tup = F();
	constexpr auto indices = std::make_index_sequence<std::tuple_size_v<decltype(tup)>> {};

	return [&]<std::size_t... Ix>(std::index_sequence<Ix...>)
	{
		return std::tuple_cat ([&]
			{
				constexpr auto index = Ix;
				constexpr auto element = std::get<index>(tup);

				if constexpr (((JMEq(element, std::get<Ix>(tup)) && Ix < index) || ...))
					return std::tuple {};
				else
					return std::tuple { element };
			} ()...);
	} (indices);
}

constexpr auto structuralize(auto tuple){
	return std::apply([]<typename... Args>(Args... args) { return ST<Args...>(args...); }, tuple);
}

constexpr std::tuple<int, double, int, double, float> input { 1, 2.0, 1, 3.0, 2.0 };
constexpr std::tuple<double, int, double, float> expected { 2.0, 1, 3.0, 2.0 };
constexpr auto actual = Nub<structuralize(input)>();
static_assert(expected == actual);
```
- [C++23: static operator() and static operator\[\]](https://www.sandordargo.com/blog/2023/07/26/cpp23-static-call-and-subscript-operator)

简单说就是lambda是对象，有时候不捕获的lambda也是对象，和函数指针差不多，太浪费了，于是引入了static lambda,static operator

```cpp
auto isEven = [](int i) static {return i % 2 == 0;};
```
如果捕获会报错

```cpp
// ERROR: 'static' lambda specifier with lambda capture
auto isDivisableBy = [operand](int i) static {return i % operand == 0;};
```

其实static operator[]原因也差不多。代码就不列举了

## [Perfect forwarding forwards objects, not braced things that are trying to become objects](https://devblogs.microsoft.com/oldnewthing/20230727-00/?p=108494)

forward对于 initializer_list对象行不通，initializer_list真该死啊
```cpp
template<typename T, typename... Args>
std::unique_ptr<T> make_unique(Args&&... args){
    return std::unique_ptr<T>(
        new T(std::forward<Args>(args)...));
}
```

这样就不行

```cpp
struct Point {
    int x, y;
};

struct Segment {
    Segment(Point p1, Point p2);
};

void test() {
    // This works
    Segment s({ 1, 1 }, { 2, 2 });

    // This doesn't
    auto p = std::make_unique<Segment>(
        { 1, 1 }, { 2, 2 });
}

```

封装一层吧

```cpp
struct Segment {
    Segment(Point p1, Point p2);
    template<typename Arg1 = Point,
             typename Arg2 = Point>
    static std::unique_ptr<Segment> make_unique(
        Arg1&& p1, Arg2&& p2) {
        return std::make_unique<Segment>(
            std::forward<Arg1>(p1),
            std::forward<Arg2>(p2));
    }
};
```

这样就行了


- [Why does IAsyncAction or IAsyncOperation.GetResults() produce a E_ILLEGAL_METHOD_CALL ](https://devblogs.microsoft.com/oldnewthing/20230724-00/?p=108477)
- [On the various ways of creating Windows Runtime delegates in C++/WinRT and C++/CX](https://devblogs.microsoft.com/oldnewthing/20230726-00/?p=108487)

讲winrt的。不说了

## 视频

本周视频很多 cppnow 2023来了。基本上讲的是今年cppcon的前瞻内容

- [A Deep Dive Into Dispatching Techniques in C++ - Jonathan Müller - CppNow 2023](https://www.youtube.com/watch?v=vUwsfmVkKtY&ab_channel=CppNow)

这个是之前他写的博客，直接做成视频讲了一遍，就是讲用tag dispatch替换switch加速的

ppt在这里 https://github.com/boostcon/cppnow_presentations_2023/blob/main/cppnow_slides/A_Deep_dive_into_dispatching_techniques.pdf

周末有空我就传一下

- [Introduction to C++ Coroutines Through a Thread Scheduling Demonstration - Dian-Lun Lin CppNow 2023](https://www.youtube.com/watch?v=kIPzED3VD3w&ab_channel=CppNow)

这个华人哥们讲的也有点意思

- [Non-Uniform Memory Architecture (NUMA): A Nearly Unfathomable Morass of Arcana - Fedor Pikus CppNow](https://www.youtube.com/watch?v=f0ZKBusa4CI&ab_channel=CppNow)

介绍numa的，有点意思

- [Obfuscate Logs Without an External Script by Executing Uninvoked C++ Code - Andrei Zissu CppNow 23](https://www.youtube.com/watch?v=R7RcvNsg0yo&ab_channel=CppNow)

敏感字符串过滤？hash绕过

- [Data-Oriented Design and Modern C++ - Floris Bob van Elzelingen - CppNow 2023](https://www.youtube.com/watch?v=GoIOnQEmXbs&ab_channel=CppNow)

感觉之前说过，还是布局之类的。没有细看

- [C++ Coroutine Intuition - Roi Barkan - CppNow 2023](https://www.youtube.com/watch?v=NNqVt73OsfI&ab_channel=CppNow)

这个教程也不错，手把手带你了解协程以及一个task模型

- [C++ Electronic Trading for Cpp Programmers - Mathias Gaunard - ACCU 2023](https://www.youtube.com/watch?v=ltT2fDqBCEo&ab_channel=ACCUConference)

讲高频交易的，很干货。值得一看

- [Introduction to Epoch-Based Memory Reclamation - Jeffrey Mendelsohn - ACCU 2023](https://www.youtube.com/watch?v=KHVEiSHaEDQ&ab_channel=ACCUConference)

讲基于epoch的内存回收的。epoch推进技术其实已经不是新东西了。到处都可见，或多或少要了解一下。了解背景之后值得看看

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂


## 新项目介绍/版本更新

- https://github.com/bloomberg/blazingmq 有点意思
- mold 2.0发布 https://github.com/rui314/mold/releases/tag/v2.0.0 之前商业化license发展不是很顺利，又改成MIT了，寻求赞助 开源真难搞啊

## 工作招聘

- 求不需要算法题笔试的可以远程的工作，我的邮箱wanghenshui@qq.com

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/124.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
