---
layout: post
title:  第120期
---
# C++ 中文周刊 第120期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢不语赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-06-28 第208期 ](https://mp.weixin.qq.com/s/NBrrr23WAZRzvamvtdZ0Yg)


## 文章

- [Did you know about gnu::vector_size extension?](https://github.com/tip-of-the-week/cpp/blob/master/tips/336.md)

```cpp
int main() {
  using v4si = int [[gnu::vector_size(4 * sizeof(int))]];

  v4si a = {1, 2, 3, 4};
  v4si b = {4, 3, 2, 1};
  v4si c;

  c = a + b;
  std::cout << c[0] << c[1] << c[2] << c[3]; // prints 5555
}
```

这玩意是给simd方便的。看gcc样例

```c
#include <immintrin.h>

typedef unsigned char u8x16 __attribute__ ((vector_size (16)));
typedef unsigned int  u32x4 __attribute__ ((vector_size (16)));

typedef union {
        __m128i mm;
        u8x16   u8;
        u32x4   u32;
} v128;

v128 x, y = { 0 };
memcpy (&x, ptr, sizeof x);
y.u8  += 0x80;
x.mm  = _mm_adds_epu8 (x.mm, y.mm);
x.u32 &= 0xffffff;

/* Instead of a variable, a compound literal may be used to pass the
   return value of an intrinsic call to a function expecting the union: */
v128 foo (v128);
x = foo ((v128) {_mm_adds_epu8 (x.mm, y.mm)});
```

- [移植MySQL 8.0的函数跟踪库到rocksdb](https://zhuanlan.zhihu.com/p/638545766)

这个debug宏很好用，方便阅读，代码在这里 https://github.com/nosql-cn/AxeDB

不过既然已经编译了，通过clangd 应该也能抓到堆栈。不过静态的堆栈没有这种运行时堆栈有意义，运行时的更直观一些

- [Finite State Machine with std::variant](https://www.cppstories.com/2023/finite-state-machines-variant-cpp/)

知乎有人翻译成中文了，挺好。 https://zhuanlan.zhihu.com/p/639886110

原理就是`std::variant` + `std::visit`


- [C++ standard library ABI compatibility](https://maskray.me/blog/2023-06-25-c++-standard-library-abi-compatibility)

看不懂

- [Valgrind - A Framework for Heavyweight Dynamic Binary Instrumentation 论文翻译](https://zhuanlan.zhihu.com/p/640105594)

了解一波

- [从源码吃透共识协议：braft 日志复制](https://zhuanlan.zhihu.com/p/635963776)

代码走读，感兴趣的可以看看

- [Polymorphic types aren’t trivially relocatable](https://quuxplusone.github.io/blog/2023/06/24/polymorphic-types-arent-trivially-relocatable/)

还是讲他的relocatable提案

- [AddressSanitizer continue_on_error](https://devblogs.microsoft.com/cppblog/addresssanitizer-continue_on_error/)

介绍vs上体验AddressSanitizer新特性COE(continue_on_error)

用 ` -fsanitizer=address` 同时设置
```bash
    set ASAN_OPTIONS=continue_on_error=1
    set ASAN_OPTIONS=continue_on_error=2
```

- [Dynamic bit shuffle using AVX-512](https://lemire.me/blog/2023/06/29/dynamic-bit-shuffle-using-avx-512/)

打散一个64字节的数的场景

```cpp
uint64_t w = some value;
uint8_t indexes[64] = {63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51,
                       50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38,
                       37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25,
                       24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12,
                       11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
bit_shuffle(w, indexes); // returns a reversed version 
```

可能的实现

```cpp
uint64_t slow_bit_shuffle(uint64_t w, uint8_t indexes[64]) {
  uint64_t out{};
  for (size_t i = 0; i < 64; i++) {
    bool bit_set = w & (uint64_t(1) << indexes[i]);
    out |= (uint64_t(bit_set) << i);
  }
  return out;
}
```
考虑avx512

```cpp
uint64_t bit_shuffle(uint64_t w, uint8_t indexes[64]) {
  __mmask64 as_mask = _cvtu64_mask64(w);
  __m512i as_vec_register =
  _mm512_maskz_mov_epi8(as_mask, _mm512_set1_epi8(0xFF));
  __m512i as_vec_register_shuf =
  _mm512_permutexvar_epi8(_mm512_loadu_si512(indexes), as_vec_register);
  return _cvtmask64_u64(_mm512_movepi8_mask(as_vec_register_shuf));
}
```

快点

```c++
uint64_t faster_bit_shuffle(uint64_t w, uint8_t indexes[64]) {
  __m512i as_vec_register = _mm512_set1_epi64(w);
  __mmask64 as_mask = _mm512_bitshuffle_epi64_mask(as_vec_register,
     _mm512_loadu_si512(indexes));
  return _cvtmask64_u64(as_mask);
}
```

- [Hiding Memory Latency With In-Order CPU Cores OR How Compilers Optimize Your Code](https://johnnysswlab.com/hiding-memory-latency-with-in-order-cpu-cores-or-how-compilers-optimize-your-code/)


有些芯片性能太好掩盖了一些代码优化的潜力，讲了几个场景 循环展开/pipeline对于老芯片带来的性能提升。观点挺有意思

这个博客 反复介绍过多次  https://johnnysswlab.com/ 推荐收藏没事看看

- [My way to get into conferences](https://www.sandordargo.com/blog/2023/06/28/how-to-get-into-conferences)

讲自己的演讲经历，如何演讲，找话题找组织，如何保证感兴趣，等等

话说，想组织一个c++讨论演讲，怎么才能组织起人来看，找到演讲者呢。

之前看祁宇(qicosmos)搞过，太正式了其实。类似meetingcpp这种网络会议直播模式就行

大家给给点子，我想整一个。没话题其实可以以国外视频转述一遍。加深理解。

- [How to wait for multiple C++ coroutines to complete before propagating failure, unhelpful lambda](https://devblogs.microsoft.com/oldnewthing/20230627-00/?p=108375)
- [How to wait for multiple C++ coroutines to complete before propagating failure, false hope](https://devblogs.microsoft.com/oldnewthing/20230628-00/?p=108377)
- [How to wait for multiple C++ coroutines to complete before propagating failure, peeling away at a tuple](https://devblogs.microsoft.com/oldnewthing/20230629-00/?p=108380)

raymond chen真能写。我一个没看

- [60 terrible tips for a C++ developer](https://pvs-studio.com/en/blog/posts/cpp/1053/)

讲一些用法，尽量避免。没啥说的。有些有点搞笑。这里就不列举了
## 视频

- [C++ Weekly - Ep 382 - The Static Initialization Order Fiasco and C++20's constinit](https://www.youtube.com/watch?v=rEwijXgC_Kg&ab_channel=C%2B%2BWeeklyWithJasonTurner)

讲constinit的。没啥说的。能用就用

- [[MUC++] Ivica Bogosavljevic - Introduction to Hardware Efficiency](https://www.youtube.com/watch?v=mJJ5lTXvptQ&ab_channel=MUCplusplus)

这个还是很值得一看的，这个哥们是性能调优专家，有个博客搜索权重挺高 https://johnnysswlab.com/

这个改天我转b站上。或者谁有空给传一下

- [Timur Doumler: C++ and Safety](https://www.youtube.com/watch?v=WsswOOTxlIM&ab_channel=SwedenCpp)

这个是技术债了，异常问题异常安全等等，我看不进去。这里标记个TODO改天整理一下观点（或者找chatgpt老师提取一下。。。）

- [Low-Latency Trading Systems in C++: Templated Meta-State Machines in HFT - Jason McGuiness - ACCU 23](https://www.youtube.com/watch?v=FnMfhWiSweo&ab_channel=ACCUConference)

代码https://sourceforge.net/p/libjmmcg/git-repo/ci/ACCUConf2023/tree/libjmmcg/

挺能high的，没看完 PPT https://github.com/wanghenshui/wanghenshui.github.io/blob/master/assets/ACCUConf2023_JMMcG_e0d2d_PRESENTED.pdf

- [Applied C++20 Coroutines - Jim Pascoe - ACCU 2023](https://www.youtube.com/watch?v=ltesWt-92xw&ab_channel=ACCUConference)

ppt https://jamespascoe.github.io/accu2023/

看个乐
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂


## 新项目介绍/版本更新

- vulkan.cpp支持module了，看看怎么封装的？  https://github.com/KhronosGroup/Vulkan-Hpp/blob/main/vulkan/vulkan.cppm
- https://github.com/bkryza/clang-uml  支持用clang直接画图！不过得编译，用compile database.json来生成。不知道大项目的效果。感觉周末可以试验一下 话说plant uml太难看了，不能直接生成mermaid么
- https://github.com/AMDResearch/omnitrace amd 性能工具。仅限linux可用
---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/120.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
