---
layout: post
title:  第119期
---
# C++ 中文周刊 第119期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">


RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

c++26进行中，一堆trip report


这里有个详细的帖子列举了所有进展 https://www.reddit.com/r/cpp/comments/14h4ono/202306_varna_iso_c_committee_trip_report_first/

还有一些trip report我就不复述内容了


- [Trip report: Summer ISO C++ standards meeting (Varna, Bulgaria)](https://herbsutter.com/2023/06/16/trip-report-summer-iso-c-standards-meeting-varna-bulgaria/)

- [Trip report: Summer ISO C++ Meeting in Varna, Bulgaria ](https://www.think-cell.com/en/career/devblog/trip-report-summer-iso-cpp-meeting-in-varna-bulgaria)


我比较关注的还是fiber_context SIMD 这俩应该没啥问题。可以先写boost的代码，慢慢切。

以及std::execution到底行不行了，反射到底行不行？

另外，如果内容较少/我没空，可能会偶尔鸽一下，有没有小编感兴趣收集，或者一起搞搞，可以邮件wanghenshui@qq.com

本周内容不多

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-06-21 第207期 ](https://mp.weixin.qq.com/s/DE7eYPro-NNRzkI77y1igg)


## 文章

- [Five Awesome C++ Papers for the H1 2023 - C++26, Varna and More](https://www.cppstories.com/2023/h1-cpp-papers23/)

还是c++26的玩意

作者提了他感兴趣的

```c++
[[maybe_unused]] auto [x, y, iDontCare] = f();

auto [x, y, _] = f(); // c++26
```

终于把这玩意加上了，go啥的都有

不过没有这玩意的时候，我都是`_ = std::ignore;` 然后这么用

Hazard Pointers  不多说，folly已经有了https://github.com/facebook/folly/blob/main/folly/synchronization/Hazptr.h

也可以看看这个 https://www.bilibili.com/video/BV1ha411k7pa?p=73

 static_vector boost/llvm也有

 Native Handles and File Streams c++库函数处理的fd吐出来，比如iostream这种

- [GCC 14 NRVO enhancements](https://www.reddit.com/r/cpp/comments/145fnjl/gcc_14_nrvo_enhancements/)

gcc14引入 -Wnrvo 帮助提醒优化返回值，[P2025](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2021/p2025r2)

代码patch在这里 

https://gcc.gnu.org/git/?p=gcc.git;a=commit;h=7e0b65b239c3a0d68ce94896b236b03de666ffd6

https://gcc.gnu.org/git/?p=gcc.git;a=commit;h=28db36e2cfca1b7106adc8d371600fa3a325c4e2

这方面不如clang，话说clang早就上了

- [New C++ features in GCC 13](https://developers.redhat.com/articles/2023/06/21/new-c-features-gcc-13#)

默认-std=gnu++17，带来一堆23的功能

放松static_assert
```cpp
template<typename> void f() {
  static_assert (false, "");
}
```

没特化之前这里不报错，还是很有用的

放松 constexpr限制

```cpp
constexpr char test () {
  static constexpr char c[] = "Hello World"; // OK in C++23
  return c[1];
}

static_assert (test () == 'e');
```

支持static operator

比如()

```cpp
struct S {
  static constexpr bool operator() (int x, int y) { return x < y; }
};
constexpr S s;
static_assert (s (1, 2));

void g() {
  S::operator()(1, 2);  // OK in C++23
}
```

比如[]

```cpp
struct S {
  S() {}
  static int& operator[]() { return mem[0]; }
  static int mem[64];
};

void g() {
  S s;
  s[]++;
}
```

浮点数增强
```c++
#include <stdfloat>

int main (){
  std::float16_t f16 = 1.0f16;
  std::float32_t f32 = 2.0f32;
  std::float64_t f64 = 3.0f64;
  std::float128_t f128 = 4.0f128;
 std::bfloat16_t x = 1.0bf16;
}
```

move简化, 这种代码gcc13编译不过了

```cpp
int& g(int&& x) {
  return x; 
}
```

assume终于来了，contraits的一小部分能力

```cpp
int foo (int x, int y) {
  [[assume (x >= y)]];
  if (x == y)
    return 0;
  else if (x > y)
    return 1;
  else
    return -1;
}
```

生成的汇编更简单 gcc 13.1 c++23 O2

```asm
foo(int, int):
  xorl %eax, %eax
  cmpl %esi, %edi
  setne %al
  ret
```

注释掉assume的效果

```asm
foo(int, int):
  xorl %eax, %eax
  cmpl %esi, %edi
  je .L1
  setg %al
  movzbl %al, %eax
  leal -1(%rax,%rax), %eax
.L1:
  ret
```
- [C++20 Coroutines Driving a Job System](https://poniesandlight.co.uk/reflect/coroutines_job_system/)

代码在这里 https://github.com/tgfrerer/pal_tasks/tree/main

简单说，就是像调度future一样调度协程，把协程封装成task (不如seastar，看个乐也行)

- [folly中异步框架future与DAG](https://www.yinkuiwang.cn/2023/01/08/folly%E5%BC%82%E6%AD%A5%E6%A1%86%E6%9E%B6%E4%B8%8EDAG/)

讲future的


- [Why You Should Only Rarely Use std::move](https://accu.org/journals/overload/31/175/fertig/)

大意是别move返回值优化的编译器能处理好的场景

- [Type Safe C++ enum Extensions](https://accu.org/journals/overload/31/175/steinbach/)

```cpp
  enum class Suit{
  spades, hearts, diamonds, clubs };

  enum class Suit_with_joker extends Suit {
    joker };
```

想要这种语法，又能复用，又能安全，然后他用类继承糊了一个

```c++
struct Suit;
struct Suit_names
{
  static const Suit spades;
  static const Suit hearts;
};
struct Suit:
  Suit_names
{
  int value;
  constexpr explicit Suit( const int v )
    : value( v ) {}
};
constexpr Suit Suit_names::spades = Suit( 0 );
constexpr Suit Suit_names::hearts = Suit( 1 );

struct Suit_with_joker;
struct Suit_with_joker_names:
  Suit_names
{
  static const Suit_with_joker joker;
};
struct Suit_with_joker:
  Suit_with_joker_names
{
  int value;
  constexpr explicit
    Suit_with_joker( const int v ): value( v ) {}
  constexpr Suit_with_joker( const Suit v )
    : value( v.value ) {}
};
constexpr Suit_with_joker
  Suit_with_joker_names::joker
  = Suit_with_joker( 4 );
auto main() -> int
{
  (void) Suit_with_joker::hearts;
    // OK, has inherited the "enumerators".
  Suit_with_joker s1 = Suit::hearts;
    // OK, right way is-a relationship.
  #ifdef FAIL_PLEASE
    Suit s2 = Suit_with_joker::joker;
      //! C. error, /as it should be/. :)
  #endif
}
```

这种需求真的有么？不太值得

- [Optimizing the `pext` perfect hash function](https://xoranth.net/verb-parse/)

看不懂
 

## 视频

-  字节开源高性能C++ JSON库sonic-cpp

<iframe src="//player.bilibili.com/player.html?aid=272293765&bvid=BV1nc411g7PK&cid=1165281732&page=1" scrolling="no" border="0" frameborder="no" framespacing="0" allowfullscreen="true"> </iframe>


结合yyjson和simdjson，优化各自的缺陷，实现sonic-cpp，主要是rapid-json性能不rapid


相当于带你走读simdjson代码，教你看懂那一堆_mm函数，还是挺值得一看的，还讲了一些simdjson没有的工程细节，一些池化


- ACCU演讲，没啥看的，感兴趣的自己看吧

    Standard Attributes in C and C++ - [Rerelease] - Timur Doumler - https://youtu.be/TDKqAWtvH9c

    Test-Driven Development of C++ Embedded and System-Level Software - Vladimir Vishnevskii - https://youtu.be/PYc2KuFce7o

    Improving C++ Compilation Times: Tools & Techniques - Vittorio Romeo - https://youtu.be/PfHD3BsVsAM

    Breaking Enigma With the Power of Modern C++ - Mathieu Ropert - https://youtu.be/ef78lSbgHNk

- [C++ Weekly - Ep 381 - C++23's basic_string::resize_and_overwrite](https://www.youtube.com/watch?v=Ymm0yN_QUQA&ab_channel=C%2B%2BWeeklyWithJasonTurner)

能用就用，这玩意不如resize_uninit, 也不知道为啥非得整个lambda接口，服了


- [itCppCon23 Lock-free Micro Problems (Davide Di Gennaro)](https://www.youtube.com/watch?v=N-3Hxgan1KA&ab_channel=ItalianCppCommunity)

https://github.com/italiancpp/itcppcon23/blob/main/Lock-free%20micro%20problems%20-%20Davide%20Di%20Gennaro.pdf

有点意思

B站我也转了 https://www.bilibili.com/video/BV1fz4y1H7BD/

其实他说了半天，说的还是hazard pointer 不删除的那一套东西。不过也是一个视角

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [gcc-mcf](https://gcc-mcf.lhmouse.com/) 懂的都懂
- https://github.com/lhmouse/poseidon/blob/4f1a168f91a6f7c1ef580ecf423adba2165f93ad/poseidon/base/uuid.cpp#L177 SIMD处理uuid来学一学（我看这一堆mm就眼睛疼）


## 新项目介绍/版本更新


- https://github.com/Ericsson/codechecker/ 整合了clang analyser和clang-tidy
- https://github.com/orlp/polymur-hash 有点噱头啊，没有wyhash快，说什么碰撞率可预测啥啥数学证明这那的
- https://github.com/uyha/scope  一个scope库，还有unique_source之类的


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/119.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
