---
layout: post
title:  第117期
---
# C++ 中文周刊 第117期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢`不语` 赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-06-07 第205期 ](https://mp.weixin.qq.com/s/K139gn_rYMfmaTo9YqD8LA)

llvm weekly我可能也看一下，顺便展开讲讲。可能更新以后要挪到周六，周知一下

看内容多不多，不多就讲讲llvm weekly

另外视频压了很多没看。看视频最大的问题是关键信息提取太慢了，lighting talk能快一些，长视频突出一个铺垫拉满。

这周末我准备把2021的 lighting talk看一遍，周末可能发一下整理，或者下周发一下整理

## 文章

本周最热闹的应该是这个问题 [DeepMind AI 创造出比人类快 70% 的排序算法，会产生哪些影响？](https://www.zhihu.com/question/605448432/)

实际上根据他的压测结果，没有70%这个结论。有点收益，但不是70%

代码去年就合入了

review链接 https://reviews.llvm.org/D118029 

代码链接 https://github.com/llvm/llvm-project/commit/194d1965d2c841fa81e107d19e27fae1467e7f11

这个问题下大家在互相拉扯，我之前看到这个也是先入为主嘲讽一波，啊原来汇编17行，你优化了一下，16行了，AI可以了，收收味

不能说没进步，首先不是introspect sort改成pdqsort这种跨步收益(llvm已经是pdqsort了。gcc不是，想用可以用boost)

其次看benchmark https://github.com/wanghenshui/cppweeklynews/pull/53

有些场景甚至慢了。但前排都是提升的，基本%1。

不过其他答案给了个AI优化hash算法的。这个确实牛逼 https://github.com/abseil/abseil-cpp/commit/74eee2aff683cc7dcd2dbaa69b2c654596d8024e

我一直觉得hash算法这玩意不是人想的，AI感觉在这个方向能有更大收获

依赖输入的AI优化说实话有点像PGO

优化尚不明显，AI仍需努力

话说问问ChatGPT老师也能得到相同的结论 https://zhuanlan.zhihu.com/p/635847068


- [Parsing IP addresses crazily fast](https://lemire.me/blog/2023/06/08/parsing-ip-addresses-crazily-fast/)

之前聊过这个http://0x80.pl/notesen/2023-04-09-faster-parse-ipv4.html

Daniel Lemire他也感兴趣，毕竟他写了个url解析库ada 仓库 https://github.com/ada-url/ada

需要这玩意。他根据上面这哥们的代码改了一版本，相比gcc，性能提升十倍 

代码

https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/blob/master/2023/06/08/src/sse_inet_aton.c

另外，文中提到的 simdzone 是dns zone文件解析库 代码 https://github.com/NLnetLabs/simdzone

说实话我一直没研究SIMD。感觉躲不开了。这里标记个TODO。早晚得研究下

- [Make operator<=> ignore a data member](https://quuxplusone.github.io/blog/2023/06/05/spaceship-ignore/)

一个很巧妙的办法让成员避免比较

比如一个类

```cpp
struct A {
    using allocator_type = std::pmr::polymorphic_allocator<std::byte>;
    int data1;
    int data2;
    int data3;
    allocator_type alloc;
    A(int a, int b, int c, allocator_type d) : data1(a), data2(b), data3(c), alloc(d) {}
    friend auto operator<=>(const A&, const A&) = default;
};
```
怎么实现`<=>` 能不比较alloc呢？

像咱这种笨比，就手写，不default，写成里面的来比较

比如
```cpp
friend std::strong_ordering operator<=>(const A& lhs, const A& rhs) {
  if (auto r = (lhs.data1 <=> rhs.data1); r != 0) {
    return r;
  } else if (auto r = (lhs.data2 <=> rhs.data2); r != 0) {
    return r;
  } else if (auto r = (lhs.data3 <=> rhs.data3); r != 0) {
    return r;
  } else {
    return (1 <=> 1);
  }
}
```

或者聪明一点，使用tie

```cpp
friend std::strong_ordering operator<=>(const A& lhs, const A& rhs) {
  auto tie = [](auto& x) { return std::tie(x.data1, x.data2, x.data3); };
  return tie(lhs) <=> tie(rhs);
}
friend bool operator==(const A& lhs, const A& rhs) {
  auto tie = [](auto& x) { return std::tie(x.data1, x.data2, x.data3); };
  return tie(lhs) == tie(rhs);
}
```

但还是要手写，能不能default？


作者的办法

```cpp
#include <compare>
#include <memory_resource>
#include <cassert>

struct ComparisonIgnorerBase {
    using CIB = ComparisonIgnorerBase;
    constexpr friend auto operator<=>(const CIB&, const CIB&) = default;
};

template<class T>
struct ComparisonIgnorer : ComparisonIgnorerBase {
    T t_;
    ComparisonIgnorer(T t) : t_(std::move(t)) {}
};

struct A {
    using allocator_type = std::pmr::polymorphic_allocator<std::byte>;
    int data1;
    int data2;
    int data3;
    ComparisonIgnorer<allocator_type> alloc;
    A(int a, int b, int c, allocator_type d) : data1(a), data2(b), data3(c), alloc(d) {}
    friend auto operator<=>(const A&, const A&) = default;
};

int main() {
    std::pmr::monotonic_buffer_resource mr1;
    std::pmr::monotonic_buffer_resource mr2;
    A a = {1,2,3, &mr1};
    A b = {1,2,3, &mr2};
    A c = {3,1,2, &mr1};
    assert(a == b);
    assert(a < c);
}
```

确实挺巧妙，不需要比较的成员，替他实现一个空的 `<=>` 鸠占鹊巢

- [Decoding C Compilation Process: From Source Code to Binary](https://hackthedeveloper.com/c-program-compilation-process/)

看<程序员自我修养 链接装载库> 就行了。这个文章也是讲的那玩意

- [Did you know that C++20 added std::span?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```cpp
#include <span>

constexpr std::array a = {1, 2, 3, 4, 5};
constexpr std::span s{a};

static_assert(s[0]==a[0]);
```

- [cuneicode, and the Future of Text in C](https://thephd.dev/cuneicode-and-the-future-of-text-in-c)

看不懂

- [It’s great that you provide operator overloads, but it’s also nice to have names](https://devblogs.microsoft.com/oldnewthing/20230605-00/?p=108289)

可读性问题，不是必要的operator() 不要用

```cpp
struct StorageLoader
{
    template<typename DataType>
    DataType Load(StorageOptions<DataType> const* options);

    template<typename DataType>
    DataType operator()(StorageOptions<DataType> const* options)
    { return Load(options); }
};


// 1 Using function call operator
data1 = storageLoader(&data1Options);

// 2 Using named method
data1 = storageLoader.Load(&data1Options);

// 3 Named method works better for nullptr
data1 = storageLoader.Load<Data1>(nullptr);
```
第一种显然是不必要的

不必要的operator ()实现这玩意整花活没意义

- 偶然看到的一段代码


```cpp
repair_status repair::task_manager_module::get(int id) const {
    if (std::cmp_greater(id, _sequence_number)) {
        throw std::runtime_error(format("unknown repair id {}", id));
    }
    auto it = _status.find(id);
    if (it == _status.end()) {
        return repair_status::SUCCESSFUL;
    } else {
        return it->second;
    }
}
```

std::cmp_greater 是c++20的，之前介绍过，语义是

```cpp
-1 > 0u; // true
std::cmp_greater(-1, 0u); // false
```

跟着最新标准演进代码，收益还是非常明显的，起码不会写错

- [Printing double aka the most difficult problem in computer science](https://www.zverovich.net/2023/06/04/printing-double.html)

浮点数的精度问题

## 视频

- [Correct by Construction: APIs That Are Easy to Use and Hard to Misuse - Matt Godbolt C++ on Sea ](https://www.youtube.com/watch?v=nLSm3Haxz0I&ab_channel=cpponsea)

讲代码怎么写的，讲的挺好的 PPT在这里

https://github.com/mattgodbolt/correct-by-construction 

感觉值得用中文讲一遍

- [Supporting new speakers and great talks in 2023](https://www.meetingcpp.com/blog/items/Supporting-new-speakers-and-great-talks-in-2023.html)

想要演讲却不知道说啥？没有自信？这里有一堆指导视频教你做演讲

- Tina Ulbrich - But I have nothing to talk about! 看标题就绷不住了。简单说就是根据经验整理观点
- Inbal Levi - Distilling your message
- Hendrik Niemeyer - Doing research on your talks with Zettelkasten (and some tools)
- Andrei Alexandrescu - Stop working on your slides AA说的是演讲主要是传递观点传递信息，只要不是错的，不需要你懂很多，20%就够，传播思想。这点我很赞同，本周报也是这样的，不保证结论正确，只要基本正确，传播观点就行
- Jens Weller - Presenting Code
- Clare Macrae - Better Code Samples in Programming Talks
- Chandler Carruth - About giving live demos 这个哥们经常做live demo演讲，我还记得他讲LLVM那个。挺厉害的。他说的主要就是练习，他这个小演讲就是手敲命令演示的
- Patricia Aas - Telling a story
- Kate Gregory - How to end a talk

Andrei Alexandrescu的和Chandler Carruth 的演讲总是有意思，他们的演讲我一直都看。其他人说的哎也就那么回事

- [Removing Needless Undefined Behavior for a Safer C++ - Alisdair Meredith - ACCU 2023](https://www.youtube.com/watch?v=iY7ft98nM2k&ab_channel=ACCUConference)

这个讲的是之前clang那个死循坏优化代码，UB介绍。已经介绍一万多遍了

- [C++ Standard Views - Nico Josuttis - ACCU 2023](https://www.youtube.com/watch?v=qv29fo9sUjY&ab_channel=ACCUConference)

介绍view的使用和一些bug，感觉之前说过类似的案例，比如range loop bug 迭代器边界问题等等。这个值得看一下，感觉今年cppcon还会讲一遍
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了

## 新项目介绍/版本更新

- [hypergrep](https://github.com/p-ranav/hypergrep) 类似AG的工具，得益于hyperscan处理正则。速度快得飞起，不过目前只支持linux，别的平台没测
- [liburing 2.4发布](https://github.com/axboe/liburing/releases/tag/liburing-2.4)
- https://github.com/cwida/fsst 感觉很吊，没研究明白 这里标记个TODO
- https://github.com/axodox/axodox-machinelearning Stable Diffusion c++实现
---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/117.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
