---
layout: post
title:  第116期
---
# C++ 中文周刊 第116期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢`不语` `chenbh` 赞助

上周团建耽搁。

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-05-31 第204期 ](https://mp.weixin.qq.com/s/iup2BmqbTBOo5FtgLcqdHQ)


ACCU会议开始，后续会把有意思的看一下

## 文章

- [Did you know that in C++ you can generate jump tables at compile-time?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```c++
#include <array>

template<auto N> constexpr auto foo() { return N; }

template<auto N = 42>
constexpr auto dispatch(auto n) -> int{
    using foo_return_type = std::invoke_result<decltype(&foo<0>)>::type;
    const auto jump_table = []<auto ...I>(std::index_sequence<I...>){
        return std::array<foo_return_type, sizeof...(I)>{
            (foo<I>())...
        };
    }(std::make_index_sequence<N>{});
    return jump_table[n];
};

static_assert(1 == dispatch(1));
static_assert(7 == dispatch(7));
static_assert(23 == dispatch(23));
```

感觉没啥用

- [On writing functions that accept any specialization of a C++ template type](https://devblogs.microsoft.com/oldnewthing/20230529-00/?p=108259)

想一个函数处理所有容器类，比如vector
```cpp
template<typename...Args>
void accept_any_vector(std::vector<Args...> v) {
    using vector = std::vector<Args...>;
    using Value = typename vector::value_type;
    using Allocator = typename vector::allocator_type;

    ...
}
```

没啥用

- [Don’t forward things that aren’t forwarding references](https://quuxplusone.github.io/blog/2023/05/27/dont-forward-non-forwarding-references/)

只有完美转发才用`std::forward`

- [Notes on std::optional’s monadic operations](https://mariusbancila.ro/blog/2023/05/29/notes-on-std-optional-monadic-operations/)

直接看代码吧，optional的辅助函数，c++23可用，说了很多次了，早就该加了

```cpp
auto p = make_pizza(pizza_size::regular)
   .or_else([]() -> std::optional<pizza> {
      std::cout << "Failed to create pizza\n"; 
      return std::nullopt; })
   .and_then(add_pepperoni)
   .or_else([]() -> std::optional<pizza> {
      std::cout << "Failed to add pepperoni\n"; 
      return std::nullopt; })
   .and_then(add_basil)
   .or_else([]() -> std::optional<pizza> {
      std::cout << "Failed to add basil\n"; 
      return std::nullopt; })
   .and_then(add_artichokes)
   .or_else([]() -> std::optional<pizza> {
      std::cout << "Failed to add pepperoni\n"; 
      return std::nullopt; })
   .transform(get_price);
```

- [Expected performance of a Bloom filter](https://lemire.me/blog/2023/05/26/expected-performance-of-a-bloom-filter/)

优化bloom filter提升性能，代码在这里https://github.com/FastFilter/fastfilter_cpp

原理我没有看懂，这里标记一个TODO

- [C++/WinRT event handlers that are lambdas with weak pointers to the parent class, part 1](https://devblogs.microsoft.com/oldnewthing/20230531-00/?p=108266)
- [C++/WinRT event handlers that are lambdas with weak pointers to the parent class, part 2](https://devblogs.microsoft.com/oldnewthing/20230601-00/?p=108272)
- [C++/WinRT event handlers that are lambdas with weak pointers to the parent class, part 3](https://devblogs.microsoft.com/oldnewthing/20230602-00/?p=108278)

Raymond Chen讲的这种需求我没有看懂

- [A not-so-quick introduction to the C++ allocator model](https://quuxplusone.github.io/blog/2023/06/02/not-so-quick-pmr/)
- [P1144 PMR koans](https://quuxplusone.github.io/blog/2023/06/03/p1144-pmr-koans/)

看不懂了

- [C++23: two additional noexcept functions](https://www.sandordargo.com/blog/2023/05/31/cpp23-noexcept-related-changes)

`std::exchange` `std::apply`也noexcept了。没啥说的 

## 视频

- [C++ Weekly - Ep 378 - Should You Ever std::move An std::array? ](https://www.youtube.com/watch?v=56DMwqKffi0&ab_channel=C%2B%2BWeeklyWithJasonTurner)

array 无法move，可以掏空容器内的成员

最近看了cppcon 2022的lighting talk，有几个挺有意思。想看的可以b站搜一下。

或者复制这个链接 https://www.bilibili.com/video/BV17X4y117Hx

或者看油管  https://www.youtube.com/playlist?list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4

下面是总结，链接用的油管的

- [Lightning Talk: find-move-candidates in Cpp - Chris Cotter - CppCon 2022](https://www.youtube.com/watch?v=F8wbpi2kTmY&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=11&ab_channel=CppCon)

他这个点子有意思，是利用clangd 分析可以move的代码，集成到CI。没开源

- [Lightning Talk: Modernizing SFML in Cpp - Chris Thrasher - CppCon 2022](https://www.youtube.com/watch?v=JJPL17sDxUs&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=12&ab_channel=CppCon)

这个是拉人做开源项目 地址https://github.com/SFML/SFML

- [Lightning Talk: C++ Debug Performance is Improving: What Now? - Vittorio Romeo - CppCon 2022](https://www.youtube.com/watch?v=CfbuJAAwA8Y&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=17&ab_channel=CppCon)

这个是要求debug版本性能别太差 move forward addressof 在debug版本下根本没生效，没发挥作用。只能自己hook。目前编译器也在演化这里

- [Lightning Talk: Using This Correctly it's [[unlikely]] at Best - Staffan Tjernstrom - CppCon 2022](https://www.youtube.com/watch?v=_1A1eSriCV4&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=22&ab_channel=CppCon)

使用前要测量一下，或者对业务熟悉，知道这里满足用unlikely。甚至PGO都不能保证？

- [Lightning Talk: Adventures in Benchmarking Timestamp Taking in Cpp - Nataly Rasovsky - CppCon 2022](https://www.youtube.com/watch?v=-XU2silGr6g&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=25&ab_channel=CppCon)

压测发现直接调用rdtsc和调用系统的clock_gettime没差多少。实际上系统clock_gettime已经用rdtsc实现了。需要确认一下系统时钟源看一下是不是tsc。一些旧博客需要更新了

- [Lightning Talk: majsdown: Metaprogramming? In my Slides? - Vittorio Romeo - CppCon 2022](https://www.youtube.com/watch?v=vbhaZHpomg0&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=26&ab_channel=CppCon)

reveal.js PPT 直接调用godbolt 创意挺有趣

- [Lightning Talk: Now in Our Lifetimes Cpp - Staffan Tjernstrom - CppCon 2022](https://www.youtube.com/watch?v=pLVg3c6bljE&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=30&ab_channel=CppCon)

介绍的有点粗糙 `std::start_lifitime_as`

- [Lightning Talk: C++20 - A New Way of Meta-Programming? - Kris Jusiak - CppCon 2022](https://www.youtube.com/watch?v=zRYlQGMdISI&list=PLHTh1InhhwT6U_8ehqxpB7-O1KF_5WwC4&index=3&ab_channel=CppCon)

炫技，代码在这里 https://github.com/boost-ext/mp
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/116.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
