---
layout: post
title:  第113期
---
# C++ 中文周刊 第113期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

感谢 `不语` `GYXL` 赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-05-10 第201期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2023/2023-05-10.md)

[bRPC CVE-2023-31039 漏洞修复报告](https://mp.weixin.qq.com/s/cJslDFFw1CA6qiRhUVFolg) 

尽快升级到 bRPC >= 1.5.0，或者应用这个PR https://github.com/apache/brpc/pull/2218

出问题的代码
```cpp
- static std::string ExpandPath(const std::string &path) {
-   if (path.empty()) {
-       return std::string();
-   }
-   std::string ret;
-   wordexp_t p;
-   wordexp(path.c_str(), &p, 0);
-   CHECK_EQ(p.we_wordc, 1u);
-   if (p.we_wordc == 1) {
-       ret = p.we_wordv[0];
-   }
-   wordfree(&p);
-   return ret;
- }

 void Server::PutPidFileIfNeeded() {
-   _options.pid_file = ExpandPath(_options.pid_file);
    if (_options.pid_file.empty()) {
        return;
    }
```

pid_file可能恶意注入命令


## 文章

一套ASIO相关的设计分析，很长见识

- [asio 调度器实现 - 总览篇](https://zhuanlan.zhihu.com/p/623955857)
- [asio 调度器实现 - operation 调度详解](https://zhuanlan.zhihu.com/p/628230762)
- [asio 调度器实现 - strand 实现详解](https://zhuanlan.zhihu.com/p/628233776)
- [asio 调度器实现 - timer 实现详解](https://zhuanlan.zhihu.com/p/628234989)
- [asio 调度器实现 - coroutine 实现详解](https://zhuanlan.zhihu.com/p/628236465)
- [asio 调度器实现 - timer 实现详解](https://zhuanlan.zhihu.com/p/628234989)

- [Did you know about C++ allows to pass Pointer To Member Function via template parameter](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

通过模版把内部参数透出来，这个其实就是`folly::resizeWithoutInitialization`的技巧。之前咱们说过多次,通过模版参数猥琐的访问private

```cpp
struct header { int type{}; };

int main() {
    std::cout << []<auto Ptr>(const auto& msg) {
        return msg.*Ptr;
    }.operator()<&header::type>(header{42});  // prints 42
}
```
folly代码在这里 https://github.com/facebook/folly/blob/main/folly/memory/UninitializedMemoryHacks.h

最简单的复现代码段

```cpp
#include <iostream>

class A {
private:
  void f(int) { std::cout << "whoops" << std::endl; }
};

using PMember = void (A::*)(int);

void hijack(A& s, int n, char dummy = 0);

template <PMember pf, typename T>
struct Hijack {
  friend void hijack(A& s, int n, T) {
    (s.*pf)(n);
  }
};

template struct Hijack<&A::f, char>;

int main() {
  A a;
  hijack(a, 10);
  return 0;
}
```
来自 http://www.gotw.ca/gotw/076.htm

- [DuckDB Sort代码阅读和分析](https://zhuanlan.zhihu.com/p/628391818)

有点意思

- [Is this dynamic_cast needed?](https://www.sandordargo.com/blog/2023/05/10/is-this-dynamic-cast-needed)

确实没啥用，尽量别用

- [cuda程序该如何优化？](https://www.zhihu.com/question/57835205/answer/3023885590)

cuda中文资料少，感兴趣的可以看看

- [Polymorphic types and -Wdeprecated-copy-dtor](https://quuxplusone.github.io/blog/2023/05/05/deprecated-copy-with-dtor)

看代码

```cpp
struct Animal {
    explicit Animal() = default;
    virtual std::unique_ptr<Animal> clone() const = 0;
    virtual std::string noise() const = 0;
    virtual ~Animal() = default;
};

struct Cat : public Animal {
    std::unique_ptr<Animal> clone() const override {
        return std::make_unique<Cat>(*this);
    }
    std::string noise() const override {
        return "meow";
    }
};

int main() {
    std::unique_ptr<Animal> a = std::make_unique<Cat>();
    auto b = a->clone();
    assert(b->noise() == "meow");
}
```

没啥问题，就是会有告警 : deprecated user-declared destructor

是clone调用赋值构造弄出来的。

怎么干掉这个烦人的告警？定义好这几个构造函数就行了

```cpp
struct Animal {
    explicit Animal() = default;
    virtual std::unique_ptr<Animal> clone() const = 0;
    virtual std::string noise() const = 0;
    Animal(const Animal&) = default;
    Animal& operator=(const Animal&) = delete;
    virtual ~Animal() = default;
};
```

或者别用clone这种用法

@LH_Mouse指出，可以clone里塞一个指针来传出来，而不是返回。总之这个工厂模式返回，很老套

- [What are the duck-typing requirements of WRL ComPtr?](https://devblogs.microsoft.com/oldnewthing/20230511-00/?p=108177)
- [What are the duck-typing requirements of _com_ptr_t?](https://devblogs.microsoft.com/oldnewthing/20230508-00/?p=108156)
- [What are the duck-typing requirements of MFC IPTR?](https://devblogs.microsoft.com/oldnewthing/20230509-00/?p=108161)
- [What are the duck-typing requirements of ATL CComPtr?](https://devblogs.microsoft.com/oldnewthing/20230510-00/?p=108173)
windows相关的我一直看不懂

## 视频

- [C++ Weekly - Ep 375 - Using IPO and LTO to Catch UB, ODR, and ABI Issues](https://www.youtube.com/watch?v=Ii-zuK1cd90&ab_channel=C%2B%2BWeeklyWithJasonTurner)

开IPO/LTO帮你优化代码，同时也有告警提示，有助于修复bug，什么，你说你不会？

```cmake
# Optional IPO. Do not use IPO if it's not supported by compiler.
check_ipo_supported(RESULT result OUTPUT output)
if(result)
  set_property(TARGET foo PROPERTY INTERPROCEDURAL_OPTIMIZATION TRUE)
else()
  message(WARNING "IPO is not supported: ${output}")
endif()
```
- [Arvid Norberg: Efficient parsing](https://www.youtube.com/watch?v=im-NJZJP_PU&ab_channel=SwedenCpp)

这哥们是libtorrent bdencode维护者，讲了一下他的代码优化过程，他很久之前是写了个博客记录这个视频的，https://blog.libtorrent.org/2015/03/bdecode-parsers/

简单说就是一个parser，解析类似json的结构 比如`{ "foobar": [42, "barfoo", "bufar"] }`

正常的思路就是解析成map，然后里头解析成vector

<img src="https://user-images.githubusercontent.com/8872493/237973163-44dc57e7-1361-40d3-8e7c-dba0c557fea8.png" alt="">

这是最直观的做法，但是有个问题，就是分配占大头，很多开销，而且数据结构也复杂立体化了，map vector，都是异构的，维护起来老太太裹脚布一层又一层

~~不知道大家伙玩没玩过QT的下拉菜单控件，那个数据接口套的，左一层右一层，编辑一下要了老命了~~

有没有什么优化手段呢？拍扁，什么map vector，这种容器信息变成结构体的一部分

<img src="https://user-images.githubusercontent.com/8872493/237972157-23830b14-b9d2-4c06-b64e-a57be9b99ece.png" alt="">

作者从 https://github.com/zserge/jsmn 这个json parser得到启发，直接拍扁处理，整一数组来表示，彻底没有各种容器造成的低效问题，性能直接翻好几倍

代码在这里 https://github.com/arvidn/bdecode


## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了

## 新项目介绍/版本更新

- [mtensor](https://github.com/matazure/mtensor) cuda tensor库
- [fmt](https://github.com/fmtlib/fmt/releases/tag/10.0.0) 10.0.0发布，一堆支持以及性能提升

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/113.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
