---
layout: post
title:  第110期
---
# C++ 中文周刊 第110期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)


---

## 资讯

cppiso有个开发者调查问卷有空闲的没事儿干的可以投一下 https://www.surveymonkey.com/r/isocpp-2023

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-04-19 第198期 ](https://mp.weixin.qq.com/s/0ISKRQW1o-OnraUsa6oz5Q)

周六有深圳meetup

ACCU 2023要开始了。去年的没啥意思

视频信息密度低，看起来真的太费时间了

本周内容也不多

## 文章

- [operator<=> for C++20入门篇](https://zhuanlan.zhihu.com/p/101004501)

老文了，这里列下代码

```cpp
struct Name {
  string first_name;
  string mid_name;
  string last_name;
};

bool operator<(const Name& other) const {
  //before c++11
  return first_name<other.first_name
      || first_name == other.first_name && mid_name < other.mid_name
      || first_name == other.first_name && mid_name == other.mid_name && last_name < other.last_name;

  //after c++11
  return std::tie(first_name, mid_name, last_name) < 
      std::tie(other.first_name, other.mid_name, other.last_name);
}
// 干净
std::strong_ordering operator<=>(const Name&) const = default;

```

再比如，控制细节


```cpp
struct ID {
    int id_number;
    auto operator<=>(const ID&) const = default;
};

struct Person {
    ID id;
    string name;
    string email;
    std::weak_ordering operator<=>(const Person& other) const
    {
        return id<=>other.id;
    }
};

```

还有就是要注意容器比较，要单独实现`operator ==`,`operator<=>`再相等情况下的性能不太行

```cpp
struct SomeType {
    int int_property;
    std::vector<int> some_ints; // vector是容器
    std::strong_ordering operator<=>(const SomeType&) const = default;
    bool operator==(const SomeType&) const = default; // 加上这一行
};
```

- [Functional exception-less error handling with C++23’s optional and expected](https://devblogs.microsoft.com/cppblog/cpp23s-optional-and-expected/)

直接列代码吧，以前的optional就是废物

```cpp
std::optional<image_view> get_cute_cat (image_view img) {
    auto cropped = find_cat(img);
    if (!cropped) {
      return std::nullopt;
    }

    auto with_tie = add_bow_tie(*cropped);
    if (!with_tie) {
      return std::nullopt;
    }

    auto with_sparkles = make_eyes_sparkle(*with_tie);
    if (!with_sparkles) {
      return std::nullopt;
    }

    return add_rainbow(make_smaller(*with_sparkles));
}
```

愣是写出的go的味道

```c++
std::optional<image_view> get_cute_cat (image_view img) {
    return find_cat(img)
           .and_then(add_bow_tie)
           .and_then(make_eyes_sparkle)
           .transform(make_smaller)
           .transform(add_rainbow);
}
```

这多干净
- [Did you know that C++23 deprecated std::aligned_storage and std::aligned_union?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```cpp
template<class T>
struct container {
    //std::aligned_storage_t<sizeof(T), alignof(T)> t_buff; // deprecated
    alignas(T) std::byte t_buff[sizeof(T)]; // okay
};
```
多用`alignas(T)`


- [Trivial functions can still be non-nothrow (modulo compiler bugs)](https://quuxplusone.github.io/blog/2023/04/17/noexcept-false-equals-default/)

看不懂

- [Defining interfaces in C++ with ‘concepts’ (C++20)](https://lemire.me/blog/2023/04/18/defining-interfaces-in-c-with-concepts-c20/)
- [Defining interfaces in C++: concepts versus inheritance](https://lemire.me/blog/2023/04/20/defining-interfaces-in-c-concepts-versus-inheritance/)

老生常谈，concept比虚接口性能好


```cpp
template <typename T>
concept is_iterable = requires(T v) {
                        { v.has_next() } -> std::convertible_to<bool>;
                        { v.next() } -> std::same_as<uint32_t>;
                        { v.reset() };
                      };
template <is_iterable T> size_t count(T &t) {
  t.reset();
  size_t count = 0;
  while (t.has_next()) {
    t.next();
    count++;
  }
  return count;
}


class iter_base {
public:
  virtual bool has_next() = 0;
  virtual uint32_t next() = 0;
  virtual void reset() = 0;
  virtual ~iter_base() = default;
};

size_t count_inheritance(iter_base &t) {
  t.reset();
  size_t count = 0;
  while (t.has_next()) {
    t.next();
    count++;
  }
  return count;
}


struct iterable_array : iter_base {
  std::vector<uint32_t> array{};
  size_t index = 0;
  void reset() { index = 0; }
  bool has_next() { return index < array.size(); }
  uint32_t next() {
    index++;
    return array[index - 1];
  }
};
```


这两种写法，第一种也更清晰

- [ELF hash function may overflow](https://zhuanlan.zhihu.com/p/622536451)

这种场景也挺难触发的

- [Kratos-一个基于现代C++的开源有限元框架](https://zhuanlan.zhihu.com/p/622184117)

不是很懂

- [Protecting a broker from a failing event handler](https://devblogs.microsoft.com/oldnewthing/20230420-00/?p=108075)

看不懂

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [paozhu](https://github.com/hggq/paozhu) 国人开发的web库，和drogon联系过没共建而考虑自己的需求基于asio开发。感兴趣的可以体验一下，挂在这里长期推荐了

## 新项目介绍/版本更新

- [sbepp](https://github.com/OleksandrKvl/sbepp) C++ implementation of the FIX Simple Binary Encoding 


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/110.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
