---
layout: post
title:  第109期
---
# C++ 中文周刊 第109期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)


爬山有点累，更新有点晚

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

三月四月邮件列表 https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2023/#mailing2023-04

有栈协程值得关注 fiber_context。就是boost那套。有概率能进

RCU和Hazard pointer讨论好久了。感觉也是早晚的事。各个组件库都有实现

[4月22日深圳线下聚会！技术分享征集中 ](https://mp.weixin.qq.com/s/XNf5VS7D0GFghMM3CqsEwg)

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-04-12 第197期 ](https://mp.weixin.qq.com/s/bbeJvPRc3zQgFGWYy_vz2A)

boost 1.82出了 https://www.boost.org/users/history/version_1_82_0.html

引入boost.mysql库，之前提到过。另外去掉了c++03支持，现在是2023了

## 文章

- [Most C++ constructors should be explicit](https://quuxplusone.github.io/blog/2023/04/08/most-ctors-should-be-explicit/)

尽可能的用explicit，除了以下场景

复制构造`A(const A&)`/移动 `A(A&&)`

初始化列表`A(std::initializer_list<T>)` 

tuple类型`std::tuple_size_v<A>`

类型擦除类型`function` `any`

剩下的场景能用就用，尤其是`operator bool()`

- [explicit(To Be || !(To Be))](https://cppsenioreas.wordpress.com/2023/04/10/explicitto-be-to-be/)

这个讲的是这个语法

```cpp
class integer {
public:
    template<typename T, typename = std::enable_if_v<std::is_arithmetic_v<T>>>
    explicit(std::is_floating_point_v<T>)
    integer(T t) : val(std::round(t)) {}
private:
    int val;
};
void func(integer i) {/*...*/}
{
    // func(3.4); // won't compile
    func(integer(3.4));
    func(5);
}
```

控制`explicit`行为

- [Did you know about typename erasure technique (via Strong/Opaque Typedefs) in C++?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

说实话，有点没看懂

```cpp
#include <algorithm>
#include <array>
#include <cstdint>
#include <string_view>
#include <utility>

// clang-format off
template <std::size_t N>
struct fixed_string final {
    constexpr explicit(false) fixed_string(const char (&str)[N + 1]) {
        std::copy_n(str, N + 1, std::data(data));
    }

    [[nodiscard]] constexpr auto operator<=>(const fixed_string&) const =
        default;

    std::array<char, N + 1> data{};
};

template <std::size_t N> fixed_string(const char (&str)[N]) -> fixed_string<N - 1>;

template <fixed_string>
struct types final {
    friend auto get(types);
    template <class T>
    struct set {
        friend auto get(types) { return T{}; }
    };
};

template <fixed_string Str>  // typename erasure
struct te : decltype(get(types<Str>{})) {};

template<fixed_string Str, class T>
[[nodiscard]] constexpr auto typename_cast(const T& t) {
  void(typename types<Str>::template set<T>{});
  return static_cast<te<Str>>(t);
}

constexpr auto show_types(auto...) -> void;

template <class...> struct foo {};
template <class... Ts>
auto fn() -> void {
    foo<Ts...> foo{};
    show_types(typename_cast<"foo.long">(foo)); // te{{"foo.long"}} instead of foo<main()::lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type, ...>
}

int main() {
    struct lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type {};

    fn<
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type,
        lllllllllllllllllllllllllllllllllllllllllllllllllllllllllong_type
    >();
}

// clang-format on
```
https://godbolt.org/z/j3EP4za5q

- [The case of the PasswordVault.Add call that the customer thinks was hung](https://devblogs.microsoft.com/oldnewthing/20230407-00/?p=108026)

windows的，没看懂

- [自己写的CUDA矩阵乘法能优化到多快？](https://www.zhihu.com/question/41060378/answer/2645323107)

感觉很厉害

- [MLIR源码分析(一)：基本数据结构](https://zhuanlan.zhihu.com/p/621167799)

MLIR走读

- [今年在C/C++中踩得最意外的一个坑](https://zhuanlan.zhihu.com/p/620856044)

自己用数组做内存池，然后重载new aligned_malloc，结果地址并没有aligned，原因，数组没对齐

- [C++ RTTI和LLVM RTTI使用方法和原理解析](https://zhuanlan.zhihu.com/p/620724283)

- [打通游戏服务端框架的C++20协程改造的最后一环](https://zhuanlan.zhihu.com/p/620887179)

在已有库上拓展c++20协程玩法，代码演进上的一些设计

分析RTTI

- [Consider using constexpr static function variables for performance in C++](https://lemire.me/blog/2023/04/12/consider-using-constexpr-static-function-variables-for-performance/)

四段代码

```c++
char table1(int idx) {
  const char array[] = {'z', 'b', 'k', 'd'};
  return array[idx];
}

std::string table2(int idx) {
  const std::string array[] = {"a", "l", "a", "z"};
  return array[idx];
}

std::string table3(int idx) {
  const static std::string array[] = {"a", "l", "a", "z"};
  return array[idx];
}

std::string_view table4(int idx) {
  constexpr static std::string_view array[] = {"a", "l", "a", "z"};
  return array[idx];
}
```

最后一个最快。constexpr能用就用

- [Vectors and unique pointers](https://www.sandordargo.com/blog/2023/04/12/vector-of-unique-pointers)

使用unique_ptr和vector会遇到个坑爹的问题，从initializer_list 构造的没法move，坑爹initializer_list 


- [C++23’s New Fold Algorithms](https://devblogs.microsoft.com/cppblog/cpp23s-new-fold-algorithms/)

就是`std::ranges::fold_*`
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [paozhu](https://github.com/hggq/paozhu) 国人开发的web库，和drogon联系过没共建而考虑自己的需求基于asio开发。感兴趣的可以体验一下，挂在这里长期推荐了

## 新项目介绍/版本更新

- [boost.async](https://github.com/klemens-morgenstern/async)  给协程用的控制器
- [botan](https://github.com/randombit/botan/tree/3.0.0) tls库更新3.0版本

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/109.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
