---
layout: post
title:  第108期
---
# C++ 中文周刊 第108期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)


本周内容不多，但是比较难理解

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 上周更新  2023-03-29 第195期 ](https://mp.weixin.qq.com/s/bR6RHuci8kHV9BmgS6iirQ)

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-04-05 第196期 ](https://mp.weixin.qq.com/s/YJOV5FZctw8lMXLy7nbQ0Q)

Xmake v2.7.8 发布，改进包虚拟环境和构建速度 https://tboox.org/cn/2023/04/04/xmake-update-v2.7.8/

## 文章

- [Did you know about virtual inheritance in C++?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/324.md)

虚基类

```cpp
struct A {
    int a{};
};
struct B : virtual A {};
struct C : virtual A {};
struct D : B, C {};

int main() {
    D d{};
    d.a = {};  // without virtual -> request for member 'a' is ambiguous
}
```

- [async_simple 源码分析（上）](https://zhuanlan.zhihu.com/p/619684326)
- [async_simple 源码分析（下](https://zhuanlan.zhihu.com/p/619998880)

介绍协程应用以及如何更好的封装成Lazy类

- [技术解读：现代化工具链在大规模 C++ 项目中的运用](https://zhuanlan.zhihu.com/p/576721597)

LTO/PGO  涨涨见识

- [AST-based Query Fuzzer - ClickHouse 中的模糊测试](https://zhuanlan.zhihu.com/p/618864383)

了解一波fuzzer。据我了解应用的很少

- [优雅的实现，高效的表达！C++20无锁(lock-free)内存池-zeus::pool的设计与实现。](https://zhuanlan.zhihu.com/p/619121120)

感觉就是分层

- [A leaner <iostream> in libstdc++ for GCC 13](https://developers.redhat.com/articles/2023/04/03/leaner-libstdc-gcc-13)

gcc优化技术债，把iostream的依赖减小了

- [MutexProtected: A C++ Pattern for Easier Concurrency](https://awesomekling.github.io/MutexProtected-A-C++-Pattern-for-Easier-Concurrency/)

和Folly的`Sync<T>`一个东西, 帮你把mutex和你的值装在一起，免得你自己调用lock unlock

使用

```cpp
struct Thing {
    MutexProtected<Field> field;
};

thing->field.with([&](Field& field) {
    use(field);
});

```

代码 https://github.com/SerenityOS/serenity/blob/master/Kernel/Locking/MutexProtected.h

- [What is this [uuid(…)] in front of my C++ class declaration?](https://devblogs.microsoft.com/oldnewthing/20230331-00/?p=107998)

```cpp
[uuid(a6107c25-4c22-4a12-8440-7eb8f5972e50)]
class Widget : public IWidget
{
    /* ... */
};

```

这代码啥意思？ MSVC方言

- [An ignored exception can be misinterpreted as a hang, particularly in coroutines](https://devblogs.microsoft.com/oldnewthing/20230406-00/?p=108023)

有异常不处理，遇到了会给你一种代码挂住了没执行的感觉，尤其是在协程内

```cpp
winrt::IAsyncAction DoAwesomeThings()
{
    co_await promise.initial_suspend();
    try {
        Step1();
        printf("About to call Step2!\n");
        Step2();
        printf("Step2 returned!\n"); // never executes!
        Step3();
    } catch (...) {
        promise.unhandled_exception();
    }
    co_await promise.final_suspend();
}
```

- [push_back vs emplace_back: When to use what](https://andreasfertig.blog/2023/04/push_back-vs-emplace_back-when-to-use-what/)

push_back 当你想把已有的临时对象放到你的vector或者想把已有的对象move到你的vector

emplace_back 当你想创建临时对象，放到你的vector，没必要创建个临时对象再push_back



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [paozhu](https://github.com/hggq/paozhu) 国人开发的web库，和drogon联系过没共建而考虑自己的需求基于asio开发。感兴趣的可以体验一下，挂在这里长期推荐了


## 工作招聘

感觉有点干够了这个活。有没有啥岗位推荐的


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/108.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
