---
layout: post
title:  第107期
---
# C++ 中文周刊 第107期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

身体不太舒服，请假了。更新有点晚，见谅

本周内容不多

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

编译器信息最新动态推荐关注hellogcc公众号 本周没更

CLion 2023.1 出了，QT Creater10也出了

## 文章

- [Using shared_ptr for reloadable config](https://ddanilov.me/usage-of-shared_ptr)

不是啥新鲜点子啊，用shared_ptr + atomic_load/atomic_store 来做版本管理。代码在这里 https://github.com/f-squirrel/shared_config

不过atomic_load加载shared_ptr已经被废弃了，不建议使用

- [每（几）天学一点 C++ Execution（五）](https://zhuanlan.zhihu.com/p/618470909)

空大讲execution的文章，感兴趣的可以看看，前几期列一下

 [每（几）天学一点 C++ Execution（一）](https://zhuanlan.zhihu.com/p/611599280)
 [每（几）天学一点C++ Execution（二）](https://zhuanlan.zhihu.com/p/611789636)
 [每（几）天学一点 C++ Execution（三）](https://zhuanlan.zhihu.com/p/612065970)
 [每（几）天学一点 C++ Execution（四](https://zhuanlan.zhihu.com/p/612629058)

- [C++20: consteval and constexpr functions](https://lemire.me/blog/2023/03/27/c20-consteval-and-constexpr-functions/)

主要是他的fast_float库用上了这个特性，显摆一下，编译期的场景能加加速

- [Adding a new target/object backend to LLVM JITLink](https://blog.llvm.org/posts/2023-03-16-adding-new-llvm-jitlink-target-object-backend/)

llvm的，不是很懂

- [纯C++实现QT信号槽：参数裁剪](https://zhuanlan.zhihu.com/p/618474043)
- [纯C++实现QT信号槽原理剖析](https://zhuanlan.zhihu.com/p/618462675)

值得鼓励

- [Configuring algorithms in Modern C++](https://hannes.hauswedell.net/post/2023/03/30/algo_config/)

直接看代码吧，之前也介绍过，参数可读性问题

```c++
/* We define a "type tag" so we can pass types as values */
template <typename T>
inline constinit std::type_identity<T> ttag{};

/* The config now becomes a template */
template <typename Tint_type = decltype(ttag<uint64_t>)>
struct algo_config
{
    bool heuristic42    = true;
    Tint_type int_type  = ttag<uint64_t>;
    size_t threads      = 4ull;
};

/* And also the algorithm */
template <typename ...Ts>
auto algo(auto data, algo_config<Ts...> const & cfg)
{
    /* implementation */
}

int main()
{
    /* Setting just "value parameters" still works with and without "algo_config" */
    algo("data", algo_config{.heuristic42 = false, .threads = 8});
    algo("data",            {.heuristic42 = false, .threads = 8});

    /* When setting a "type parameter", we need to add "algo_config" */
    algo("data", algo_config{.int_type = ttag<uint32_t>, .threads = 8});
}
```

有点过度设计，但是点表达式构造这个c++早就该引入了，c一直有，c++一直没加，这个还是对可读性有帮助的


- [Decreasing the Number of Memory Accesses: The Compiler’s Secret Life 2/2](https://johnnysswlab.com/decreasing-the-number-of-memory-accesses-the-compilers-secret-life-2-2/)

降低内存访问浪费，尽可能利用寄存器

尽量不要使用指针，如果用，restrict，避免 Pointer Aliasing，让临时对象的生命周期尽可能的短，降低寄存器使用浪费（循环中的依赖计算）

循环分析寄存器这个得展开讲讲，gcc用-fopt-info-all-optall，clang用-Rpass-missed=.* -Rpass=.* -Rpass-analysis=.* 报告很多很不好读

clang还有先进工具 -fsave-optimization-record + opt-viewer(装个llvm-12-tools)

会生成很漂亮的图

 <img src="https://johnnysswlab.com/wp-content/uploads/image-8.png" alt="">

绿色是优化成功，红色是优化失败，要改的也是这里。我说的只是皮毛，这里的细节很复杂，https://johnnysswlab.com/loop-optimizations-interpreting-the-compiler-optimization-report/

需要仔细读一读

- [Finding Unstable Code via Compiler-Driven Differential Testing](https://dl.acm.org/doi/10.1145/3582016.3582053)


思路就是用编译期编出来N个版本，然后挨个FUZZ，重复，比较结果集，有点意思

代码在这里https://github.com/shao-hua-li/compdiff

## 视频

- [C++ Weekly - Ep 369 - llvm-mos: Bringing C++23 To Your Favorite 80's Computers](https://www.youtube.com/watch?v=R30EQGjxoAc)

感兴趣的可以看看

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [paozhu](https://github.com/hggq/paozhu) 国人开发的web库，和drogon联系过没共建而考虑自己的需求基于asio开发。感兴趣的可以体验一下，挂在这里长期推荐了

## 新项目介绍/版本更新

- [RareCpp](https://github.com/TheNitesWhoSay/RareCpp) 又一个宏反射
- [Flecs 3.2 is out!](https://ajmmertens.medium.com/flecs-3-2-is-out-8feb44d37e3) ECS游戏框架。没用过

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/107.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
