---
layout: post
title:  第105期
---
# C++ 中文周刊 第105期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

值班心累，本周内容非常少

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-03-15 第193期 ](https://mp.weixin.qq.com/s/ZJm7uZVvWoZi3iqoA6neig)

线下聚会了说是

## 文章

- [Effortless Performance Improvements in C++: std::string_view](https://julien.jorge.st/posts/en/effortless-performance-improvements-in-cpp-std-string_view/)

TLDR 尽可能使用string_view替代std::string，速度提升显著

- [如何扩展asio ](https://mp.weixin.qq.com/s/qJ4nd6Wjv1kA29H_-O2bHg)

扩展思路

- [sonic-cpp ](https://www.zhihu.com/question/20211077/answer/2935458129)

字节跳动一个json库，兼顾速度和好用，可以关注一波

- [User-Defined Literals To Handle Units](https://www.codingwiththomas.com/blog/user-defined-literals-to-handle-units)

介绍用户自定义字符操作符的

比如 ms，再比如

```cpp
long double operator""_deg_to_rad(long double deg)
{
    long double radians = deg * std::numbers::pi_v<long double> / 180;
    return radians;
}
// ... 
// value is now 90 degree in radiants -> 1.5707...
double value = 90.0_deg_to_rad;
```
- [Combining Collections with Zip in C++23 for Efficient Data Processing ](https://www.cppstories.com/2023/view-zip/)

```cpp
#include <format>
#include <iostream>
#include <ranges>
#include <vector>

int main() {
    std::vector a { 10, 20, 30, 40, 50 };
    std::vector<std::string> b { "one", "two", "three", "four" };
        
    for (const auto& [num, name] : std::views::zip(a, b))
        std::cout << std::format("{} -> {}\n", num, name);
}

```

zip介绍的文章，c++23可用

- [Iterating and inverting a const views::filter](https://quuxplusone.github.io/blog/2023/03/13/filter-view-hacks/)

```cpp
constexpr auto isPrint = [](auto c) { return std::isprint(c); };
constexpr auto isXDigit = [](auto c) { return std::isxdigit(c); };
constexpr auto hexdigital = std::views::filter(isXDigit);
constexpr auto printable = std::views::filter(isPrint);

constexpr auto digits = std::views::iota('\0')
                      | std::views::take(256)
                      | hexdigital;

for (char c : digits) ~~~             // Error
for (char c : digits | printable) ~~~ // Error
```

报错真么办，本质上，digits这里的遍历不是const，只能decay，c++23用auto解决
```cpp
for (char c : auto(digits)) ~~~             // OK
for (char c : auto(digits) | printable) ~~~ // OK
```

另外，反转，直接贴代码

```cpp
constexpr auto rest = [](auto fv) {
    return fv.base() | std::views::filter(std::not_fn(fv.pred()));
};

for (char c : rest(digits)) ~~~             // OK
for (char c : rest(digits) | printable) ~~~ // OK
```
- [Runtime asserts are not free](https://lemire.me/blog/2023/03/15/runtime-asserts-are-not-free/)

大概慢几倍。当然发现bug最重要

- [Trimming spaces from strings faster with SVE on an Amazon Graviton 3 processor](https://lemire.me/blog/2023/03/10/trimming-spaces-from-strings-faster-with-sve-on-an-amazon-graviton-3-processor/)

写了个针对arm sve指令的trim优化

原版
```cpp
size_t trimspaces(const char *s, size_t len, char *out) {
  char * init_out{out};
  for(size_t i = 0; i < len; i++) {
    *out = s[i];
    out += (s[i] != ' ');
  }
  return out - init_out;
}
```

改进

```cpp
size_t sve_trimspaces(const char *s, size_t len, char *out) {
  uint8_t *out8 = reinterpret_cast<uint8_t *>(out);
  size_t i = 0;
  for (; i + svcntw() <= len; i += svcntw()) {
   svuint32_t input = svld1sb_u32(svptrue_b32(), (const int8_t *)s + i);
   svbool_t matches = svcmpne_n_u32(svptrue_b32(), input, 32);
   svuint32_t compressed = svcompact_u32(matches, input);
   svst1b_u32(svptrue_b32(), out8, compressed);
   out8 += svcntp_b32(svptrue_b32(), matches);
  }
  if (i < len) {
   svbool_t read_mask = svwhilelt_b32(i, len);
   svuint32_t input = svld1sb_u32(read_mask, (const int8_t *)s + i);
   svbool_t matches = svcmpne_n_u32(read_mask, input, 32);
   svuint32_t compressed = svcompact_u32(matches, input);
   svst1b_u32(read_mask, out8, compressed);
   out8 += svcntp_b32(read_mask, matches);
  }
  return out8 - reinterpret_cast<uint8_t *>(out);
}
```

快个几倍大概

- [Did you know that C++23 added support for formatting ranges? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/321.md/)

```c++
int main() {
  std::cout << std::format("{}",   std::vector{1, 2, 3}); // [1, 2, 3]
  std::cout << std::format("{:n}", std::vector{1, 2, 3}); // 1, 2, 3
  std::cout << std::format("{}",   std::tuple{'1', 2., 3}); // ('1', 2, 3)
  std::cout << std::format("{}",   std::vector{std::pair{'a',1}, std::pair{'b',2}}); // [(a, 1), (b, 2)]
  std::cout << std::format("{:m}", std::vector{std::pair{'a',1}, std::pair{'b',2}}); // {(a, 1), (b, 2)}
}
```

不多说

## 视频

- [C++ Weekly - Ep 367 - Forgotten C++: std::valarray ](https://www.youtube.com/watch?v=hxcrOwfPhkE&t=86s&ab_channel=C%E1%90%A9%E1%90%A9WeeklyWithJasonTurner)

确实没啥人用

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [paozhu](https://github.com/hggq/paozhu) 国人开发的web库，和drogon联系过没共建而考虑自己的需求基于asio开发。感兴趣的可以体验一下，挂在这里长期推荐了

## 工作招聘

值班快要折磨死我了，有没有工作介绍给我


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/105.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
