---
layout: post
title:  第103期
---
# C++ 中文周刊 第103期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)


本周内容不多，线上一堆问题，没空看

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

hellogcc本周没更新

## 文章

- [C++ 调研结果 开发者正快速转向 C++17 和 C++20 2022 开发者生态系统现状](https://zhuanlan.zhihu.com/p/608898448)

之前咱们也发过。这回是中文版本

- [Performance Tips of the Week](https://abseil.io/fast/)

一些代码技巧，比如全局RE实例，googlebenchmark教学，Popcount使用等等。值得一看

- [ Combine Type Erasure And Strategies](https://www.codingwiththomas.com/blog/combine-type-erasure-and-strategies)

手把手教你糊一个类型擦除，直接贴代码

```cpp
#include <iostream>
#include <algorithm>
#include <memory>

namespace cwt {

class knight {
public:
    explicit knight(std::size_t strength) 
    : m_strength(strength) {}

    std::size_t get_strength() const  { 
        return m_strength; 
    }
    void who_am_i() const  { 
        std::cout << "i'm a knight\n"; 
    }
private:
    std::size_t m_strength;
};

class skeleton {
public:
    explicit skeleton(std::size_t strength) 
    : m_strength(strength) {}

    std::size_t get_strength() const  { 
        return m_strength; 
    }
    void who_am_i() const  { 
        std::cout << "i'm a skeleton\n"; 
    }
private:
    std::size_t m_strength;
};



class character {
public:
    template<typename T, typename Renderer> 
    character(T&& character, Renderer&& renderer) {
        m_character = std::make_unique<c_model<T, Renderer>>(std::move(character), std::move(renderer));
    }

    void who_am_i() const {
        m_character->who_am_i();
    }

    std::size_t get_strength() const {
        return m_character->get_strength();
    }

    void render() {
        m_character->render();
    }
private:   
    struct c_concept {
        virtual ~c_concept() {}
        virtual std::size_t get_strength() const = 0;
        virtual void who_am_i() const = 0;
        virtual void render() const = 0;
    };
    
    template<typename T, typename Renderer>
    struct c_model : public c_concept {
        c_model(T const& value, Renderer const& renderer) 
        : m_character(value), m_renderer(renderer) {};

        std::size_t get_strength() const override {
            return m_character.get_strength(); 
        }
        void who_am_i() const override {
            m_character.who_am_i();
        }

        void render() const override{
            m_renderer(m_character);
        }

        T m_character;
        Renderer m_renderer;
    };
private:
    std::unique_ptr<c_concept> m_character;
};
} // namespace cwt 


struct knight_renderer{
    void operator()(const cwt::knight& k) const {
        std::cout << "I'll take care of rendering" << std::endl;
    }
};

void knight_render_function(const cwt::knight& knight){
    std::cout << "I could also render a knight" << std::endl;
}

int main(){
    cwt::character character{cwt::knight(10), knight_renderer{}};
    character.render();

    character = cwt::character{cwt::knight(10), [](const cwt::knight& k){
        knight_render_function(k);
    }};
    character.render();

    character = cwt::character{cwt::skeleton(2), [](const cwt::skeleton& s){
        std::cout << "This might be another rendering technique" << std::endl;
    }};
    character.render();
}
```

- [Examples of Projections from C++20 Ranges ](https://www.cppstories.com/2023/projections-examples-ranges/)

直接列代码了

sort


```cpp
#include <algorithm>
#include <ranges>
#include <iostream>

int main() {
    std::pair<int, std::string_view> pairs[] = {
        {2, "foo"}, {1, "bar"}, {0, "baz"}
    };

    // member access:
    std::ranges::sort(pairs, std::ranges::less{}, 
        &std::pair<int, std::string_view>::first);

    // a lambda:
    std::ranges::sort(pairs, std::ranges::less{}, 
        [](auto const& p) { return p.first; });
}

```

tranform

```cpp
#include <algorithm>
#include <vector>
#include <iostream>
#include <ranges>

struct Product {
    std::string name_;
    double value_ { 0.0 };
};

int main() {
    std::vector<Product> prods{7, {"Box ", 1.0}};

    // standard version:  
    std::transform(begin(prods), end(prods), begin(prods), 
        [v = 0](const Product &p) mutable {
            return Product { p.name_ + std::to_string(v++), 1.0};
        }
    );
    for (auto &p : prods) std::cout << p.name_ << ", ";
    std::cout << '\n';

    // ranges version:  
    std::ranges::transform(prods, begin(prods), 
        [v = 0](const std::string &n) mutable {
            return Product { n + std::to_string(v++), 1.0};
        }, 
        &Product::name_);
    for (auto &p : prods) std::cout << p.name_ << ", ";
}

```

- [Review of Embracing Modern C++ Safely by John Lakos, Vittorio Romeo, Rostislav Khlebnikov and Alisdair Meredith](https://www.justsoftwaresolutions.co.uk/reviews/embracing_modern_c++_safely_review.html)

这书好像有中文翻译版本？


- [Did you know that C++11 allows calling functions with reference-to-array parameters from an initializer list? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```cpp
consteval auto foo(const auto (&value)[1]) { return value[0]; }
static_assert(42 == foo({42}));
```

这也是初始化列表的坑爹的地方

- [Decreasing the Number of Memory Accesses 1/2](https://johnnysswlab.com/decreasing-the-number-of-memory-accesses-1-2/)

降低内存使用

聚合循环

```cpp
double min = a[0];
for (int i = 1; i < n; i++) {
    if (a[i] < min) { min = a[i] };
}
double max = a[0];
for (int i = 1; i < n; i++) {
    if (a[i] > max) { max = a[i] };
}
```
- [全面解析brpc 之 bthread(1)：ResourcePool](https://zhuanlan.zhihu.com/p/609627294)
- [全面解析brpc 之 bthread(2)：TaskMeta](https://zhuanlan.zhihu.com/p/609786684)

了解一波

- [C++原子操作std::atomic的memory_order解析](https://zhuanlan.zhihu.com/p/609771875)

老生常谈了

- [The unintentionally-expanding scope of the SEM_NOGPFAULTERRORBOX flag]()
- [Enumerating Windows clipboard history in C++/WinRT and C#](https://devblogs.microsoft.com/oldnewthing/20230302-00/?p=107889)
- [If you want to sort a Windows Runtime collection, you may first want to capture it into something a bit easier to manipulate](https://devblogs.microsoft.com/oldnewthing/20230301-00/?p=107885)
讲windows api的，不多逼逼
## 视频

- [C++ Weekly - Ep 365 - Modulo (%): More Complicated Than You Think ](https://www.youtube.com/watch?v=xVNYurap-lk&ab_channel=C%E1%90%A9%E1%90%A9WeeklyWithJasonTurner)

涉及到符号，取余数就有点让人看不懂了，比如

`-1 % 10` c的表现是-1，而不是9，所以算法得是`(-1 % 10) + 10) % 10` 

- [The Most Important Optimizations to Apply in Your C++ Programs - Jan Bielak - CppCon 2022](https://www.youtube.com/watch?v=qCjEN5XRzHc&ab_channel=CppCon)

小伙很年轻啊，他列了一些常规优化点。这里直接列了，大家自己检查一下

O2, -ffast-math（这个有坑，要注意你的程序是否涉及浮点精度问题，之前讲过）

LTO, 

静态编译

PGO，这个大部分都没用 -fprofile-generate -fprofile-use

二进制patch，LLVM BOLT，根据PGO文件修正

no-rtti, no-exception，likely，inline，assume，`__restrict__`，`__attribute__((pure))`

编写cache友好型代码

避免分支切换

SIMD

这个talk还是很值得一看的，光看PPT也能有收获
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

- [Unilang](https://github.com/linuxdeepin/unilang) deepin的一个通用编程语言，点子有点意思，也缺人，感兴趣的可以github讨论区或者deepin论坛看一看。这里也挂着长期推荐了
- [paozhu](https://github.com/hggq/paozhu) 国人开发的web库，和drogon联系过没共建而考虑自己的需求基于asio开发。感兴趣的可以体验一下，挂在这里长期推荐了

## 新项目介绍/版本更新

- [libfork](https://github.com/ConorWilliams/libfork) 协程调度库，用了很多最近的论文算法
- [mperf：移动/嵌入式平台算子性能调优利器](https://zhuanlan.zhihu.com/p/610346564) 移动平台用的
## 工作招聘

有没有招聘需要广告的，发我，贴这里

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/103.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
