---
layout: post
title:  第102期
---
# C++ 中文周刊 第102期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

本周内容我没有细看。有些值得展开说说

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-02-22 第190期 ](https://mp.weixin.qq.com/s/3XsRUbCV6WH39PfuJh0QLg)

本月邮件列表 https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2023/#mailing2023-02

## 文章

- [Fun with printing tables with std::format and C++20](https://www.cppstories.com/2023/fun-print-tables-format/)

```cpp
constexpr size_t Rows = 5;
const std::map<std::string, std::array<double, Rows>> productToOrders{
        { "apples", {100, 200, 50.5, 30, 10}},
        { "bananas", {80, 10, 100, 120, 70}},
        { "carrots", {130, 75, 25, 64.5, 128}},
        { "tomatoes", {70, 100, 170, 80, 90}}
};

// print headers:
for (const auto& [key, val] : productsToOrders)
    std::cout << std::setw(10) << key;
std::cout << '\n';

// print values:
for (size_t i = 0; i < NumRows; ++i) {
    for (const auto& [key, val] : productsToOrders) {
        std::cout << std::setw(10) << std::fixed 
                  << std::setprecision(2) << val[i];
    }
    std::cout << '\n';
}

template <typename T>
size_t MaxKeyLength(const std::map<std::string, T>& m) {
    size_t maxLen = 0;
    for (const auto& [key, val] : m)
        if (key.length() > maxLen)
            maxLen = key.length();
    return maxLen;
}
const auto ColLength = MaxKeyLength(productsToOrders) + 2;

// print values:
for (size_t i = 0; i < NumRows; ++i) {
    for (const auto& values : std::views::values(productsToOrders)) {
        std::cout << std::format("{:>{}.2f}", values[i], ColLength);
    }
    std::cout << '\n';
}
/*
****apples***bananas***carrots**tomatoes
    100.00     80.00    130.00     70.00
    200.00     10.00     75.00    100.00
     50.50    100.00     25.00    170.00
     30.00    120.00     64.50     80.00
     10.00     70.00    128.00     90.00
*/
```
没啥说的


- [Named Booleans prevent C++ bugs and save you time](https://raymii.org/s/blog/Named_Booleans_prevent_bugs.html)

if里面的条件判断，最好外面算好再放进if里


```cpp
if ((_someLongNamedVar != FooLongNameEnum::Unknown && _someLongNamedMap.count   (_someLongNamedVar) == 0))
```

改成

```cpp
bool someLongNamedVarIsNotUnknown = _parameterCommand != FooLongNameEnum::Unknown;
bool someLongNamedMapCountIsZero = _someLongNamedMap.count(_someLongNamedVar) == 0
```

提高可读性，关爱同事

- [Few lesser known tricks, quirks and features of C](https://blog.joren.ga/less-known-c)

一些c的边角邪门歪道。只有特殊场景能用到，比如位域

```c
struct cat {
    unsigned int legs  : 3;  // 3 bits for legs  (0-4 fit in 3 bits)
    unsigned int lives : 4;  // 4 bits for lives (0-9 fit in 4 bits)
};

struct bar {
    unsigned char x : 5;
    unsigned short  : 0; // 帮你padding
    unsigned char y : 7;
}
```

就不逐一介绍了

- [C++ Coroutines Part 1: co_yield, co_return and a Prime Sieve](https://nigeltao.github.io/blog/2023/cpp-coro-part-1-yield-return-prime-sieve.html)

- [Did you know that std::unique_ptr can be constexpr in C++23?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/318.md)

```cpp
struct interface {
    constexpr virtual ~interface() = default;
    constexpr virtual auto get() const -> int = 0;
};

struct implementation final : interface {
    constexpr explicit(true) implementation(int value) : value{value} {}
    constexpr auto get() const -> int { return value; }

private:
    int value{};
};

constexpr auto foo(auto value) {
    std::unique_ptr<interface> i = std::make_unique<implementation>(value);
    return i->get();
}

static_assert(42 == foo(42));
```
逆天

- [Why am I getting an unhandled exception from my C++ function that catches all exceptions?](https://devblogs.microsoft.com/oldnewthing/20230223-00/?p=107867)

```cpp
void MyClass::DoSomething() {
    try {
        auto name = m_user.GetName();
        m_label.Text(name);
    } catch (...) {
        m_label.Text(L"unknown");
    }
}
```
如果`m_label.Text(L"unknown");`异常，怎么办？

一种猥琐的角度

```c++
winrt::fire_and_forget MyClass::DoSomethingAsync()
{
    auto lifetime = get_strong();
    try {
        auto name = co_await m_user.GetNameAsync();
        m_label.Text(name);
    } catch (...) {
        try {
            m_label.Text(L"unknown");
        } catch (...) {
            LOG_CAUGHT_EXCEPTION();
        }
    }
}
```

你就说catch没catch住吧，别管几个try

或者，不太常见的写法

```cpp
winrt::fire_and_forget MyClass::DoSomethingAsync() try
{
    auto lifetime = get_strong();
    try {
        auto name = co_await m_user.GetNameAsync();
        m_label.Text(name);
    } catch (...) {
        m_label.Text(L"unknown");
    }
} catch (...) {
    // The function is best-effort. Ignore failures.
}

```

你学废了吗

- [Float Compression](https://aras-p.info/blog/2023/01/29/Float-Compression-0-Intro/)

说实话，我不是很懂。值得研究一波

- [C++ OpenTelemetry Setup](https://app.telemetryhub.com/docs/guides/traces/cplusplus)

教你使用opentelemetry

- [Daily bit(e) of C++ | Modern documentation tools](https://itnext.io/daily-bit-e-of-c-modern-documentation-tools-9b96ba283732)

介绍文档工具和github action集成

- [import CMake; C++20 Modules](https://www.kitware.com/import-cmake-c20-modules/)

还是实验性质。感觉没人用

- [Procedural Map Generation in C++ — Part 1: The slow, the bad and the ugly](https://david-delassus.medium.com/procedural-map-generation-in-c-part-1-the-slow-the-bad-and-the-ugly-4445fb15e43a)

图形生成？高游戏的？我不是很懂

- [Behind the magic of magic_enum](https://blog.rink.nu/2023/02/12/behind-the-magic-of-magic_enum/)

讲解magic_enum原理

- [Shaving cycles: faster bucketing](https://outerproduct.net/trivial/2023-01-22_bucketing.html)

看不懂
## 视频

- [Reflection without Reflection TS - Fabian Renn Giles - Meeting C++ 2022](https://www.youtube.com/watch?v=gF48LDy-6lY&ab_channel=MeetingCpp)

还是`__buildin_dump_struct`实现。循序渐进。可以看看。我周末传b站一份

- [Smarter Cpp Atomic Smart Pointers - Efficient Concurrent Memory Management - Daniel Anderson CppCon](https://www.youtube.com/watch?v=OS7Asaa6zmY&ab_channel=CppCon)

这个也很有意思，值得研究研究。我周末传b站一份


## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
  最近写了很多高科技，比如https://github.com/lhmouse/asteria/blob/master/rocket/ascii_numget.hpp 很多细节考量


  有很多的issue task没人做，想参与开源项目开发的，来练练手


## 新项目介绍/版本更新

- [concurrencpp](https://github.com/David-Haim/concurrencpp) 又一个协程库
## 工作招聘

有想打广告的可以发给我。五毛一条

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/102.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
