---
layout: post
title:  第101期
---
# C++ 中文周刊 第101期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

最近有点忙，看的不是很细
---

## 资讯

之前聊过很多次的perf book，有中文版本了，中文名 现代CPU性能分析与优化

https://item.m.jd.com/product/10068178465763.html

这里没有带货的意思嗷，英语比较熟的，可以在这里免费获取这本书

https://book.easyperf.net/perf_book 填一下邮箱就会发给你邮件

​如果不熟，支持中文书也可以买一下。不过我感觉新书刚上有点贵了，一般来说三月末有个读书节之类的活动，有打折，可以到时候再买。

另外就是有没有出版社大哥能不能赞助两本我抽了，没有我就三月底自己买来抽了


---


[A call to action:Think seriously about “safety”; then do something sensible about it](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2023/p2739r0.pdf)

针对NSA的c++不安全的说法，BS慌了。和大家讨论一下改进措施

另外这里也吵翻天了 C++ 之父为什么说 Rust 等内存安全语言的安全性并不优于 C++？ https://www.zhihu.com/question/584122632

[C++23 “Pandemic Edition” is complete (Trip report: Winter ISO C++ standards meeting, Issaquah, WA, USA)](https://herbsutter.com/2023/02/13/c23-pandemic-edition-is-complete-trip-report-winter-iso-c-standards-meeting-issaquah-wa-usa/)

草药老师发了开会总结

[AMD RDNA™ 3 指令集架构 (ISA) 参考指南现已推出](https://zhuanlan.zhihu.com/p/605847235)

用了新显卡的关注下

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-02-15 第189期 ](https://mp.weixin.qq.com/s/hf6OrdAEPZ-oj_bSNFov_g)


## 文章

- [The evolution of enums](https://www.sandordargo.com/blog/2023/02/15/evolution-of-enums)

enum的周边设施，std::is_enum std::underlying_type std::is_scoped_enum std::to_underlying

- [Unreal Engine C++ Complete Guide](https://www.tomlooman.com/unreal-engine-cpp-guide/)

UE教程

- [std::initializer_list in C++ 2/2 - Caveats and Improvements ](https://www.cppstories.com/2023/initializer_list_improvements/)

```cpp
std::initializer_list<int> wrong() { // for illustration only!
    return { 1, 2, 3, 4};
}
int main() {
    std::initializer_list<int> x = wrong();
}

```

初始化列表的坑爹之处，生命周期有问题，别这么写。没关系，编译器会告警的。你说你不看告警？

- [Computing the UTF-8 size of a Latin 1 string quickly (AVX edition)](https://lemire.me/blog/2023/02/16/computing-the-utf-8-size-of-a-latin-1-string-quickly-avx-edition/)

算字符串占多少

```cpp
size_t scalar_utf8_length(const char * c, size_t len) {
  size_t answer = 0;
  for(size_t i = 0; i<len; i++) {
    if((c[i]>>7)) { answer++;}
  }
  return answer + len;
}
```

显然，可以SIMD
```cpp
size_t avx2_utf8_length_basic(const uint8_t *str, size_t len) {
  size_t answer = len / sizeof(__m256i) * sizeof(__m256i);
  size_t i;
  for (i = 0; i + sizeof(__m256i) <= len; i += 32) {
    __m256i input = _mm256_loadu_si256((const __m256i *)(str + i));
   answer += __builtin_popcount(_mm256_movemask_epi8(input));
  }
  return answer + scalar_utf8_length(str + i, len - i);
}
```
优化一下

```cpp
ize_t avx2_utf8_length_mkl(const uint8_t *str, size_t len) {
  size_t answer = len / sizeof(__m256i) * sizeof(__m256i);
  size_t i = 0;
  __m256i four_64bits = _mm256_setzero_si256();
  while (i + sizeof(__m256i) <= len) {
    __m256i runner = _mm256_setzero_si256();
    size_t iterations = (len - i) / sizeof(__m256i);
    if (iterations > 255) { iterations = 255; }
    size_t max_i = i + iterations * sizeof(__m256i) - sizeof(__m256i);
    for (; i <= max_i; i += sizeof(__m256i)) {
      __m256i input = _mm256_loadu_si256((const __m256i *)(str + i));
      runner = _mm256_sub_epi8(
        runner, _mm256_cmpgt_epi8(_mm256_setzero_si256(), input));
    }
    four_64bits = _mm256_add_epi64(four_64bits, 
      _mm256_sad_epu8(runner, _mm256_setzero_si256()));
  }
  answer += _mm256_extract_epi64(four_64bits, 0) +
    _mm256_extract_epi64(four_64bits, 1) +
    _mm256_extract_epi64(four_64bits, 2) +
    _mm256_extract_epi64(four_64bits, 3);
    return answer + scalar_utf8_length(str + i, len - i);
}
```

代码在这 https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/tree/master/2023/02/16 我已经看不懂了


- [How to improve application security using _FORTIFY_SOURCE=3](https://developers.redhat.com/articles/2023/02/06/how-improve-application-security-using-fortifysource3)

帮你抓安全问题

- [LLVM社区要求全局变量有最小size值](https://zhuanlan.zhihu.com/p/606553809)

LLVM变动，不懂不评价

- [ntroduce branchless sorting functions for sort3, sort4 and sort5.](https://reviews.llvm.org/D118029)

llvm变动，没细看，不过使用libc++可以白捡这个llvm优化，人家clickhouse都用上了

- [brpc源码--高效资源池ResourcePool](https://zhuanlan.zhihu.com/p/605884686)

- [浅谈 std::wstring_convert 及 utf 编码转换](https://zhuanlan.zhihu.com/p/603234817)

- [C++20 : module 尝试](https://zhuanlan.zhihu.com/p/596229139)

module体验

- [写给新手的MMU工作原理](https://zhuanlan.zhihu.com/p/580719966)

这个概念是需要掌握的。虚拟地址，页表等等

- [Simple Physics-based Flight Simulation with C++](https://www.jakobmaier.at/posts/flight-simulation/)

手把手教你渲染个飞机

- [All about LeakSanitizer ](https://maskray.me/blog/2023-02-12-all-about-leak-sanitizer)

MaskRay写完UBsan介绍又写这个了。笔耕不辍这是

- [Let's write a setjmp](https://nullprogram.com/blog/2023/02/12/)

聪明的你肯定想到了还原堆栈要怎么做。汇编我看不懂，你比我聪明

- [CBMC: The C Bounded Model Checker](https://arxiv.org/abs/2302.02384)

论文。实现个checker

- [Implementing pthread cancellation in mlibc](https://managarm.org/2023/01/21/pthread-cancellation.html)

聪明的你肯定想到了pthread_cancel以及SIG_CANCEL，然后怎么实现？？


- [My review of the C standard library in practice](https://nullprogram.com/blog/2023/02/11/)

评审c代码的一些经验

比如 assert
```c
#define ASSERT(c) if (!(c)) __builtin_trap()
```

再比如

```c
char *s = ...;
if (isdigit(s[0] & 255)) {
    ...
}
```

为什么不能直接用？

或者直接用这玩意

```c
_Bool xisdigit(char c)
{
    return c>='0' && c<='9';
}

```

还有setjmp and longjmp 信号atomic之类的。都没细说。总之谨慎

- [The Real C++ Killers (Not You, Rust)](https://hackernoon.com/the-real-c-killers-not-you-rust)

讲了几个其他语言优化更好的点，替换c++。没啥说的。都能替

- [std::shared_ptr's secret constructor](https://www.justsoftwaresolutions.co.uk/cplusplus/shared-ptr-secret-constructor.html)

@wu-hanqing 投稿。咱们之前在94期也提到过，就是shared_ptr有个别名构造。别用。很坑。鼓励大家投稿。不然显得我玩单机互联网

- [Did you know that with C++20 you can pass concepts?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/317.md)

```cpp
template<class T>
concept foo_like = requires(T t) { t.foo; };

template<auto Concept>
struct foo {
  auto fn(auto f) {
    static_assert(requires { Concept(f); });
  }
};

int main() {
  foo<[](foo_like auto){}> f{};

  struct { int foo{}; } foo;
  struct { } bar;

  f.fn(foo); // ok
  f.fn(bar); // error: contrain not satisfied
}
```

注意这个concept套娃用法，通过lambda绕进去

我觉得还是看个乐。这玩意以后肯定不能这么写，过于邪门歪道

- [不同场景下的 C++ 对象内存布局（英文博客翻译）](https://zhuanlan.zhihu.com/p/604992870)

还不懂？再看一遍

- [Internode Cache Thrashing: Hunting a NUMA Performance Bug ](https://thenewstack.io/internode-cache-thrashing-hunting-a-numa-performance-bug/)

这个定位非常非常非常精彩

首先，perf

```bash
 	
sudo perf stat -C8 --timeout 10000
```
火焰图
```bash	
git clone https://github.com/brendangregg/FlameGraph
git -C FlameGraph remote add adamnovak https://github.com/adamnovak/FlameGraph
git -C FlameGraph fetch adamnovak
git -C FlameGraph cherry-pick 7ff8d4c6b1f7c4165254ad8ae262f82668c0c13b # C++ template display fix
 
x=remote
sudo timeout 10 perf record --call-graph=fp -C8 -o $x.data
sudo perf script -i $x.data > $x.perf
FlameGraph/stackcollapse-perf.pl $x.perf > $x.folded
FlameGraph/flamegraph.pl $x.folded > $x.svg
```
<img src="https://cdn.thenewstack.io/media/2022/06/badef3be-image23-1024x974.png" width="80%">

查到  compact_radix_tree::tree::get_at() and database::apply(). 有问题


```bash
sudo perf annotate -i $x.data
```
<img src="https://cdn.thenewstack.io/media/2022/06/890aeb7a-screen-shot-2022-06-07-at-10.27.36-am-1024x629.png" width="80%">

代码已经找到，但是为啥？？

查事件

```bash
sudo perf stat --timeout 1000000 -C8 ...events... -x\t 2>&1 | sed 's/<not counted>/0/g'
```
<img src="https://cdn.thenewstack.io/media/2022/06/1ff73951-image4.png" width="80%">

<img src="https://cdn.thenewstack.io/media/2022/06/13a5b853-image6.png" width="80%">


需要关注的事件

    CPU_CYCLES, obviously, because we were doing the measurement for the same amount of time in both cases.
    LDREX_SPEC “exclusive operation speculatively executed” — but since it happens only 1,000 times per second, it can’t possibly be the cause.
    EXC_UNDEF “number of undefined exceptions taken locally” — I don’t even know what this means, but it doesn’t seem like a reasonable bottleneck.
    STALL_BACKEND only supports our suspicion that the CPU is bottlenecked on memory somehow.
    REMOTE_ACCESS


REMOTE_ACCESS明显离谱了，seastar已经绑核，哪里来的跨核访问？？？

程序本身的静态数据跨核了？？？？

```bash
sudo cat /proc/$(pgrep -x scylla)/numa_maps
```

```txt
N0=x N1=y means that x pages in the address range are allocated on node 0 and y pages are allocated on node 1. By cross-referencing readelf --headers /opt/scylladb/libexec/scylla we can determine that .text, .rodata and other read-only sections are on node 0, while .data, .bss and other writable sections are on node 1.


```
<img src="https://cdn.thenewstack.io/media/2022/06/876ce736-screen-shot-2022-06-07-at-10.53.50-am-520x1024.png" width="80%">


发现这几个段不在一个核？？不应该啊

强制绑核，发现问题确实如此  `/usr/bin/numactl --membind 1 to /usr/bin/scylla scylla_args…:`


用mbind分析为什么，发现了一个page有共享问题，那就是cacheline颠簸了
```txt
Using this ability, we discover that only one page matters: 0x28c0000, which contains .data, .got.plt and the beginning of .bss. When this page is on node 1, the run is slow, even if all other pages are on node 0. When it’s on node 0, the run is fast, even if all other pages are on node 1.
```
尝试改二进制，加padding，解决了？？根因是什么？怎么加padding？

```txt
We can move the suspicious area by stuffing some padding before it. .tm_clone_table seems like a good enough place to do that. We can add an array in .tm_clone_table somewhere in ScyllaDB and recompile it. (By the way, note that our hacked-in mbind API writes something to this array to prevent it from being optimized out. If it wasn’t used, the linker would discard it because ScyllaDB is compiled with -fdata-sections).

Let’s try to pad .got.plt to a page boundary to test this hack.
```
既然找到问题，就gdb抓堆栈

```gdb
sudo gdb -p (pgrep -x scylla)
(gdb) watch *0x28d0000
(gdb) watch *0x28d0008
(gdb) watch *0x28d0010
(gdb) watch *0x28d0018
(gdb) continue
```
击中之后看一下符号

```gdb
(gdb) info symbol 0x28d0000
```
修复

```cpp
       node_head_ptr& operator=(node_head* v) noexcept {
            _v = v;
 -          if (_v != nullptr) {
            // Checking (_v != &nil_root) is not needed for correctness, since
            // nil_root's _backref is never read anyway. But we do this check for
            // performance reasons: since nil_root is shared between shards,
            // writing to it would cause serious cache contention.
 +          if (_v != nullptr && _v != &nil_root) {
                _v->_backref = this;
            }
            return *this;
```

这个查问题的方式，后半部分，已经超出我的知识范围了。我只能说牛逼。


- [Cursed C++: Alternative Operators](https://www.cedricmartens.com/articles/alt_ops)

```cpp
%:include <iostream>

struct A <%
    A(int bitand a) : a(a) {}
    int bitand a;
%>;


int main(int argc, char**argv)
<%
    if(argc not_eq 2) <% return 1;%>

    int n = std::atoi(argv<:1:>);
    A a(n);

    auto func = <:bitand:>(A a)<%
        std::cout << a.a << std::endl;
    %>;

    func(a);
    return 0;
%>
```

这种符号表达已经废弃了。C的糟粕

- [What does it mean when my cross-thread COM call fails with RPC_E_SYS_CALL_FAILED?](https://devblogs.microsoft.com/oldnewthing/20230216-00/?p=107836)
- [What are the potentially-erroneous results if you don’t pass NULL as the lpNumberOfBytesRead when issuing overlapped I/O?](https://devblogs.microsoft.com/oldnewthing/20230215-00/?p=1078320)

raymond chen 经典介绍winapi。看不懂就不多逼逼了
## 视频

- [C++ Weekly - Ep 363 - A (Complete?) Guide To C++ Unions](https://www.youtube.com/watch?v=Lu1WsdQOi0E&ab_channel=C%E1%90%A9%E1%90%A9WeeklyWithJasonTurner)

没啥说的

- [Meeting C++ YT - Basic usage of PMRs for better performance - Marek Krajewski - Meeting C++ 2022](https://www.youtube.com/watch?v=I6nDF9IEsRE&ab_channel=MeetingCpp)

看PPT就感觉很精彩了。视频还没更

PPT在这里  https://meetingcpp.com/mcpp/slides/2022/Basic%20usage%20of%20PMRs%20for%20better%20performance8308.pdf

业务场景以及使用方法，都介绍了。

- [CppCon YT - Reflection in C++ - Past, Present, and Hopeful Future - Andrei Alexandrescu - CppCon 2022](https://www.youtube.com/watch?v=YXIVw6QFgAI&t=1s&ab_channel=CppCon)

AA大神都演讲一直都很有意思。不过我没看。最近线上出事了写复盘报告没时间
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [NeatReflection](https://github.com/FireFlyForLife/NeatReflection) 一个基于module产物的反射？？？？还能这么玩？？？？？？

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/101.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
