---
layout: post
title:  第100期
---
# C++ 中文周刊 第100期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

本周内容不多

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2023-02-08 第188期 ](https://mp.weixin.qq.com/s/ET26mVgWrsgOCQZ5p11iiA)

关于标准委员会的吵架动态，可以看 https://www.zhihu.com/people/mick235711 的动态。这里就不转发了
## 文章

- [360 安全规则集合](https://github.com/Qihoo360/safe-rules/)

360发布了他们的代码安全规范，还是值得一看的，UB描述了很多

- [为什么main里死循环还会执行其他函数？](https://zhuanlan.zhihu.com/p/604969380)

一段到处都在传播的代码

```cpp
#include <iostream>
int main() {
  while(1)
  ;
}

void unreachable() {
  std::cout << "hello world\n";
}
```

clang会打印hello world而gcc/msvc不会，为啥？？

简单来说是没用到的死循环直接给删了，然后没有ret，直接跳到下一个函数了

这也是UB的一种。感兴趣的可以点进去看看

- [Optimizing Redis’ Default Compiler Flags](https://redis.com/blog/optimizing-redis-compiler-flags/)

-O3 -flto 性能起码提升5%，后续引入PGO继续探索。PGO还是很值得研究的，针对业务来优化效率更高

- [Did you know about std::rank/std::rank_v type_trait to get the rank of the array? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```c++
static_assert(0 == std::rank_v<void>);
static_assert(0 == std::rank_v<int>);
static_assert(1 == std::rank_v<int[]>);
static_assert(0 == std::rank_v<int[0]>);
static_assert(1 == std::rank_v<int[1]>);
static_assert(1 == std::rank_v<int[42]>);
static_assert(2 == std::rank_v<int[][2]>);
static_assert(2 == std::rank_v<int[1][2]>);
static_assert(3 == std::rank_v<int[1][2][3]>);

```

数组的维度，这玩意和向量的秩英文名一样啊。。

如何实现？

```cpp
#include <type_traits>

template<class T>
struct prev;

template<class T, int N>
struct prev<T[N]> : std::type_identity<T> {};

template<class T>
struct prev<T[]> : std::type_identity<T> {};

template<class T>
constexpr auto return_rank()
{
    if constexpr (::std::is_array_v<T>) {
        return return_rank<typename prev<T>::type>() + 1;
    }
    return 0;
}

template<class T>
constexpr auto rank_v = return_rank<T>();
```

- [Compiling QML to C++: A 4x speedup](https://www.qt.io/blog/compiling-qml-to-c-a-4x-speedup)

QML_DISABLE_DISK_CACHE=1 加速 QML编译

- [Can sanitizers find the two bugs I wrote in C++?](https://ahelwer.ca/post/2023-02-07-cpp-bugs-sanitized/)

省流：可以

- [A more direct and mistake-free way of creating a process in a job object](https://devblogs.microsoft.com/oldnewthing/20230209-00/?p=107812)

又是WinAPI，我看不懂不多逼逼

- [Floating-Point Comparison](https://accu.org/journals/overload/31/173/floyd/#_idTextAnchor009)

浮点数比较，很烦

```cpp
bool cmpEq(double a, double b, 
  double epsilon = 1e-7, double abstol = 1e-12)
{
  if (a == b) { // 判断inf用的，傻逼inf
    return true;
  }
  double diff = std::fabs(a - b);
  double reltol = std::max(std::fabs(a),
    std::fabs(b)) * epsilon;
  return diff < reltol || diff < abstol;
}
```

家人们还是看看远处的boost实现吧 https://www.boost.org/doc/libs/1_81_0/boost/test/tools/floating_point_comparison.hpp

- [Stack Frame Layout On x86-64](https://accu.org/journals/overload/31/173/bendersky/)

寄存器，用eax, ebx, ecx, edx, ebp, esp, esi, edi, r8, r9, r10, r11, r12, r13, r14, r15 ,rax eax宽度区别

传参数，用 rdi, rsi, rdx, rcx, r8 r9, 放不下放栈上

来个例子

```c
long myfunc(long a, long b, long c, long d,
            long e, long f, long g, long h)
{
  long xx = a * b * c * d * e * f * g * h;
  long yy = a + b + c + d + e + f + g + h;
  long zz = utilfunc(xx, yy, xx % yy);
  return zz + 20;
}
```

<img src="https://wanghenshui.github.io/assets/myfunc.png" alt=""  width="80%">

rbp 大家也都懂，也会优化掉，因为可以根据rsp算出来。`-fno-omit-frame-pointer`可以保留

- [How can I get the original target of a shortcut without applying any 32-bit adjustments?](https://devblogs.microsoft.com/oldnewthing/20230208-00/?p=107807)

看不懂

- [Embracing Modern C++ Safely, Book Review ](https://www.cppstories.com/2022/embracing-modern-cpp-book/)

书评。没看到书没啥说的

- [GCC’s -O3 Can Transform Performance](https://sunnyflunk.github.io/2023/01/29/GCCs-O3-Can-Transform-Performance.html)

测了一些软件用O3编译二进制大了点，但性能都有提升

## 视频

最近没啥看的 

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [PocketPy](https://github.com/blueloveTH/pocketpy) 嵌入式python实现，有点意思
- [Boost.Mustache ](https://github.com/pdimov/mustache) 说不定能进 mustache模版
- [quill v2.7.0 released - Asynchronous Low Latency C++ Logging Library](https://github.com/odygrd/quill) 之前也聊过，版本更新
- [CTHASH (Compile Time Hash)](https://github.com/hanickadot/cthash) 编译期 sha实现
- [CoFSM](https://github.com/tirimatangi/CoFSM) 基于协程的状态机
- [kelcoro](https://github.com/kelbon/kelcoro#channelt) 协程库
- [Cryptography library for modern C++. ](https://github.com/milosob/milo)

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/100.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
