---
layout: post
title:  第96期
---
# C++ 中文周刊 第96期

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom



欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

0113

部门聚餐了延误了一下。本周没看视频

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2023-01-11 第184期 ](https://mp.weixin.qq.com/s/XJM04tRrggyQOf0K2bXD7A)

一个博客收集网站 https://swedencpp.se/blogs 英文c++的最新博客收集

## 文章

- [游戏开发中，程序如何计算巨大的伤害数字，如超过long int范围的数字？](https://www.zhihu.com/question/577701903/answer/2840399800)

取对数

- [静态链接和静态库实践指北](https://zhuanlan.zhihu.com/p/595527528)

哎。倒腾cmake我头疼

- [Google公布大杀器TCP Protective Load Balancing，支持linux 6.2，均衡负载新革命](https://zhuanlan.zhihu.com/p/580984408)

有点意思。这种针对牛逼网卡的优化我感觉大厂都在做类似的玩意

- [Supporting the Use of Rust in the Chromium Project ](https://security.googleblog.com/2023/01/supporting-use-of-rust-in-chromium.html)

又一个c++项目引入rust的。之前有火狐浏览器，clickhouse, redpanda，linux内核，唱衰一波，不过不要慌，c++程序员一时半会不会失业

- [c++ tip of week Did you know that C++20 added support for Unevaluated asm-declaration in constexpr functions?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

看代码

```cpp
constexpr auto get = [](auto value) {
  if consteval {
    return value;
  } else {
    auto result = 0;
    asm("movl $42, %%eax\n" : "=r" (result) );
    return result;
  }
};

static_assert(0 == get(0));
static_assert(4 == get(4));
static_assert(2 == get(2));

consteval auto fn() {
    return get(0);
}

int main(int argc, char**) {
  assert(42 == get(0));
  assert(42 == get(argc));
  return fn();
}
```

- [C++20/clang-15 static reflection via `__builtin_dump_struct`](https://godbolt.org/z/GGe6vrWd8)

<img src="https://user-images.githubusercontent.com/8872493/211458543-1bcaf140-15cf-49e6-8768-555b67b55ae7.png" alt=""  width="80%">

希望大家身体健康，活得久一点，就能用到静态反射了

- [On leading underscores and names reserved by the C and C++ languages](https://devblogs.microsoft.com/oldnewthing/20230109-00/?p=107685)

编译器标准库用到很多变量是两个下划线 下划线大写字母开头的。自己定义变量尽量别用

- [Transcoding Unicode with AVX-512: AMD Zen 4 vs. Intel Ice Lake](https://lemire.me/blog/2023/01/05/transcoding-unicode-with-avx-512-amd-zen-4-vs-intel-ice-lake/)

测了一下simdutdf在Zen4的表现，挺强的

- [2022 APFS Advent Challenge Day 17 - Blazingly Fast Checksums with SIMD](https://jtsylve.blog/post/2022/12/23/Blazingly-Fast-Checksums-with-SIMD)

blake3是不是就是simd加速的？

- [Pictures of a Working Garbage Collector](https://www.oilshell.org/blog/2023/01/garbage-collector.html)

给oilshell设计的GC。没仔细看

- [Care is needed to use C++ std::optional with non-trivial objects](https://lemire.me/blog/2023/01/12/care-is-needed-to-use-c-stdoptional-with-non-trivial-objects/)

optional做函数参数是十分不恰当的。这玩意只适合做返回值

- [On QVarLengthArray and Uninitialized Storage in C++](https://www.kdab.com/qvarlengtharray/)

QVarLengthArray类似vector，区别在于对小数据做SBO优化，且resize不会做额外的初始化动作。初始化动作是c++默认有的。很多场景来看是多余的，比如string。c++20/23做了许多修正

比如

```cpp
std::unique_ptr<int[]> p3 = std::make_unique_for_overwrite<int[]>(100'000);
```

再比如string

```cpp
// C++23
std::string s = ~~~;
 
auto oldSize = s.size();
 
s.resize_and_overwrite(100'000, [oldSize](char *buf, std::size_t count) {
 
  // For starters, s will *reserve* enough space, without initializing it.
  //
  // - buf points to the string's storage (i.e. s.data()) *after* the reserve;
  // - count is the 1st argument to resize_and_overwrite (100k), so
  //   we can re-use this function with different `count`s.
 
 
  // Populate the range [buf, buf+count]. We can mutate the entirety of
  // the string's buffer. But let's say we're just interested in populating
  // the new contents -- from position oldSize up to count.
  for (size_it i = oldSize; i < count; ++i)
    buf[i] = generateData(i);
 
  // Notes:
  // - If we're growing, the newly created storage is *uninitialized*.
  //   Don't read from it!
  //
  // - The old contents are still there, and we can access them freely.
  //   If needed, carry `oldSize` manually, to identify where to start 
  //   writing (and leave the old contents alone).
  //
  // - It is legal to write into buf[count],
  //   but it will be overwritten with \0 when we're done.
     
  // We don't need to populate the *entire* buffer -- we may stop short!
  // The returned value will be the new size of the string.
 
  return actual_new_size;
});
```

QVarLengthArray不会做多余的初始化，请注意(不过QT这套东西会玩的越来越少了，大部分读者应该不玩QT)

- [What&#39;s an executable and how is it structured](https://www.sandordargo.com/blog/2023/01/11/executable-and-its-structure)

基础知识，不会的可以去看《程序员的自我修养 链接/库》这本书

- [What does it mean when I get a mismatch from MSVC for _COROUTINE_ABI?](https://devblogs.microsoft.com/oldnewthing/20230111-00/?p=107694)

MSVC有两套coroutine API

```c++
// in <experimental/coroutine>
#ifndef _ALLOW_COROUTINE_ABI_MISMATCH
#pragma detect_mismatch("_COROUTINE_ABI", "1")
#endif // _ALLOW_COROUTINE_ABI_MISMATCH

// in <coroutine>
#ifndef _ALLOW_COROUTINE_ABI_MISMATCH
#pragma detect_mismatch("_COROUTINE_ABI", "2")
#endif // _ALLOW_COROUTINE_ABI_MISMATCH
```

使用 `/std:c++20`和 `/std:c++latest`，才会用最新的api，experimental是c++17旧的

- [How should I interpret the various values of NLM_CONNECTIVITY?](https://devblogs.microsoft.com/oldnewthing/20230112-00/?p=107700)

又是Windows API，如何处理flags，我直接贴下面，不懂windows

| Flag                | Meaning                                                                                                | Recommendation                       |
| ------------------- | ------------------------------------------------------------------------------------------------------ | ------------------------------------ |
| DISCONNECTED        | No network interface detects any network                                                               | Treat as offline.                    |
| NOTRAFFIC           | An interface is connected, but it cannot send or receive network traffic.                              | Treat as offline.                    |
| SUBNET/LOCALNETWORK | An interface has been configured to send traffic, but the system cannot confirm Internet connectivity. | Make one attempt to contact service. |
| INTERNET            | The system has confirmed access                        to Microsoft Internet sites.                    | Treat as fully online.               |


- [It rather involved being on the other side of this airtight hatchway: Administrator attacking a domain account on the local system](https://devblogs.microsoft.com/oldnewthing/20230110-00/?p=107688)

没看懂
## 视频

- [C++ Weekly - Ep 358 - C23&#39;s #embed and C++23&#39;s #warning ](https://www.youtube.com/watch?v=ibKnNRAq5UY)

没啥说的，之前讲过，#embed可以嵌入二进制，比如插个音乐，文本等等

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [vtkImplicitArrays: A new VTK framework for manipulating array-like data](https://www.kitware.com/vtkimplicitarrays-a-new-vtk-framework-for-manipulating-array-like-data/)

 没看懂这玩意是干什么的

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/096.html)

如果有疑问评论最好在上面链接到评论区里评论，这样方便搜索，微信公众号有点封闭/知乎吞评论
