---
layout: post
title:  第91期
---
# C++ 中文周刊 第91期

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



欢迎投稿，推荐或自荐文章/软件/资源等

可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/25)

1202

---

## 资讯

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2022-11-30 第178期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-11-30.md)

## 文章

- [Stack overflow in ping(8)](https://www.freebsd.org/security/advisories/FreeBSD-SA-22:15.ping.asc)

离谱，freebsd的ping 有溢出漏洞

- [const vs constexpr vs consteval vs constinit in C++20 ](https://www.cppstories.com/2022/const-options-cpp20/)


  来个 表格

| 关键字    | 放在变量前                     | 放在static/thread_local前 | 放在函数前                    | 常量表达式前     |
| --------- | ------------------------------ | ------------------------- | ----------------------------- | ---------------- |
| const     | 可以                           | 可以                      | 成员函数                      | 有时可以         |
| constexpr | 可以 （初始化得是constexpr的） | 可以                      | 必须是满足constexpr属性的函数 | 可以             |
| consteval | 不行                           | 不行                      | 满足consteval的函数           | 接受返回值，可以 |
| constinit | 不行                           | 必须常量初始化            | 不行                          | 不行             |

- [Falsehoods programmers believe about undefined behavior](https://predr.ag/blog/falsehoods-programmers-believe-about-undefined-behavior/)

`未定义行为` 不一定是实现决定，`未定义行为`就是 `未定义行为`, 就是可能任何事都会发生，别想当然

- [Everything I wish I knew when learning C ](https://tmewett.com/c-tips/)

列了一堆c的资料以及语法细节

- [Did you know about if/else hell anti-pattern?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```cpp
[[nodiscard]] constexpr auto if_hell(bool c1, bool c2) {
    if (c1) {
        if (c2) {
            return true;
        } else {
            throw;
        }
    }

    // ...

    return false;
}

static_assert(not if_hell(false, false));
static_assert(not if_hell(false, true));
assert(throws([]{ if_hell(true, false)); }));
static_assert(if_hell(true, true));

[[nodiscard]] constexpr auto if_heaven(bool c1, bool c2) {
    if (not c1) {
        return false;
    }

    if (not c2) {
        throw;
    }

    // ...

    return true;
}

static_assert(not if_heaven(false, false));
static_assert(not if_heaven(false, true));
assert(throws([]{ if_heaven(true, false)); }));
static_assert(if_heaven(true, true));
```

别写if_hell这种面条。尽量提前结束

- [GCC undefined behaviors are getting wild](http://blog.pkh.me/p/37-gcc-undefined-behaviors-are-getting-wild.html)

看代码

```cpp
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

uint8_t tab[0x1ff + 1];

uint8_t f(int32_t x)
{
    if (x < 0)
        return 0;
    int32_t i = x * 0x1ff / 0xffff;
    if (i >= 0 && i < sizeof(tab)) {
        printf("tab[%d] looks safe because %d is between [0;%d[\n", i, i, (int)sizeof(tab));
        return tab[i];
    }

    return 0;
}

int main(int ac, char **av)
{
    return f(atoi(av[1]));
}

```

一个经典UB，既然溢出是UB，那么GCC就假定永远不会溢出，这里的条件判断统统删除，所以执行一个溢出的数，直接coredump

大家有时间可以读一下UB指南 https://blog.regehr.org/archives/213 没工夫读的，我总结一下

- [C++23: auto(x) and decay copy](https://www.sandordargo.com/blog/2022/11/30/cpp23-auto-and-decay-copy)

说过挺多次了。就是有些场景引用可能带来副作用，对于引用主动decay copy成值语义

- [Generalized "value" types and prototypal operation for C++ objects](https://ossia.io/posts/valuetypes/)

讲反射的。代码写的和`boost.fpr(magic_get)`差不多吧

- [A study of several issues found with static analysis](https://mariusbancila.ro/blog/2022/11/28/a-study-of-several-issues-found-with-static-analysis/)

用静态分析抓bug。场景都特简单

```cpp
int main() {
   std::vector<int> data{ 1,1,2,3,5,8,13,21,34,55 };
   for (auto it = data.begin(); it != data.end();) {
      /* do something with *it */
      if (*it % 2 == 0) {
         data.erase(it);
      } else {
         ++it;
      }
   }
   for (auto const& e : data)
      std::cout << e << '\n';
}
```

问题出在哪里？入门级

- [Pure C Clang is better than GCC](https://yurichev.org/clang/)

代码写错，

```cpp
  if (memcmp(m_result_original, m_result_my_version, sizeof(struct tmp))!=0)
  if (memcmp(m_result_original, m_result_my_version, sizeof(struct tmp)!=0)) //括号匹配错了
```

第二种写法gcc告警很不清晰

```bash
2.c:17:72: warning: size argument in 'memcmp' call is a comparison [-Wmemsize-comparison]
  if (memcmp(m_result_original, m_result_my_version, sizeof(struct tmp)!=0))
                                                     ~~~~~~~~~~~~~~~~~~^~~
2.c:17:7: note: did you mean to compare the result of 'memcmp' instead?
  if (memcmp(m_result_original, m_result_my_version, sizeof(struct tmp)!=0))
      ^                                                                   ~
                                                                       )
2.c:17:54: note: explicitly cast the argument to size_t to silence this warning
  if (memcmp(m_result_original, m_result_my_version, sizeof(struct tmp)!=0))
                                                     ^
                                                     (size_t)(            )
1 warning generated.
```

这种问题怎么规避？

- [Pointer compression in Oilpan](https://v8.dev/blog/oilpan-pointer-compression)

介绍oilpan的。一个GC框架，Chrome V8引入这个GC，又支持了pointer compression 指针压缩。指针48位明显用不完，olipan搞到了32位，还有压缩空间

- [What kind of caller diagnostic information can I get from exceptions thrown by C++/WinRT and wil?](https://devblogs.microsoft.com/oldnewthing/20221121-00/?p=107429)
- [What kind of caller diagnostic information can I get from exceptions thrown by C++/WinRT and wil?, C++20 edition](https://devblogs.microsoft.com/oldnewthing/20221128-01/?p=107469)
- [On Windows Runtime asynchronous operations with critical progress reports](https://devblogs.microsoft.com/oldnewthing/20221118-00/?p=107421)
- [The case of the application that used thread local storage it never allocated](https://devblogs.microsoft.com/oldnewthing/20221128-00/?p=107456)
- [Not even trying to cross an airtight hatchway: Calling a function in your own process by synthesizing a function pointer](https://devblogs.microsoft.com/oldnewthing/20221201-46/?p=107528)

讲windows API的。没怎么看懂。Raymond Chen高产似母猪啊

- [QEMU逃逸系列](https://zhuanlan.zhihu.com/p/588124131)

看不懂
## 视频

- [Graph Algorithms and Data Structures in C++20 - Phil Ratzloff & Andrew Lumsdaine - CppCon 2022](https://www.youtube.com/watch?v=jCnBFjkVuN0)

代码在这里 https://github.com/stdgraph/graph-v2

老哥非常乐观

<img src="https://user-images.githubusercontent.com/8872493/205291909-401cc88d-e987-43e7-b90d-a939cac56599.png" alt=""  width="80%">

- [Using Modern C++ to Eliminate Virtual Functions - Jonathan Gopel - CppCon 2022](https://www.youtube.com/watch?v=gTNJXVmuRRA)

<img src="https://user-images.githubusercontent.com/8872493/205293310-7b6558f6-893e-4862-9ca0-c2631e180dfd.png" alt=""  width="80%">

还能这么玩？？？

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [tag ptr](https://github.com/marzer/tagged_ptr) 
- [mini-rv32ima](https://github.com/cnlohr/mini-rv32ima) 模拟器，不懂


## 工作招聘

开始刷leetcode了。现在工作真卷啊，算法题我都忘光了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/091.html)
