---
layout: post
title:  第90期
---
# C++ 中文周刊 第90期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/23)


---

## 资讯


[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-11-23 第177期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-11-23.md)


## 文章

- [C++性能优化白皮书-书评](https://zhuanlan.zhihu.com/p/586428464)

看个乐

- [SIMD简介](https://zhuanlan.zhihu.com/p/55327037)

了解一波

- [Sometimes perfect forwarding can be too perfect: Lazy conversion is lazy](https://devblogs.microsoft.com/oldnewthing/20221123-00/?p=107443)

```cpp
class Derived : Base
{
    void DoSomething()
    {
        auto p1 = std::make_unique<BaseAcceptor>(static_cast<Base*>(this));
        auto p2 = std::make_shared<BaseAcceptor>(static_cast<Base*>(this));

        std::vector<BaseAcceptor> v;
        v.emplace_back(static_cast<Base*>(this));
    }
};
```

忘记打public 继承，多了一堆static_cast

- [Inside boost::unordered_flat_map](https://bannalia.blogspot.com/2022/11/inside-boostunorderedflatmap.html?m=1) 
  
  目前boost::unordered_flat_map是最快的hashmap了，但是他们做了啥技巧能这么快呢？一些缓存友好的设计，以及simd

- [Secure and efficient QNetworkAccessManager use](https://www.volkerkrause.eu/2022/11/19/qt-qnetworkaccessmanager-best-practices.html)

qt一些使用QNetworkAccessManager的细节

**记得删除reply**
```cpp
QNetworkReply *reply = ...
connect(reply, &QNetworkReply::finished, this, [reply]()) {
    reply->deleteLater();
    //...
});
```

**使用https，不多说**

**QNetworkAccessManager不要一个请求创建一个**

**重定向**

qt5是关的，需要设置一下，qt6是默认设置好了的

```cpp
auto nam = new QNetworkAccessManager(this);
nam->setRedirectPolicy(QNetworkRequest::NoLessSafeRedirectPolicy);
```

**HSTS**

这个我不懂

```cpp
auto nam = new QNetworkAccessManager(this);
nam->setStrictTransportSecurityEnabled(true);
nam->enableStrictTransportSecurityStore(true, QStandardPaths::writableLocation(QStandardPaths::CacheLocation) + QLatin1String("/hsts/"));
```

**SSL错误处理**

```cpp
QNetworkReply *reply = ...
connect(reply, &QNetworkReply::sslErrors, this, [reply](const QList<QSslError> &errors) {
    KSslErrorUiData errorData(reply, errors);
    if (KIO::SslUi::askIgnoreSslErrors(errorData)) {
        reply->ignoreSslErrors();
    }
});
```

**Disk cache**

```cpp
auto nam = new QNetworkAccessManager(this);
auto diskCache = new QNetworkDiskCache(nam);
diskCache->setCacheDirectory(QStandardPaths::writableLocation(QStandardPaths::CacheLocation) + QLatin1String("/http/"));
nam->setCache(diskCache);
```

- [How To Use Exceptions Correctly](https://thelig.ht/correct-exceptions/)

省流：别用

- [  Who Says C is Simple?](https://cil-project.github.io/cil/doc/html/cil/cil016.html)

省流：犄角旮旯语法教学，别看

- [How to Measure String SSO Length with constinit and constexpr ](https://www.cppstories.com/2022/sso-cpp20-checks/)

c++20 SSO优化的短字符串string是能查到长度的，gcc/msvc是15个，clang是23个，当然如果string_view任何长度都可以查长度

- [Exploring the Limits of Class Template Argument Deduction](https://www.lukas-barth.net/blog/exploring-limits-ctad/)
  
  CTAD能玩出什么花来，我的评价是尽量别用CTAD

- [Book Review: Embracing Modern C++ Safely](https://julien.jorge.st/posts/en/book-review-embracing-modern-cpp-safely/)
  
书评。这本书讲的不错，列一段代码


```cpp
Logger& getLogger() {
  // Even if two threads call getLogger() simultaneously,
  // local will be constructed only once.
  static Logger local("log.txt");
  return local;
}

struct FileManager {
  FileManager()
  {
    getLogger() << "Starting up file manager…";
    // …
  }

  ~FileManager()
  {
    getLogger() << "Shutting down file manager…";
    // …
  }
};

FileManager& getFileManager() {
  // Global fileManager, initialized on the first call
  // to getFileManager().
  static FileManager fileManager;
  return fileManager;
}

```

这两个是很常规的代码，但组合到一起，就有了问题，析构！如果Logger先于FileManager析构，FileManager的析构用到了已经析构的Logger，崩溃

这种通常是在程序退出的时候莫名其妙多个core。如何合理的解决这个问题？加锁？

- [C++23: How lambdas are going to change?](https://www.sandordargo.com/blog/2022/11/23/cpp23-changes-to-lambdas)
  
  lambda进化了，举例

```cpp
auto counter = [j=0]() mutable -> decltype(j) {
    return j++;
};

auto lm = [][[nodiscard]]()->int { return 42; };

```
- [C++ Move Semantics Considered Harmful (Rust is better)](https://www.thecodedmessage.com/posts/cpp-move/)

比较c++ 和rust的move，c++的move确实有点高深，不清晰

- [kmem_guard_t](https://saaramar.github.io/kmem_guard_t_blogpost/)

iOS 16 / macOS 13 支持的新特性，走读一波c api。感兴趣的可以看看
## 视频

- [Scalable and Low Latency Lock-free Data Structures in C++ - Alexander Krizhanovsky - CppCon 2022](https://www.youtube.com/watch?v=_dS4Z6JifPs)

一个无锁hashtable

代码

 https://github.com/tempesta-tech/blog/tree/master/htrie

https://github.com/tempesta-tech/tempesta/blob/master/db

- [High Speed Query Execution with Accelerators and C++ - Alex Dathskovsky - CppCon 2022](https://www.youtube.com/watch?v=V_5p5rukBlQ&list=PLHTh1InhhwT6c2JNtUiJkaH8YRqzhU7Ag&index=47&t=1134s)

卖APU的

- [Refresher on Containers, Algorithms and Performance in C++ - Vladimir Vishnevskii - CppCon 2022](https://www.youtube.com/watch?v=F4n3ModsWHI)

容器的各种性能指标。不用看

- [Back to Basics: C++ Testing - Amir Kirsh - CppCon 2022](https://www.youtube.com/watch?v=SAM4rWaIvUQ)

没啥意思，可以不看

- [Undefined Behavior in the STL - Sandor Dargo - CppCon 2022](https://www.youtube.com/watch?v=fp45k9gsnUo)
  
  各种边界越界UB/空的容器的front() pop_front() back() pop_back(),string_view ，各种迭代器使用，迭代器range有问题

![图片](https://user-images.githubusercontent.com/8872493/203985482-ed31468b-eefa-485e-8e59-1e32461bf302.png)

感觉演讲者都绷不住了

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [libjsonschema](https://git.sr.ht/~emersion/libjsonschema) 把json描述的schema转成c代码 （为啥不用protocol buffer，只要一复杂，最后都会变成protocol buffer）
- [c99-to-c89](https://github.com/libav/c99-to-c89) Tool to convert C99 code to MSVC-compatible C89 你没有看错
- [sold](https://github.com/bluewhalesystems/sold) 之前的mold链接器 换个license，开卖
## 工作招聘

T_T
---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/090.html)
