---
layout: post
title:  第89期
---
# C++ 中文周刊 第89期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/23)

2022 1118 今天有事，提前发了

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-11-16 第176期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-11-16.md)


## 文章

- [target_clones is a trap](https://cohost.org/zeux/post/321642-target-clones-is-a-t)

使用target_clones能帮助生成平台兼容的SIMD代码，具体呢就是生成N份汇编。比如这种。https://godbolt.org/z/of5d6v

但问题在于，某些平台某些libc某些编译器可能不支持/支持程度不够，导致你用了这玩意但是实际上没生效，使用的时候需要注意

- [C++ 性能优化之分支预测](https://zhuanlan.zhihu.com/p/48145176)

一个perf查性能的思路。当然循环里的if是比较不合时宜的，不利于编译器展开

- [For Software Performance, the Way Data is Accessed Matters!](https://johnnysswlab.com/for-software-performance-the-way-data-is-accessed-matters/)

循环访问大有学问，涉及到 循环的优化，上面也说了，循环里的条件判断非常不合理

- [Did you know that tuple can be implement just with lambdas? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/304.md)

```cpp
constexpr auto tuple = [][[nodiscard]](auto... args) {
    return [=][[nodiscard]](auto fn)  { return fn(args...); };
};

constexpr auto apply(auto fn, auto t) { return t(fn); };

static_assert(0 == apply([](auto... args) { return sizeof...(args); }, tuple()));
static_assert(1 == apply([](auto... args) { return sizeof...(args); }, tuple(1)));
static_assert(2 == apply([](auto... args) { return sizeof...(args); }, tuple(1, 2)));

namespace detail {
template <std::size_t N, typename T> struct elem_by_index { T &ref; };
template <typename T> struct elem_by_type { T &ref; };
} // namespace detail

template <auto N> [[nodiscard]] constexpr auto get(auto t) {
    return t([]<typename... Ts>(Ts... elems) {
        return [&]<std::size_t... Is>(std::index_sequence<Is...>) {
            struct all_elems : detail::elem_by_index<Is, Ts>... {};
            return []<typename U>(const detail::elem_by_index<N, U> &elem) {
                return elem.ref;
            }(all_elems{elems...});
        }(std::index_sequence_for<Ts...>{});
    });
}

template <class T> [[nodiscard]] constexpr auto get(auto t) {
    return t([]<typename... Ts>(Ts... elems) {
        struct all_elems : detail::elem_by_type<Ts>... {};
        return [](const detail::elem_by_type<T> &elem) {
            return elem.ref;
        }(all_elems{elems...});
    });
};
```

看不懂

- [Modern vector programming with masked loads and stores](https://lemire.me/blog/2022/11/08/modern-vector-programming-with-masked-loads-and-stores/)

改写这个
```cpp
int f() {
    int* data = new int[2];
    data[0] = 1;
    data[1] = 2;
    int x = data[0];
    int y = data[1];
    int z = data[2];
    delete[] data;
    return x + y;
} 
```
用avx512 第一版

```c++
float dot512fma(float *x1, float *x2, size_t length) {
  // create a vector of 16 32-bit floats (zeroed)
  __m512 sum = _mm512_setzero_ps();
  for (size_t i = 0; i < length; i += 16) {
    // load 16 32-bit floats
    __m512 v1 = _mm512_loadu_ps(x1 + i);
    // load 16 32-bit floats

    __m512 v2 = _mm512_loadu_ps(x2 + i);
    // do sum[0] += v1[i]*v2[i] (fused multiply-add)
    sum = _mm512_fmadd_ps(v1, v2, sum);
  }
  // reduce: sums all elements
  return _mm512_reduce_add_ps(sum);
}
```

问题在于 `i<length`越界,如何解决 ？这就用标题讲的 `mask load/store`

```cpp
float dot512fma(float *x1, float *x2, size_t length) {
  // create a vector of 16 32-bit floats (zeroed)
  __m512 sum = _mm512_setzero_ps();
  size_t i = 0;
  for (; i + 16 <= length; i+=16) {
    // load 16 32-bit floats
    __m512 v1 = _mm512_loadu_ps(x1 + i);
    // load 16 32-bit floats
    __m512 v2 = _mm512_loadu_ps(x2 + i);
    // do sum[0] += v1[i]*v2[i] (fused multiply-add)
    sum = _mm512_fmadd_ps(v1, v2, sum);
  }
  if  (i  < length) {
    // load 16 32-bit floats, load only the first length-i floats
    // other floats are automatically set to zero
    __m512 v1 = _mm512_maskz_loadu_ps((1<<(length-i))-1, x1 + i);
    // load 16 32-bit floats, load only the first length-i floats
    __m512 v2 = _mm512_maskz_loadu_ps((1<<(length-i))-1, x2 + i);
    // do sum[0] += v1[i]*v2[i] (fused multiply-add)
    sum = _mm512_fmadd_ps(v1, v2, sum);
  }
  // reduce: sums all elements
  return _mm512_reduce_add_ps(sum);
}
```

arm平台怎么做？

```cpp
float dotsve(float *x1, float *x2, int64_t length) {
  int64_t i = 0;
  svfloat32_t sum = svdup_n_f32(0);
  while(i + svcntw() <= length) {
    svfloat32_t in1 = svld1_f32(svptrue_b32(), x1 + i);
    svfloat32_t in2 = svld1_f32(svptrue_b32(), x2 + i);
    sum = svmad_f32_m(svptrue_b32(), in1, in2, sum);
    i += svcntw();
  }
  svbool_t while_mask = svwhilelt_b32(i, length);
  do {
    svfloat32_t in1 = svld1_f32(while_mask, x1 + i);
    svfloat32_t in2 = svld1_f32(while_mask, x2 + i);
    sum = svmad_f32_m(svptrue_b32(), in1, in2, sum);
    i += svcntw();
    while_mask = svwhilelt_b32(i, length);
  } while (svptest_any(svptrue_b32(), while_mask));

  return svaddv_f32(svptrue_b32(),sum);
}
```

代码在这里，可以简单玩一下 https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/tree/master/2022/11/08

- [Using final in C++ to improve performance](https://blog.feabhas.com/2022/11/using-final-in-c-to-improve-performance/)

鼓励多用final。这个是常识了

- [Writing a Compiler - Part 1 - Defining The Language](https://m-peko.github.io/craft-cpp/posts/writing-a-compiler-part-1/)
  
  手把手教你写编译器，代码在这里[godbolt](https://godbolt.org/#z:OYLghAFBqd5QCxAYwPYBMCmBRdBLAF1QCcAaPECAMzwBtMA7AQwFtMQByARg9KtQYEAysib0QXACx8BBAKoBnTAAUAHpwAMvAFYTStJg1DIApACYAQuYukl9ZATwDKjdAGFUtAK4sGIAMxmpK4AMngMmAByPgBGmMQgZgBsQQAOqAqETgwe3r4BaRlZAmER0SxxCclBdpgO2UIETMQEuT5%2BgbaY9o4Cjc0EpVGx8Ykptk0tbfmdCpOD4cMVo9UAlLaoXsTI7Bzm/uHI3lgA1Cb%2BbmLAJIQILOfYJhoAgvuHx5hnF83ETACeDyerzMBwYRy8p3ObgAbs08IYCICXm8wR8vm45sRwsAAPrQvCYADuSNeL0YPhORyYCgUJwASpglMRoZh0AAVVAAa0YJxAJzm6BAIC84QIAA4cYjkQB2KwvE4Kk5yBichioQkMUhAoGKk4AeVSymajAICEZeAUBsYWvlioNRuIJrNmQUbloGUwNueuoNQi8MQUyCxqQIVs1OrtqT9AaDeBDbo9XojCoNz2IxHVXp9qVyAizkY8LBYTHzKdSABFUAQk7aFQB6OsnNO3NiOZAnVCpeJMIjEBTJ/WpZ7odClwflvDQscG7CqVLT1IAMXdJAnU4HBoAshgF5uvLQF9Ga97FQ2ThZCISLZ9O93e/3a4OLwQr0pngxRxvUs/X5gQpgqGEBA8EAhcf2vSIqzAy9rz1Mgv3ApQ6TwYAECAkDqwQmClAADRIY9dTPEJUGAPBRFoDsu1%2Be8v2I0jyPfT9HwNOiyLESDMOY1JWPIuCCNPRtnhpFCGDYQRKLvEgHxPMshMyYBwy4uSROHJiZMHZSFLXBdNIYWd5y/XTl1QVdJx04SFO3NTs10vcD0MiyGCPbVHzPRDPmpeTRJNCTqKkhyvPcxjzMC7C/wA9DQICkT3L46KFPc5DUMizj1NTRz3Lw%2BDkVcxtC1SOEFAEXye38rjsAARy8MQFwAcUdHt4jZBBDDqhqCCalq9KqmraMZBRmtavqaUG7rqvsriOMq8b%2BPrRsAGlMD%2BQkSHQaTdXmwlgoHTahLHXaaXiVKNsJCwGs5fbCTdTzLo8QRwi8T0dqu2RfgcS7ywAj7uku7BaBA37aCUX7VB2ENLsXMRgeexdwjEWg/gh/CYYzFhLtq90Yl6x9NoASSoS7cZYdIWkJxT1LxhRLpCVgYnQEtnv/Y7FU2yDyZOtmnpxwk2eI8jLo4gWRmyinCTi7mjRpS66SYa9pcwAgtnZlnCUaLEjEutliEezXiER56AHVgPoS6DduS6AE0CVoNSBzPcpKg7KgTnSYSYnoE5HSZFl0BOIhuQYdbFQ8LxBG1aVy3OOVSWeDriYMDqoT9v4u2YNgTjZUh%2BQIQUQEyAAvTBJROSIvkeZEAFYrCrk41XwQNml9kwK8jlugTQQOOrnYhs9zn5/iTzOS7L/kSAICBe6FfuAQuDOs9Lh4Th%2BE5Vlr1BMFBzAQ3D6PdQFIUipaCf95AOJSIYCfl/WSeQFcS/0xXleo4HR1FeIBgl/TZ%2BZUjnKhIIbWDgThq2xCBAk7IuSMB3gOE%2BmJsR4gJISP2kCnIAO/upBk3tWQcgDrqf2UDZT0kZPEH2ODGBCmVKqdUH8TAR3QQOZu1cLBr3rqIYgTc25t0fB3OYG9Ug9xiCZCit4/LEChBPEBRgwHYJQZSAQcwzjJE9ggWkq8eFSnUrQ3eupFSvyVsggOat0TKIUAAOnwagsR/htEKlob/V4dDrEuWeOovhPcT7TxONyZaq1pJaJgWPAcEABx7xzlPdMA9Hy6n8VEnRCpJGkRoDIgOWjFFmEhkDTA5gzCKizpgkhyTyEgE2hkpQ0SI5jjifEgBoCkkQJSYQ7JnNsm6jycQ5khS/DFJ5gIT45TyyVKqQk6R9SCHMOyVrR6LTclEKwaMrpm1Jl9MVHYwZcThl1LIQwVJ2TDDoGmTM/JHT5lCl2h%2BOJqyQlDJqVIzZKCdlmDMNSA5hz2mkJQacratILkVKuesm5iTwFbIeU8w6LRpltLmVsz5ckjorN%2BbE/56tAWdJBTEc6BzIUFJOd0s6mAmCcn6WsnRGygX3MaY8qkNJMWzOxdC7p10aREr%2BSSgFIzgUUrMB3RwDApmPKxcc%2Blm07o8semcBF6kqnALZXchp4zKWvSYA4bJAr3kB0%2BSKt6BBxUDJZbqUlqLOVYCoC8k4qrOmfM%2Bs7HRlzEWsuRey8l8qzBYFoKa81OLNqfQojaiVUr9UyrJXKtJ3QQIvI9UKwkf0QK%2Bt1XagNDrZVjJDZk8NtLBUfO6X9MpzL42KgNfMkFG8waIkeQqCNmbNqzhLfCuNkrrmJqDcm7JNBmC0ARi0it6rumwzbQjWxfr/XVMbYa51/AxFltaemtVRSSkkB%2BXWodw7alNu2ZyqgqM01HJnQswki5UaxuJQmldo60nAExmICF06LXdIxqgLGPqdVHvzYG092Sw2Tqndum9eNrWHr1S%2BkdhbOV4GJoEydXbZ2EiJiTbVA7F1LoLRy514RTVmuvZ66DH8F3PuXbc1dIKLRocg7u3G3z/15rwyi4DzqDAVHple79mGab0aYLW3D0qgPIbSfQUtOSv1vJ/YSJmOGANUcdcG7JaptmfvLRhyNbNROUc4yemjaTpPunIiq%2BTlaekMD5mIJ9YmVP4bfY8tUfGdEkc%2BRxJT9akWqe41Jnw7qdPdtZsLdjxmkNOrSSQYjbmoNwSqba%2Bz9rHO%2BeyQValsnrPdMluR%2BDHGfOSceb8a8NKmORplteXNYXj2mbU9kvR79GOCcwwyN%2B2GjPKZS82x5mJXNZd0wkrztXX1FceQAgEsn0PNfc4SLWfw7NLpM9RpzjzCTGyyZ%2BuLm0jZ0GWTV/LgGIupbMFeU0W7yuRrNqaCjK3xNJrXc6v41t9mzcC7uq23Rfa1pZXYgcqxw6RycX/Vx3cl5eCICVGiMobGj3BY%2BYJdqPERIBHamJh2xsSfq2YMAYAytQszSxEibFaC2dG8t0bdWTtpIR%2BcSOZa4sGimj1R9WPQs446xNsw5gK5I7pSj1IVksdSqp4hmnkXHn08J52q7Qp0peVZ2zjnQ7ccgvMEkRnGbu0GiCucyng7xdc/W1L9XxOBcgFR/RMQjFRfK/9RLzl6v/BE5ySTocGUwr65C4bqVxvnXBIg1r%2B0xpBDOgtGGf1Yujeq7h89l3/Wilu8dB780rp3Q5pG5zrj3OzAACoZc7sFyz/cbO7cIZV3H9bCek%2Ba%2BD10mcc4M8x%2Bz2tuHee%2Bf8td1bry%2BkM%2B%2B4d/7vH2Sk9m/54X1Ptl08G6z37nPcPrDJ5vamEcpeDvU8H63nnlhq8W9r7pVSjf7cNorzPoII%2BcUGkLMWCfSXvMt5BQAWi3/S30/p99teh47tJp%2BO8F528z3S0YV/9%2Bb9Pk/gJH/I7l0OdM6oV%2BTea%2BhWtOpiZ%2BzOlYcGQBq%2BDmoB8edYEBf%2Ba4V%2BB%2B7Wn%2BnKDYneT%2Bf%2Bxkpk0IpewBcB42CBiBD%2BQQi%2BjkeBxAKBPusB4W8B62ZB5ufWOBIedeIktBSu7%2BIBJB62IASB7BuY1WhB9BBWfBQ%2BFwghRe3E/Uo0ohPBxBsOG%2BUIqhP%2BTOf%2B7k/4gEQgwEgE7OYhq2jBkhbgqh5BluukWhEUuhGEaBN%2BR%2BJuUh5BrBv%2B7B/4I0XU00hmQ6RBDBEhKhzhLhGh7Buk%2B%2Bvh4hyhkuHezhluXhFOb%2ByWDhzq3%2B/Glu9U%2BKHUxA8ho24RRh/hURjwMRte6RjUWRnh5OBhihfhkRjhhRjw6hsu7BiUKEaENh%2BhZeA%2B6%2BBRgI5hlBoUL414SUrReh2quRR2BGJuVc0hqe0YgYwYoYqcS6YxMOx2kubcQebBMhsxsY8YUeS2HRH%2BXRkx9RqRtemU863BiRGByRFchRLBFh1uAxuEFxBxvBNRyR0ophGxrhMhsUPcfeVxRxHxphRRXe2uHBCUYUwWlRgJxhKhnxtCXxC%2BYJOu6O0Jlxh%2B1xaSAAftMeCe5JjjkXQpDsSepM9j/PQi8JiF4EArjFgPdEkmIv9jAmEnnACrXKwFkm9g4q9tHECNSbSR%2BCaD2NkOKlYI4tHAKdqpEESP9BEGKY9tyVKScNgKgM7P4hKc4l4JkEYCXJ5oTjfCKIIIEJKOgtqdiGNl8OWDfHAkYJSS4gYEysCsyS8KkP6P9MgAIY%2BOabqQAGpiCPRsgpyfAGknywhYgIhJyF5Zx0kmjSJkB6nLAJkJIxlCmCAil5glyymLBZyqnqn%2BCFF8mPhbIQCrxqjFpbyjFm4nDGpMD7iIjckDglknD%2BneCYBBldgnCwhtmPx8jdmPQ4ipInwsCoAsgTz9mfCrx2IKmkkDhxypAJxcluDJypyckZxlwMJTE1x1wWhsIcKtzWmCKeAnAWillyKdxrwVnbyPhQ5SolYfwnwICeBrQ4hiCZHMCOAsiDxlzjkBlFxPzcn9LOJ4KYDxyNRJwEDBlpyfBsgbk3lbnMI7kNzsJnCcLWmwXqKKJJAnDAAKxnmYXlmbzXmaKygsqeRHQTxEazywUPBnnPbWInBnjak3gMD9rhB%2ByMgEBBxxL3k3y4UNnLk0UFm/ltk4gAUA6PZ/zRIIUsK7mNyoUHktl/kdmfCYVS5dl/n4XyLaqEUloMKkV2q8UTmDmAX3Z/z8KTiNRenqStmBnBkaWiX0Kal/yignDFjhClnQKPi8UaBOXlgcDrC0CcAVy8B%2BAcBaCkCoCcBfFWCWCjxbA7CKL%2BA8CkAECaABXrCcggAVwaD6CcCSChXpWRWcC8AKAgC5VpXhUBWkBwCwAwCIAoCoDEyLZkAUAQBoDNX0AJBUhGBSAaC5VYD4g7C%2BmIJhicApU0C0CZFlUQAxBFUxBwx6xFUdViShisV/BFVYDFhGDiBVWkD4COj1AshlV7Ubx1Dfa7ARWijdBFX/TorNB/AeBYBFU1IsDjXVVUAGDAAKAjVEhjXcC8D8CCAiBiDsBSAyCCCKAqDqB7W6BBAGBGAoDD6WD6B4ABjwDrCdi9CBycDH56j%2BAnDH7H4CiE6mBz6WBmARW1D1DOAQCuDTB%2BBcDBAfhDAOyjBM2uzFA5CeDtB6Cc3Y2s3Cx6DU3Y39BTA835BM0i0NDzCC1JnC3zAM0K0DBy2VASDrBFQJVg2BXBWFV7VRUcAnCqBihJDH5JCSCUgI3AAnBSCmIaB20nAQC4CEDzr7BcCrC8CVVaCrCZXZW5VBUcAFWkBvU5WkBhURUG2lXlWpXpXrC1UNWbAEBunVhtUdWpAtWRCcmcDG2m3m2W2GDW22320RWsgu1YiChM1A3CDkRg3SBV1Q1qBFVw2kCEi/CpDvU60cAhVh1FUG16jfbJ1OxG0m1m0W09WF2SB20O0QD5QtVJVmAe0x1VU%2B2kBmhMBYAJCll5WB28Ah25Xh28CR22DR1e0ZWkBZWh0B3%2BB60R0lVL3e2d1mA32H132n0r0sh9jZAgCSBAA)

- [Improving my C++ time queue](https://schneide.blog/2022/11/10/improving-my-c-time-queue/)

代码重构。没啥说的

- [ODR violation detection ](https://maskray.me/blog/2022-11-13-odr-violation-detection)

介绍 ODR相关的检测，很长

- [C++ constexpr parlor tricks: How can I obtain the length of a string at compile time?](https://devblogs.microsoft.com/oldnewthing/20221114-00/?p=107393)

编译期的字符串，怎么编译期查长度？strlen不是constexpr,不行

```cpp
#include <string>

constexpr std::size_t constexpr_strlen(const char* s)
{
    return std::char_traits<char>::length(s);
    // return std::string::traits_type::length(s);
}

constexpr std::size_t constexpr_wcslen(const wchar_t* s)
{
    return std::char_traits<wchar_t>::length(s);
    //  return std::wstring::traits_type::length(s);
}

```

- [C++20 Coroutines and io_uring - Part 1/3](https://pabloariasal.github.io/2022/11/12/couring-1/)
  
  手把手教你封装IOUring

- [Exploring Clangs Enum implementation and How we Catch Undefined Behavior](https://shafik.github.io/c++/2022/11/15/exploring-clang-enum-impl-and-ub-part-2.html)
  
  enum是有范围的，所以
```cpp
  enum E1 {e1=0};             // Range of values [0,1]

void f() {
  E1 x = static_cast<E1>(2); // undefined behavior, 2 is outside the range of values
}

```
这种是UB，UBSan能抓到，也可以用 `-fstrict-enums`来抓

- [PL Pragmatics #1 ](https://plpragmatics.substack.com/p/pl-pragmatics-1)

介绍了一些语言相关的优化/论文/点子，比如GC/JIT之类的，jdk/python相关的进展，感兴趣的可以看看
## 视频

这周没看。有啥推荐的也可以发一下。CPPCON 2022新出了俩协程教程，没看
- [Understanding C++ Coroutines by Example: Generators (Part 2 of 2) - Pavel Novikov - CppCon 2022](https://www.youtube.com/watch?v=lz3F036_OvU)

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [cparse](https://github.com/jafarlihi/cparse)  LR(1) parser generator

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/089.html)
