---
layout: post
title:  第88期
---
# C++ 中文周刊 第88期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



欢迎投稿，推荐或自荐文章/软件/资源等

可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/21)


---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-01-05 第131期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-01-05.md)

boost  1.81 beta发布 https://boostorg.jfrog.io/artifactory/main/beta/1.81.0.beta1/source

有Boost.URL，也有boost.unordered_flat_map，尝鲜可以试试

## 文章

- [一个极简的 C++ 静态反射 demo](https://zhuanlan.zhihu.com/p/581995472)

手把手写反射，可以这里 https://godbolt.org/z/qsqe3aW6b 体验一下，还是很有意思的

- [Bit-vector manipulations in standard C++](https://quuxplusone.github.io/blog/2022/11/05/bit-vectors/)

各种bit strings比较(`vector<bool>`, `bitset<N>`,`boostd::dynamic_bitset`)  谁find更快，结论libc++(llvm)有优化，libstdcxx(gcc)没有

- [Eraser: A Dynamic Data Race Detector for Multithreaded Programs](https://zhuanlan.zhihu.com/p/94858087)

有意思

- [Undefined Isn’t Unpredictable](http://www.os2museum.com/wp/undefined-isnt-unpredictable/)
  
简单说，就是未定义行为都是代码屎山，所以可以根据屎的最初形态来找一些蛛丝马迹。。。

- [C Isn't A Programming Language Anymore](https://faultlore.com/blah/c-isnt-a-language/)

c语言过于底层，已经成为 协议/接口的一部分了 。后来的语言都要缝缝补补c

- [Performance Musings](https://blog.broulik.de/2022/11/performance-musings/)

perf分析 。qt相关。不太懂

- [Three new utility functions in C++23](https://mariusbancila.ro/blog/2022/11/08/three-new-utility-functions-in-cpp23/)

`std::unreachable();`一看就懂
 
`std::to_underlying` 是这玩意
```cpp
template <typename Enum>
constexpr auto to_underlying(Enum e) noexcept
{
    return static_cast<std::underlying_type_t<Enum>>(e);
}
``` 

`std::byteswap` 看这个例子

```cpp
template <std::integral T>
void print_hex(T v)
{
   for (std::size_t i = 0; i < sizeof(T); ++i, v >>= 8)
   {
      std::cout << std::format("{:02X} ", static_cast<unsigned>(T(0xFF) & v));
   }
   std::cout << '\n';
}
int main()
{
   unsigned char a = 0xBA;
   print_hex(a);                    // BA
   print_hex(std::byteswap(a));     // BA
   unsigned short b = 0xBAAD;
   print_hex(b);                    // AD BA
   print_hex(std::byteswap(b));     // BA AD
   int c = 0xBAADF00D;
   print_hex(c);                    // 0D F0 AD BA
   print_hex(std::byteswap(c));     // BA AD F0 0D
   long long d = 0xBAADF00DBAADC0FE;
   print_hex(d);                    // FE C0 AD BA 0D F0 AD BA
   print_hex(std::byteswap(d));     // BA AD F0 0D BA AD C0 FE
}
```
- [lld linked musl on PowerPC64 ](https://maskray.me/blog/2022-11-05-lld-musl-powerpc64)

看不懂

- [Did you about typename erasure technique to reduce compilation times with templates? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/303.md)

简单来说，就是使用继承T，把T本身多余的信息吃掉。花哨。看个乐

```cpp
template<auto...> struct long_type {};

//生成类型long_type<0,1,2,3...41>
using long_type_t = decltype(
    []<auto... Ns>(std::index_sequence<Ns...>) {
        return long_type<Ns...>{};
    }
    (std::make_index_sequence<42>{})
);

// typename erasure
// 通过继承直接吃掉long_type_t的类型
struct short_type_t : long_type_t{};

// generic typename erasure
// 泛型版本的继承，吃掉类型。这个T得有默认构造，不然编译不过
template<class T> using typename_erasure = decltype([] {
    struct s : T { using T::T; }; // generated in the compiler as `$0::s` or similar
    return s{};
}());

int main() {
    assert(std::string_view{typeid(long_type_t).name()}.size() > 100); // 长类型
    assert(std::string_view{typeid(short_type_t).name()}.size() < 15); // 短类型
    assert(std::string_view{typeid(typename_erasure<long_type_t>).name()}.size() < 25); // 短类型
}
```

- [Overview of C++ Variable Initialization](https://www.caichinger.com/cpp/initialization.html)

茴香豆的茴有几种写法？

- [圆周率里包含你的银行卡密码吗？](https://www.zhihu.com/question/23419402/answer/2751974117)

这个和c++没啥关系，但是非常有意思
## 视频

- [C++ Weekly - Ep 349 - C++23's move_only_function](https://www.youtube.com/watch?v=OJtGOJI0JEw)

没啥说的

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

-  [gdbpmp](https://github.com/markhpc/gdbpmp)用gdb来profile的脚本，感觉和perf差不多
-  [ctp](https://pypi.org/project/compile-time-printer/#how-it-works) 编译期打印
-  [Ichor](https://github.com/volt-software/Ichor/tree/v0.1.0) c++20依赖注入框架。测试mock使用。有点复杂
  

## 工作招聘

美帝的公司也裁员啊。大环境真就都不好

是否被裁，就看这俩月！虽然我划水，但别裁俺

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/088.html)
