---
layout: post
title:  第87期
---
# C++ 中文周刊 第87期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-weekly-Blogroll-353.html)/知乎/等等摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/20)

2022 1104

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-11-02 第174期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-11-02.md)


## 文章

- [Windows开发者套件2023详细测评](https://zhuanlan.zhihu.com/p/580147966)

这个机器我想整一个跑arm linux，但是貌似兼容性不太行啊，适配啥的没人做吧。先观望观望。

貌似可以多装一个固态，也就是说可以玩双系统，一个linux一个windows，还是很爽的。就看适配了。目前生态一般

- [C++怎么获取类对象所占内存空间的大小？](https://www.zhihu.com/question/564240936/answer/2741765440)

很秀，可以看这个PPT  https://raw.githubusercontent.com/alibaba/yalantinglibs/main/src/struct_pack/doc/struct_pack_introduce_CN.pdf

学习一下

- [这下可以安心使用 dynamic_cast 了：dynamic_cast 的实现方法分析以及性能优化](https://zhuanlan.zhihu.com/p/580330672)

值得一看

- [The pool of talented C++ developers is running dry](https://www.efinancialcareers.co.uk/news/2022/11/why-is-there-a-drought-in-the-talent-pool-for-c-developers)

哎，确实，做c++的程序员越来越少

- [静态分析优化代码分支性能](https://zhuanlan.zhihu.com/p/578791924)

涨涨见识

- [Lock-Free 班门弄斧(Hazard Pointer)](https://zhuanlan.zhihu.com/p/576073971)
  
看个乐

- [C++ 一个偶现的内存破坏](https://zhuanlan.zhihu.com/p/578290634)

老生常谈的`string.data()`生命周期问题

-  [记一次CLOSE_WAIT引发的血案](https://zhuanlan.zhihu.com/p/578699402)

连接有增有降但是 socket却一直上涨？  忘记close？

```bash
ss -tna|grep $PORT|grep CLOSE
```

当然配置SO_KEEPALIVE就可以了

```c
int val = 600; 
if (setsockopt(client_fd, IPPROTO_TCP, TCP_KEEPIDLE, &val, sizeof(val)) < 0) { ... }     
val = 5; 
if (setsockopt(cliend_fd, IPPROTO_TCP, TCP_KEEPINTVL, &val, sizeof(val)) < 0) { ... }     
val = 3; 
if (setsockopt(, IPPROTO_TCP, TCP_KEEPCNT, &val, sizeof(val)) < 0) { ... }

```
- [Did you now that with concepts you can override a type? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/302.md)

```cpp
template<auto N> struct foo  {
  static constexpr auto value = N;
};
static_assert(42 == foo<42>::value);

template<auto N>
  requires true // override -> more specialized
struct foo<N> {
  static constexpr auto value = 0;
};
static_assert(42 == foo<42>::value); // memoized
static_assert(0 == foo<43>::value);
```

更简单的特化，可以玩一些骚的，比如，特化`shared_ptr<int>`,让它退化成local模式，（不要线程安全, `boost::local_shared_ptr`）

```cpp
namespace std {
template <class T>
    requires std::is_integral_v<T>
class shared_ptr<T> : public __shared_ptr<int, __gnu_cxx::_S_single> {};
}  // namespace std
```
这里只是秀一下，除了std::hash很少见特化标准库的场景

- [Bringing a dynamic environment to C: My linker project](https://macoy.me/blog/programming/LinkerLoaderIntro)
  
  写linker从哪里开始做起？

-  [Lifetime extension of temporary objects in C++: common recommendations and pitfalls](https://pvs-studio.com/en/blog/posts/cpp/1006/)

老生常谈的问题, 不要`return std::move(x)`
-  [The evolution of statements with initializers in C++ - part 2]()

- [Increasing Security: Fuzz Testing C++](https://www.meetingcpp.com/blog/items/Increasing-Security--Fuzz-Testing-Cpp.html)

ASan TSan UBSan  Msan

## 视频 cppcon

ppt已经放出来一部分了 https://github.com/CppCon/CppCon2022


- [Taking a Byte Out of C++ - Avoiding Punning by Starting Lifetimes - Robert Leahy - CppCon 2022](https://www.youtube.com/watch?v=pbkQG09grFw)

这个哥们有点壮啊，虽然说出来有点怪怪的
![](https://user-images.githubusercontent.com/8872493/199238870-0d646635-e437-4eaf-8535-54c8baa82e24.png)

讲生命周期的，具体看这个  https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/p2590r2.pdf

案例讲的非常不错，适合观看。


- [Fix for High Risk OpenSSL Security Vulnerabilities Announced – Guidance for vcpkg Users](https://devblogs.microsoft.com/cppblog/fix-for-high-risk-openssl-security-vulnerabilities-announced-guidance-for-vcpkg-users/)

用vcpkg的注意更新一下vcpkg，老版本用的openssl可能有安全问题
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- boost 1.81的`boost::unordered_flat_map`效果不错
- [yalantinglibs](https://github.com/alibaba/yalantinglibs) 祁宇又在秀
- [pptest](https://github.com/Defalt8/pptest) 一个测试框架
- [cpp-effects](https://github.com/maciejpirog/cpp-effects) 一个调度库
- [spdlog 1.11](https://github.com/gabime/spdlog/releases/tag/v1.11.0) bugfix
## 工作招聘

部门又开始裁员了卧槽，这波估计我要危险。。

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/087.html)
