---
layout: post
title:  第86期
---
# C++ 中文周刊 第86期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-weekly-Blogroll-352.html)/[purecpp](http://www.purecpp.cn/)/知乎/等等摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)


公众号也有了

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/19)

2022 10 29

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 2022-10-26 第173期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-10-26.md)

2022 purecpp大会ppt和视频 

http://www.purecpp.cn/detail?id=2322
## 文章

- [Improving Copy and Move Elision](https://devblogs.microsoft.com/cppblog/improving-copy-and-move-elision/)

介绍MSVC在copy elision move elision 的改进

- [Did you now that functions in are constexpr since C++23?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/301.md)

```cpp
consteval auto to_number(auto str) {
    int value;{} 
    std::from_chars(std::cbegin(str), std::cend(str), value);
    return value;
}
static_assert(42 == to_number(std::string_view{"42"}));
```

- [C/C++ Debugging Tools](https://www.kdab.com/c-cpp-debugging-tools/)

调试工具。老生常谈了

- [Stranger Strings: An exploitable flaw in SQLite](https://blog.trailofbits.com/2022/10/25/sqlite-vulnerability-july-2022-library-api/)

简单说，这个就是sqlite里的printf遇到%Q %q %w且字符串 非常非常非常大，才会触发这个CVE。且sqlite本身不会触发

sqlite不是100%分支覆盖么，为啥还有问题？分支覆盖了并不代表没问题。fuzzer也有可能覆盖不到这种非常非常大的数据的场景

另外牛逼一点的静态分析工具也能查到，但是基本上就是个告警，但没人用/当回事

使用字符串 format %一定要注意。这种坑不是一两个了。苹果wifi那个CVE也是%惹的祸

- [The evolution of statements with initializers in C++](https://www.sandordargo.com/blog/2022/10/26/statements-with-initializers-part-1-conditionals)

if-switch里可以定义了。这样省一行。比如

```cpp
switch (Foo foo; foo.getValue()) {
    case 1: //...
            break;
    case 2: //...
            break;
    case 3: //...
            break;
    default:
            //...
            break;
}
...
if (int val = getValue(); val<10) {
    std::cout << "val smaller than 10: " << val << '\n';
} else if (val < 5) {
    std::cout << "val smaller than 5: " << val << '\n';
} else {
    std::cout << "val is bigger than 10: " << val << '\n';
} 

```

c++17就可以了。

- [What happens if my C++ exception handler itself raises an exception?](https://devblogs.microsoft.com/oldnewthing/20221021-00/?p=107307)

```cpp
try
{
    Block1;
}
catch (Type1 ex1)
{
    Block2;
}
catch (Type2 const& ex2)
{
    Block3;
}
```

作者说了一个场景

Block1里有两个栈对象，第一个析构的时候抛异常，被catch了。第二个也跑异常，此时已经catch过了，所以直接std::terminate

c++是没有finally收尾+析构这种模式的，上面这种场景要 如何规避？

- [Debugging C With Cosmopolitan Libc](https://ahgamut.github.io/2022/10/23/debugging-c-with-cosmo/)
  
  介绍一个调试库

- [Chimp：一种针对浮点值时序数据的无损压缩思路](https://zhuanlan.zhihu.com/p/566652089)

流式压缩，效果比facebook哪个gorila还好，挺有意思
## 视频

- [C++ Weekly - Ep 347 - This PlayStation Jailbreak NEVER SHOULD HAVE HAPPENED](https://www.youtube.com/watch?v=rWCvk4KZuV4)

整数溢出导致。。。`-Wno-error=deprecated` `-Wsign-conversion` `-Wconversion` 你总得用一个吧

### CPPCON

- [C++23 - What's In It For You? - Marc Gregoire - CppCon 2022](https://www.youtube.com/watch?v=b0NkuoUkv0M)

介绍 c++23 的。没啥说的

- [Deciphering C++ Coroutines - A Diagrammatic Coroutine Cheat Sheet - Andreas Weis - CppCon 2022](https://www.youtube.com/watch?v=J7fYddslH0Q)

协程上手，很长

-  [Back to Basics: Templates in C++ - Nicolai Josuttis - CppCon 2022](https://www.youtube.com/watch?v=HqsEHG0QJXU)

没啥说的

- [Back to Basics: Debugging in C++ - Mike Shah - CppCon 2022](https://www.youtube.com/watch?v=YzIBwqWC6EM)

这个有手把手调代码演示，可以看看

- [Functional Composable Operations with Unix-Style Pipes in C++ - Ankur Satle - CppCon 2022](https://www.youtube.com/watch?v=L_bomNazb8M)

代码在这里 https://github.com/sankurm/generic-pipeline

贴一下代码 

```cpp
#include <string>
#include <iostream>
#include <exception>
#include <type_traits>
#include <functional>
#include <fstream>

//The generic implementation also takes care of the return type of Callable being different than T
template<typename T, typename Callable>
auto operator|(T&& val, Callable&& fn) -> typename std::result_of<Callable(T)>::type {
    return std::forward<Callable>(fn)(std::forward<T>(val));
}

//Pre-C++17 code without std::optional
//Code relies on special values like empty string, kafka_config to be convertible to bool and return bools to determine success of a step
namespace
{
    struct env_error : public std::exception {};
    struct file_error : public std::exception {};
    struct json_error : public std::exception {};
    struct creation_error : public std::exception {};
    struct connect_error : public std::exception {};
    struct subscribe_error : public std::exception {};

    std::string get_env(std::string&& varname) {
        if (/* varname not set OR value is empty */false) { throw env_error{}; }
        return "/config/kafka.json";
    }

    std::string get_file_contents(std::string&& filename) {
        std::ifstream file(filename, std::ios::in);
        if (!file && false) { throw file_error{}; }
        return "file-contents-blah-blah";
    }

    struct kafka_config
    {
        /* url etc. */
        operator bool() { return true; }
    };

    enum config_type { json, xml, yaml, config_map };

    template<config_type format>
    kafka_config parse_kafka_config(std::string&& config) {
        if (/* parsing fails == */ false) { throw json_error{}; }
        return kafka_config{};
    }

    struct kafka_consumer
    {
        kafka_consumer(const kafka_config& config) {}
        kafka_consumer(kafka_config&& config) {}

        bool connect() { return true; }
        bool subscribe() { return true; }

        operator bool() { return true; }
    };

    kafka_consumer create_kafka_consumer(kafka_config&& config) {
        return kafka_consumer{std::move(config)};
    }

    kafka_consumer connect(kafka_consumer&& consumer) {
        if (!consumer.connect()) { throw connect_error{}; }
        return consumer;
    }

    auto subscribe = [](kafka_consumer&& consumer) {
        if (!consumer) { throw subscribe_error{}; }
        consumer.subscribe();
        return consumer;
    };

    //Invoking an operation taking more than 1 argument
    //std::bind solution
    kafka_consumer init_kafka() {
        //using namespace std::string_literals;
        //Can use "kafka-config-filename"s as they need C++14
        return std::string("kafka-config-filename")
                | get_env
                | get_file_contents
                | parse_kafka_config<xml>
                | create_kafka_consumer
                | connect
                | subscribe;
    }
}

int main(int argc, char** argv) {
    auto consumer = init_kafka();
    if (consumer) { std::cout << "Consumer creation successful\n"; }
    else { std::cout << "Consumer creation failed\n"; }

    return 0;
}
```

看个乐。没有scheduler的pipeline操作没啥意义，除了语法糖让自己爽一爽，没别的用处
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [tiny-optional](https://github.com/Sedeniono/tiny-optional) 一个optional库
- [libcfg-cpp](https://github.com/mystere1337/libcfg-cpp) 一个配置库
- [sclui](https://github.com/0x3alex/sclui)  一个 终端库
- [cheap (C++ HTML Element Apparator) ](https://github.com/s9w/cheap) 
  生成html的，比如
  ```cpp
  const std::string elem_str = get_element_str(div(span("first"), img("src=test.jpg"_att)));
  ```
  生成
  ```html
  <div>
    <span>first</span>
    <img src="test.jpg" />
  </div>
  ```

## 工作招聘

不被开除就不错了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/086.html)
