---
layout: post
title:  第82期
---
# C++ 中文周刊 第82期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-weekly-Blogroll-348.html)/[purecpp](http://www.purecpp.cn/)/知乎/等等摘抄一些c++动态



[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等



可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/15)

2022 1002

大家国庆快乐

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-09-28 第169期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-09-28.md)


## 文章

- [AMD Zen 4 微架构深入测试报告](https://zhuanlan.zhihu.com/p/568419115)

除了贵和积热之外没啥缺点。zen4太贵了。本来打算双十一拼一台。看样子只能考虑明年618再拼了。

今年可以双十一攒个5950x，加b550不到四千。内存也便宜


- [Did you know that C++23 added static operator()?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/tips/298.md)



```cpp
struct s {
  static constexpr auto operator()() { return 1; }
};
auto l = [] static { return 2; };

static_assert(3 == s{}() + l());

static_assert(3 == s::operator()() +
         decltype(l)::operator()());
```

没啥说的。补全一下

- [5 Ways to Improve or Avoid Loops in C++20...23 ](https://www.cppstories.com/2022/improve-loops-cpp2b/)

有了ssize支持，可以不考虑符号了，

```cpp
for (int i = 0; i < ssize(vec); ++i)
    std::cout << i << ": " << vec[i] << '\n';

```
range遍历 + 索引

```cpp
int main() {
    std::vector vec { 1, 2, 3, 4, 5};
    for (int i = 0; const auto& elem : vec)
        std::cout << i++ << ": " << elem << '\n';
}

```
说实话有点别扭，没有go那种 `i, v = range`那种感觉好, 聊胜于无吧

组合view

```cpp
#include <iostream>
#include <vector>
#include <ranges>

int main() {
    std::vector vec { 1, 2, 3, 4, 5};
    for (int i = 0; const auto& elem : vec | std::views::reverse)
        std::cout << i++ << ": " << elem << '\n';
}

```

使用range view算法

```cpp
void printReverse(auto cont) {
    std::ranges::for_each(cont | std::views::reverse, 
        [i=0](const auto& elem) mutable {
            std::cout << i++ << ' ' << elem << '\n';
        }
    );
}

```

- [Layering check with Clang ](https://zhuanlan.zhihu.com/p/568130072)

看不懂

- [CUDA 编程入门之统一内存](https://zhuanlan.zhihu.com/p/567915643)

科普一下

- [C++ 20 协程总结](https://zhuanlan.zhihu.com/p/569480618)

还是科普

- [C++ Hashmap Benchmark](https://zhuanlan.zhihu.com/p/569618538)

这个其实就是之前那个英语博客的转述

- [Something I implemented today: “is void”](https://herbsutter.com/2022/09/25/something-i-implemented-today-is-void/)

草药老师关于他cppfront语法的一些需求的实现。没细看

- [Text formatting in C++ using libc++](https://blog.llvm.org/posts/2022-08-14-libc++-format/)

介绍format以及llvm的支持程度。基本都支持除了chrono

- [Optimizing compilers deduplicate strings and arrays](https://lemire.me/blog/2022/09/23/optimizing-compilers-deduplicate-strings-and-arrays/)


- [Optimizing compilers deduplicate strings and arrays](https://lemire.me/blog/2022/09/23/optimizing-compilers-deduplicate-strings-and-arrays/)

内联场景的前缀字符串前缀数组可能会被编译器优化掉，减少二进制大小

比如

```cpp
    const char * str1 = "dear friend";
    const char * str2 = "dear friend";
    return str1 == str2;
```

- [What does the C++ error `A pointer to a bound function may only be used to call the function` mean?](https://devblogs.microsoft.com/oldnewthing/20220926-00/?p=107212)

```cpp
void oops(std::vector<std::string>& v)
{
    set_name(v.front.c_str());
    //         ^^^^^ error: A pointer to a bound function
    //         may only be used to call the function
}
```

忘记加括号了


- [the sad state of debug performance in c++](https://vittorioromeo.info/index/blog/debug_performance_cpp.html)

有些功能比如move迭代器之类的存在用不好的场景。导致莫名其妙的影响性能。


## 视频

- [C++ Weekly Digging Into Type Erasure](https://www.youtube.com/watch?v=iMzEUdacznQ)

类型擦除的方法。之前也讲过. 就是藏函数指针

```cpp
class animal_view {
 public:
  template <typename Speakable>
  explicit animal_view(const Speakable &speakable)
      : object{&speakable},
        speak_impl{// create a lambda that knows how to unpack the stored object
                   [](const void *obj) {
                     return static_cast<const Speakable *>(obj)->speak();
                   }} {}

  void speak() const { speak_impl(object); }

 private:
  // void * to object of unknown type
  const void *object;

  // function pointer that knows how to use unknown type
  void (*speak_impl)(const void *);
};

void do_animal_things(animal_view animal) { animal.speak(); }

int main() {
  struct Cow {
    void speak() const { fmt::print("Mooo\n"); }
  };

  struct Sheep {
    void speak() const { fmt::print("Baaa\n"); }
  };
  do_animal_things(animal_view{Cow{}});
  do_animal_things(animal_view{Sheep{}});
}
```

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [cppq](https://github.com/jafarlihi/cppq) 一个基于redis的任务队列


---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/082.html)
