---
layout: post
title:  第81期
---
# C++ 中文周刊 第81期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-weekly-Blogroll-347.html)/知乎等等摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/14)

2022 09 23

马上就国庆节了。节前节后这两周大概率没时间更新了。提前祝大家节日快乐。好好休息

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

九月讨论汇总 https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-09

[polymorphic_allocator<> instead of type-erasure](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/p0987r1.pdf)

这个有点意思，众所周知，std::function用malloc，不能指定allocator，挺坑。如果std::function创建多了。malloc倒是成为瓶颈了。坑。
主要是加个 `using allocator_type = std::pmr::polymorphic_allocator<>;`

[function_ref: a type-erased callable reference](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/p0792r11.html)

这个讨论好久了。

[Proxy: A Polymorphic Programming Library](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/p0957r9.pdf)

这个也介绍过，是微软搞的类似folly::poly那种用户态的多态实现。

别的没啥说的。修修补补

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-09-21 第168期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-09-21.md)

另外还有Azure CTO说c++不行了新项目转rust。c++老大说他喜新厌旧。具体大家搜一搜就好了。不贴出来了。有点八卦

问题在这里 https://www.zhihu.com/question/554750609

## 文章

- [DSA之TLSF内存分配器源码分析](https://zhuanlan.zhihu.com/p/565768503)

这个分配器确实不错。差点项目里就用了。后来研究了一下发现checkpoint麻烦就放弃了。这个设计还是很有意思的

- [GCC's new fortification level: The gains and costs](https://developers.redhat.com/articles/2022/09/17/gccs-new-fortification-level#)

介绍防守编程的，_FORTIFY_SOURCE=3新级别，更严格，能抓到buffer overflow

- [Reducing Signed and Unsigned Mismatches with std::ssize() ](https://www.cppstories.com/2022/ssize-cpp20/)

被符号不匹配告警搞烦了

```cpp
template <typename T>
bool has_repeated_values(const T& container) {
  for (int i = 0; i < container.size() - 1; ++i) {
    if (container[i] == container[i + 1]) return true;
  }
  return false;
}
// 修改后

std::vector vec = ...
if (!empty(vec)) {
    for (int i = 1; i < ssize(vec); ...) {
        ...
    }
}

```
内部帮你`static_cast`。快谢谢库作者

- [C++中Crash定位原理与常见案例反汇编分析](https://zhuanlan.zhihu.com/p/412102389)

看看见识见识

- [Can I Use a System Call?](https://justine.lol/cosmopolitan/functions.html)

介绍各个平台系统api兼容性

- [Microsoft C++ Code Analysis Warnings with Key Events](https://devblogs.microsoft.com/cppblog/microsoft-cpp-code-analysis-warnings-with-key-events/)

介绍msvc告警的。没啥说的

- [Why load fs:[0x18] into a register and then dereference that, instead of just going for fs:[n] directly?](https://devblogs.microsoft.com/oldnewthing/20220919-00/?p=107195)

不太懂windows下的汇编表现

- [Serializing asynchronous operations in C++/WinRT, gotchas and final assembly](https://devblogs.microsoft.com/oldnewthing/20220916-00/?p=107191)

看不太懂
## 视频

- [Can C++ be 10x Simpler & Safer? - Herb Sutter - CppCon 2022](https://www.youtube.com/watch?v=ELeZAKCN4tY)

介绍[cppfront](https://github.com/hsutter/cppfront) herb大哥整的新活， cpp2。看个乐

这里有个介绍 https://www.zhihu.com/question/536288519/answer/2682665038

- [C++ Weekly - Ep 342 - C++20's Ranges: A Quick Start](https://www.youtube.com/watch?v=sZy9XcGHmI4)

介绍range。没啥说的

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [lager](https://github.com/arximboldi/lager) 一个UI框架，类似redux
## 工作招聘

哎。虾皮突发变动搞的人心惶惶啊。

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/081.html)
