---
layout: post
title:  第79期
---
# C++ 中文周刊 第79期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[purecpp](http://www.purecpp.cn/)知乎等等摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/11)

2022 0908 提前发了。周五有事
---

## 资讯

标准委员会动态/ide/编译器信息放在这里

llvm 15发布了。c++20支持等等一大堆修改

[lld 15 ELF changes ](https://maskray.me/blog/2022-09-05-lld-15-elf-changes)

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2022-09-07 第166期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-09-07.md)


## 文章

- [最新全面hashmap 评测](https://martin.ankerl.com/2022/08/27/hashmap-bench-01/)，其中emhash7/8 是[知乎网友](https://www.zhihu.com/people/ktrpime) 实现的的，性能排名还不错。感兴趣的可以研究下

- [使用协程需要注意的问题（一） ](http://www.purecpp.cn/detail?id=2313)

要注意协程被线程切换影响

- [C++23特性总结 - 上](https://zhuanlan.zhihu.com/p/562383157)
- [C++23特性总结 - 下](https://zhuanlan.zhihu.com/p/562383556)

c++23详细总结

- [使用 C++ 20 协程封装 RDMA 操作](https://zhuanlan.zhihu.com/p/553140760)
- [使用 C++ 20 协程封装 UCX](https://zhuanlan.zhihu.com/p/555971343)

c++20应用协程举例

- [STL源码分析之std::function](https://zhuanlan.zhihu.com/p/560964284)
- [g++8.3，sizeof(std::function)为什么等于32](https://www.zhihu.com/question/530797704/answer/2658642917)

std::function的分析

- [用户态操作系统之四 Seastar的init函数与stop](https://zhuanlan.zhihu.com/p/561202708)
- [用户态操作系统之五 Seastar的timer](https://zhuanlan.zhihu.com/p/561214124)
- [用户态操作系统之六 Seastar的跨线程通信](https://zhuanlan.zhihu.com/p/561511141)

seastar的一些代码走读。可以看看

- [C++-模板-萃取的实现(三)](https://www.zhihu.com/column/c_1523802493980569601)

其实就是编译期检测接口的能力

- [C++ 20 协程 Coroutine（1，基础）](https://zhuanlan.zhihu.com/p/561623494)
- [C++ 20 协程 Coroutine（2，等待体）](https://zhuanlan.zhihu.com/p/561864514)
- [C++ 20 协程 Coroutine（3，剖析）](https://zhuanlan.zhihu.com/p/561884301)

一组协程教程

- [Did you know that with C++20 (constexpr containers) TMP can be achieved with STL ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```cpp
#include <ranges>

template <auto Begin, auto End, auto List>
auto slice = List
           | std::ranges::views::drop(Begin)
           | std::ranges::views::take(End);

static_assert(
  slice<1_c, 2_c, boost::mp::list<int, double, float>()>
  ==
                  boost::mp::list<double, float>());
```

typelist实现更简单了。恐怖

- [A moved from optional](https://akrzemi1.wordpress.com/2022/09/06/a-moved-from-optional/)

optinal的move并不会真正的move T, 让T为无效value

```cpp
template <typename T>
void test(T v)
{
  optional<T> o = v;
  assert (o);     // o contains a value
  optional<T> p = std::move(o);
  assert (o);     // o still contains a value!
}
```
完全取决于T的move，optional会保留T的壳子。

比如unique_ptr

```cpp
int * p = new int(1);
 
optional<unique_ptr<int>> op = unique_ptr<int>(p);
assert (op);
assert (op->get() == p);
 
optional<unique_ptr<int>> o2 = std::move(op);
assert (op);                   // still contains a value
assert (op->get() == nullptr); // the value is moved from
assert (o2);
assert (o2->get() == p);
```

unique_ptr内部会搬走，但本身是还在optional里的。这样实现更快，对于trival类型，这样优化的可以直接memcpy，更高效一些
大概实现成这个样子

```cpp
template <typename Trivial>
class optional<Trivial>
{
  bool     _is_initialized;
  Trivial  _value;
 
  optional() : _is_initialized(false) {}
  // use defaulted copy and move 
};
```

- [Using std::unique_ptr With C APIs](https://eklitzke.org/use-unique-ptr-with-c-apis)

```cpp
// Second argument is a pointer to the type of std::fclose, we could also have
// written it out explicitly as std::unique_ptr<FILE, int (*)(FILE*)>.
using FilePtr = std::unique_ptr<FILE, decltype(std::fclose) *>;

// Instantiate the FILE* with the destructor we want.
FilePtr file(std::fopen(filename, "rbe"), std::fclose);

// Do stuff with the file
std::fread(buf_.data(), 1, buf_.size(), file.get());
```

比写个deferGuard能更干净些

```cpp
using XXH3StatePtr = std::unique_ptr<XXH3_state_t, decltype(XX3_freeState) *>;
XXH3StatePtr state(XXH3_createState(), XXh3_freeState);
```
但这种写法的问题在于，需要判定创建失败/指针是否有效


- [C++23’s new function syntax](https://www.elbeno.com/blog/?p=1696)

一个简单的函数

```cpp
[[nodiscard]] auto say_a_to(
    std::string_view what, std::string_view name) -> std::string {
  return std::string{what} + ", " + std::string{name} + "!";
}

say_a_to("Hi", "Kate"); // -> "Hi, Kate!"

struct {
  [[nodiscard]] auto operator()(
      std::string_view what, std::string_view name) const -> std::string {
    return std::string{what} + ", " + std::string{name} + "!";
  }
} say_b_to;

say_b_to("Hello", "Tony"); // -> "Hello, Tony!"
```

没啥新奇的，但是c++23支持多维数组了，所以说`operator[]` 也算是一种函数了

比如
```cpp


struct {
  [[nodiscard]] auto operator[](
      std::string_view what, std::string_view name) const -> std::string {
    return std::string{what} + ", " + std::string{name} + "!";
  }
} say_d_to;

say_d_to["Goodbye", "Tony"]; // -> "Goodbye, Tony!"
```

```cpp
struct {
  template <std::integral ...Ts>
  [[nodiscard]] auto operator[](Ts... ts) const noexcept {
    return (0 + ... + ts);
  }
} sum;
const auto s1 = sum[1, 2, 3]; // 6
const auto s2 = sum[];        // 0
```

我只能说看个乐，别这么写求求了
## 视频

- [C++ Weekly - Ep 340 - Finally! A Simple String Split in C++! ](https://www.youtube.com/watch?v=V14xGZAyVKI)

```cpp
#include <iostream>
#include <ranges>
#include <string_view>

int main() {

  // this is lazily evaluated
  auto strings = std::string_view{"Hello C++ 20"} | std::views::split(' ');

  // the result is a range of ranges
  
  for (const auto &ref : strings) {
    // C++ 20
    std::cout << '\n' << std::string_view{ref.begin(), ref.end()};
    // C++ 23
    std::cout << '\n' << std::string_view{ref};
  }
}
```

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 工作招聘

寒冬了

华为出新手机了，但我不买，因为想把寒冬传给它
---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/079.html)
