---
layout: post
title:  第78期
---
# C++ 中文周刊 第78期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-weekly-Blogroll-344.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等

可以贴在下一期草稿里 [草稿链接](https://github.com/wanghenshui/cppweeklynews/pull/9)

2022 09 02

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-08-31 第165期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-08-31.md)

## 文章

- [What is the “vector pessimization”?](https://quuxplusone.github.io/blog/2022/08/26/vector-pessimization/)

尽量让move 构造函数 noexcept， 不然用vector可能有问题，多copy

比如这个

```cpp
struct Instrument {
    int n_;
    std::string s_;

    Instrument(const Instrument&) = default;

    // WRONG!!
    Instrument(Instrument&& rhs)
        : n_(std::exchange(rhs.n_, 0)),
          s_(std::move(s_))
        {}

    // RIGHT!!
    Instrument(Instrument&& rhs) noexcept
        : n_(std::exchange(rhs.n_, 0)),
          s_(std::move(s_))
        {}
};
```

如果不是noexcept，vector的move判定内部的T不是is_nothrow_move_constructible, 那就构造复制一份，所以多了个拷贝。也就是博主说的vector pessimization问题

vector本身的搬迁move的多余动作，如果能nothrow，move就更简单

- [malloc() and free() are a bad API](https://www.foonathan.net/2022/08/malloc-interface/#content)

free没有size看上去是个巧妙的设计，实际上隐含了挺多脏活


实际上，malloc/free/realloc等等，这些api还是太低层太精细了。对于使用者心理负担很大。

感谢@lh_mouse补充

- [C++ Coroutines: Understanding the Compiler Transform](https://lewissbaker.github.io/2022/08/27/understanding-the-compiler-transform)

协程背后都做了啥

- [Did you know that C++17 `[[nodiscard]]` attribute can be applied not only to function?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/293.md)

有点意思

```cpp
struct foo {
   [[nodiscard]] foo(auto& resource) {}
};

struct [[nodiscard]] bar {};

auto fn() -> bar;

[[nodiscard]] auto fn2() -> bool;

int main(int, char** argv){
    foo{argv}; // ignoring temp created by [[nodiscard]]
    fn();      // ignoring return value with [[nodiscard]]
    fn2();     // ignoring return value with [[nodiscard]]
}
```

- [Do we need the Y-combinator in C++? ](http://ib-krajewski.blogspot.com/2017/10/do-we-need-y-combinator-in-c-and.html?m=1)

老文，科普一下概念。

- [constexpr Function Parameters](https://www.elbeno.com/blog/?p=1685)

参数不是constexpr

```cpp
consteval auto square(int x) -> int { return x * x; }

constexpr auto twice_square(int x) -> int { return square(x); }
```

编译不过。作者展示了一下编译期计算。哎又回去了。constexpr还是不够const

- [实现一个trivially_copyable的tuple ](http://www.purecpp.cn/detail?id=2309)
- [并发与异步执行流中的对象角色概述(一) ](http://www.purecpp.cn/detail?id=2310)
- [编程语言-从来如此的便是对吗？](https://zhuanlan.zhihu.com/p/558778083)

看个乐

- [-march=, -mcpu=, and -mtune=](https://zhuanlan.zhihu.com/p/559008342)

介绍这几个flag

`-march=native`肯定接触过吧

- [20+ Ways to Init a String, Looking for Sanity](https://www.cppstories.com/2022/init-string-options/)

茴香豆的茴的20种写法

- [Why am I getting a null pointer crash when trying to call a method on my C++/WinRT object?](https://devblogs.microsoft.com/oldnewthing/20220901-00/?p=107097)

为什么大哥解bug这么熟练

## 视频

- [C++ Weekly - Ep 339 - `static constexpr` vs `inline constexpr`](https://www.youtube.com/watch?v=QVHwOOrSh3w)

static constexpr 和 inline constexpr区别。inline constexpr能合并文件重复的数据，是文件级别，static是函数级别，并不能合并代码段

聪明的你想到了static inline constexpr。这个效果就是static constexpr。static限制了范围

当然，-fmerge-contants能从另一个层面解决这个问题

感谢@lh_mouse补充

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 工作招聘

寒冬了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/078.html)
