---
layout: post
title:  第77期
---

# C++ 中文周刊 第77期



从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-343.html)摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等


可以贴在下一期草稿里 [链接](https://github.com/wanghenshui/cppweeklynews/blob/dev/posts/078.md)


2022 08 26

准备做视频，目前有代码走读/benchmark俩主题，大家还有啥意见可以供稿一下。下一期视频准备先来个userver代码走读。我先准备准备材料

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

标准委员会八月邮件 https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-08

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-08-24 第164期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-08-24.md)


## 文章

- [Did you know about memoized for less types (more compile-time friendly) conditional_t?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/292.md)


```cpp
namespace detail {
template <bool> struct conditional;
template <> struct conditional<false> {
  template <class, class T> using fn = T;
};
template <> struct conditional<true> {
  template <class T, class> using fn = T;
};
} // namespace detail

template <bool B, typename T, typename F>
using conditional_t = typename detail::conditional<B>::template fn<T, F>;
```
说实话，没看懂

- [libcopp对C++20协程的接入和接口设计](https://owent.net/2022/2206.html)

关于协程的封装探索，挺有意思的

- [glibc and DT_GNU_HASH ](https://maskray.me/blog/2022-08-21-glibc-and-dt-gnu-hash)

看不懂

- [GCC internals — From a porting perspective](https://ekaitz.elenq.tech/bootstrapGcc1.html)

GCC整体介绍

- [C++没有trim为什么不自己造一个呢？](https://zhuanlan.zhihu.com/p/553071153)

看个乐

- [fmt的痛与对format设计的思考](https://zhuanlan.zhihu.com/p/556307241)

fmt对输出有严格限制

- [Writing An Open-Source C++ Static Analysis Tool ](https://www.cppstories.com/2022/rsc-static-analysis/)

介绍他自己写的静态检查器 https://github.com/GregUtas/robust-services-core

- [A General Overview of What Happens Before main()](https://embeddedartistry.com/blog/2019/04/08/a-general-overview-of-what-happens-before-main/)

main函数执行前都干了啥，填充入参之类的


- [Catching sanitizer errors programmatically](https://lemire.me/blog/2022/08/20/catching-sanitizer-errors-programmatically/)

```cpp
#include <iostream>
#include <string>
#include <stdlib.h>

std::string message;

extern "C" {
void __asan_on_error() {
  std::cout << "You caused an error: " << message << std::endl;
}
}


int main() {
  int array[8];
  for(int k = 0;; k++) {
    message = std::string("access at ") + std::to_string(k);
    array[k] = 0;
  }
  return EXIT_SUCCESS;
}

```

不过不太实用

- [QEMU 结构体对齐产生的问题](https://zhuanlan.zhihu.com/p/558121669)

memcmp比较出错。qemu这种牛逼软件也会有这种问题啊

- [C++ mdspan学习笔记](https://zhuanlan.zhihu.com/p/553772995)

```cpp
int arr[10000];    // 一个已有的数组
mdspan mdarr{arr, i, j, k};  // 把已有的数组 arr 视作 i×j×k 的多维数组
int value = mdarr[x, y, z];  // 访问多维数组的元素
mdarr[x, y, z] = 42;         // 向元素赋值
```

简而言之就是这几行。现在你已经学会了
## 视频

- [C++ Weekly - Ep 338 - Analyzing and Improving Build Times](https://www.youtube.com/watch?v=Iybb9wnpF00)


-ftime-trace 生成编译的时间json结果，可以用chrome://tracing/ 浏览器来加载查看。可以自己试一试

觉得麻烦想快速验证的，这里有个build bench https://build-bench.com/b/zLopSp4Yj5XaijZSuwqiYvA2PNU



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [cake](https://github.com/thradams/cake) 一个c写的c前端
- [asyncgi](https://github.com/kamchatka-volcano/asyncgi/) 一个fastcgi库
- [MultiArena ](https://github.com/tirimatangi/MultiArena) 内存分配器实现，O1，定位类似pmr

## 工作招聘

突然寒冬卧槽了，任正非你这嘴开过光吧

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/077.html)
