---
layout: post
title:  第76期
---
# C++ 中文周刊 第76期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-weekly-Blogrolll-342.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等

可以贴在下一期草稿里 [链接](https://github.com/wanghenshui/cppweeklynews/blob/dev/posts/077.md)

2022 08 19

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2022-08-17 第163期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-08-17.md)

## 文章

- [proxy: Runtime Polymorphism Made Easier Than Ever](https://devblogs.microsoft.com/cppblog/proxy-runtime-polymorphism-made-easier-than-ever/)

类似folly::Poly

代码在https://github.com/microsoft/proxy

- [Using the C++23 std::expected type](https://mariusbancila.ro/blog/2022/08/17/using-the-cpp23-expected-type/)

```cpp
std::expected<std::vector<int>, Status> ReadData()
{
   if (!HasAcccess())
      return std::unexpected<Status> { Status::AccessDenied };
   if (OpenConnection() != 0)
      return std::unexpected<Status> {Status::DataSourceError};
   if (Fetch() != 0)
      return std::unexpected<Status> {Status::DataError};
   std::vector<int> data;
   data.push_back(42);
   return data;
}
```

相当于 `StatusWith<T>`这种组件

- [Did you know about `[[gnu::cold]]` function attribute to mark functions which are unlikely to be called?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/291.md)

```cpp
void report_error();
[[gnu::cold]] void report_error_cold();
void logic();

/*
cold(bool):
        test    edi, edi
        jne     .LBB0_1
        jmp     logic()
.LBB0_1:
        jmp     report_error_cold()
*/
auto cold(bool error) {
    if (error) {
        report_error_cold();
        return;
    }

    logic();
}

/*
normal(bool):
        test    edi, edi
        je      .LBB1_2
        jmp     report_error()
.LBB1_2:
        jmp     logic()
*/
auto normal(bool error) {
    if (error) {
        report_error();
        return;
    }

    logic();
}

/*
unlikely(bool):
        test    edi, edi
        jne     .LBB2_1
        jmp     logic()
.LBB2_1:
        jmp     report_error()
*/
auto unlikely(bool error) {
    if (error) [[unlikely]] {
        report_error();
        return;
    }

    logic();
}
```

对代码优化有点帮助。之前也介绍过

- [Comparing Rust&#39;s and C++&#39;s Concurrency Library](https://blog.m-ou.se/rust-cpp-concurrency/)

对比了一下各种atomic 锁之类的差异

- [【决策规划算法】绕桩算法（C++）](https://zhuanlan.zhihu.com/p/554274507)

看个乐

- [BOLT: 链接后优化技术简介](https://zhuanlan.zhihu.com/p/550895670)

这个优化了解一下

- [c++异步：asio的scheduler实现！ ](https://mp.weixin.qq.com/s/pLGV1Kyba-joBHZec4YZyA)

## 视频

- [C++ Weekly - Ep 337 - C23 Features That Affect C++ Programmers ](https://www.youtube.com/watch?v=jOFrKN54M5g)

```c
// #embed 支持
//#embed </path/to/file.txt>

//constexpr 部分支持
// not allowed in c23 :(
//constexpr int get_value() {
//  return 42;
//}
// allowed in c23!
constexpr int universe_and_everything = 42;

// [[attributes]]支持
[[nodiscard]] int get_value();
// deprecated, fallthrough, maybe_unused, nodiscard, noreturn

// 未命名参数
int do_work(int x, int)
{
  return x * 23;
}

// 类型枚举
enum MyEnum : char {
  x,
  y
};

// #6 __has_include
#if __has_include("somefile")
#include("somefile");
#endif
```

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [bloaty](https://github.com/google/bloaty) 查看代码的膨胀程度
- [passgen](https://gitlab.com/xfbs/passgen) 根据指定正则生成密码
- [async_simple](https://github.com/alibaba/async_simple) 协程库，阿里的，有demo。不过是部分开源
- [natalie](https://github.com/natalie-lang/natalie) c++写的ruby
- [jank](https://github.com/jank-lang/jank) c++写的Clojure

## 工作招聘

解不出bug要被开了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/076.html)
