---
layout: post
title:  第75期
---

# C++ 中文周刊 第75期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/))摘抄一些c++动态


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2022 08 12

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-08-10 第162期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-08-10.md)


## 文章

- [C++ 侵入式链表总结](https://zhuanlan.zhihu.com/p/524894979)

基础知识。值得看看

-  [Did you know that lambda expression is guaranteed to have a unique type? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/290.md)

```cpp
static_assert(typeid([]{}) != typeid([]{}));

template<auto = []{}>
struct foo{};

foo f1, f2;
static_assert(typeid(f1) != typeid(f2));
```

没什么卵用的知识，也是一个坑

- [Simplify Code with if constexpr and Concepts in C++17/C++20 ](https://www.cppstories.com/2018/03/ifconstexpr/)

利用concept和constexpr代替enable if 代码不列举了

- [5 Curious C++ Lambda Examples: Recursion, constexpr, Containers and More ](https://www.cppstories.com/2020/07/lambdas5ex.html/)

```cpp
int main()
{
    constexpr auto factorial23 = [](this auto&& self, int n) {
		if (n <= 1)
			return 1;
		return n * self(n - 1);
	};
    static_assert(factorial23(5) == 120);
}

```

递归+编译期 lambda，玩的花

- [包装开源项目作为自己的项目，来字节面试，这位同学现场翻车了](https://zhuanlan.zhihu.com/p/551857901)

分析bug挺有意思


- [Stop using bool in C++ for function parameters !](https://cpp-rendering.io/using-bool-in-c/)

老生常谈了，可读性问题，别用bool做多个参数，不然分不清啥是啥


- [QT signal is ten times slower than a virtual function](https://developernote.com/2022/08/qt-signal-is-ten-times-slower-than-a-virtual-function/)

简单压测，QT的信号槽比虚函数观察者模式并不快。看个乐

- [How to Use C++20 Modules with Bazel and Clang](https://buildingblock.ai/cpp20-modules-bazel)

仓库在这里https://github.com/rnburn/rules_cc_module
## 视频

- [C++ Weekly - Ep 336 - C++23's Awesome std::stacktrace Library ](https://www.youtube.com/watch?v=9IcxniCxKlQ)

代码在这里https://compiler-explorer.com/z/nbGGdMM4b

总算支持了

- [高性能并行编程与优化](https://github.com/parallel101/course)

一个课程，可以看看

- [succinct 的算法基础 rank & select 中，popcnt 可以用来实现 rank ](https://www.zhihu.com/question/27824125/answer/2621765689)

值得一看，拓展思路

- [基于 SIMD 指令的 PFOR-DELTA 解压和查找](https://zhuanlan.zhihu.com/p/63662886)

又是SIMD。可以看看

- [GDB 调试高阶「0x03」](https://zhuanlan.zhihu.com/p/550525330)
- [GDB的那些奇淫技巧](https://zhuanlan.zhihu.com/p/254879649)

gdb调试。值得一看
## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [Compile time finite state machine](https://github.com/cmargiotta/compile-time-fsm) 编译期状态机
- [boost  1.80.0](https://www.boost.org/users/history/version_1_80_0.html) 没有新库，一堆bugfix
- [boost.url](https://github.com/cppalliance/url) 一个URL库
- [手把手写c编译器](https://github.com/iiicp/ccc)
- [一个c++20 rpc框架](https://github.com/AlexBAV/AsyncCppRpc)
## 工作招聘

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/075.html)
