---
layout: post
title:  第74期
---
# C++ 中文周刊 第74期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-340.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2022 0808

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-08-03 第161期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-08-03.md)

## 文章

- [如何评价这个C++的离谱bug？](https://www.zhihu.com/question/543813788/answer/2581073497)

c++的bind和网络库的bind符号冲突了。很搞笑。不过在linux环境下没有这个问题
我之前在windows平台遇到过log日志接口和cmath的log函数有符号冲突。msvc这个方面做的不是很好

- [Did you know that `assume` attribute has been accepted to C++23?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/289.md)

```cpp
/*
divide_by_32_no_assume(int):
        lea     eax, [rdi + 31]
        test    edi, edi
        cmovns  eax, edi
        sar     eax, 5
        ret
*/
auto divide_by_32_no_assume(int x) {
    return x / 32;
}


/*
divide_by_32_assume(int):
        mov     eax, edi
        shr     eax, 5
        ret
*/
auto divide_by_32_assume(int x) {
    __builtin_assume(x >= 0);
    return x / 32;
}
```

这个之前提到过，有个经典的fast-math开关优化。那个力度比较大。这里你可以自主控制，力度更精细一些

- [C xor C++ Programming](https://docs.google.com/document/d/16B36r0HksR0LqQAGLA1syYCtZvYaVC0hEF2D00ZAd0o/view)

同一个代码段 c和c++有很大区别。主要是逗号表达式，左值右值，位域，类型转换，类型大小，空类型，匿名结构体等等。感兴趣的可以看看。

- [ThreadSanitizer——跟data race说再见](https://zhuanlan.zhihu.com/p/38687826)

介绍TSAN的原理

- [Kernel Memory Allocation Guide](https://zhuanlan.zhihu.com/p/549864377)

介绍内核内存分配策略

- [把structopt抱回c++](https://zhuanlan.zhihu.com/p/547960432)

用c++实现structopt, 看个乐

- [C++一行代码实现任意系统函数 Hook](https://zhuanlan.zhihu.com/p/545872317)

没看明白

- [Beware CTAD on reverse_iterator](https://quuxplusone.github.io/blog/2022/08/02/reverse-iterator-ctad/)

一个bug

```cpp
template<class It>
bool is_palindrome(It first, It last) {
    while (first != last) {
        --last;
        if (first == last) break;
        if (*first != *last) {
            return false;
        }
        ++first;
    }
    return true;
}
```

很自然的，可以改写成

```cpp
template<class It>
bool is_palindrome(It first, It last) {
    return std::equal(
        first, last,
        std::reverse_iterator(last),
        std::reverse_iterator(first)
    );
}
```

这里没用make_reverse_iterator,用的CTAD自动推导。但是这个推导可能不是我们预想的那样

```cpp
std::string s = "foo";
assert(!is_palindrome(s.begin(), s.end()));
assert(is_palindrome(s.begin()+1, s.end()));
assert(!is_palindrome(s.rbegin(), s.rend()));
assert(is_palindrome(s.rbegin(), s.rend()-1));  // Fails! Oof!
```

最后两个例子，已经是reverse的iterator， CTAD什么都不做，而不是推导成 `reverse_iterator<iterator>`这种东西，所以报错了

尽量别用CTAD。降低入门门槛但是引入了背景，不熟就掉坑

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [userver](https://github.com/userver-framework/userver) yandex微服务框架。轻松拼凑出可用微服务，内置http/grpc
- [hspp](https://github.com/BowenFu/hspp#sample-4-for-stm--concurrent)  Haskell Style Programming brought to C++ 不懂haskell 不评价
- [flecs](https://github.com/SanderMertens/flecs) 又一个ECS框架
- [YACLib](https://github.com/YACLib/YACLib) Yet Another Concurrency Library
- [HPX 1.8.1 Released](https://hpx-docs.stellar-group.org/latest/html/releases/whats_new_1_8_1.html)
- [Using Landlock to Sandbox GNU Make](https://github.com/jart/landlock-make)
- [hscpp: A library to hot-reload C++ at runtime](https://github.com/jheruty/hscpp)
- [static_functional](https://github.com/grandseiken/static-functional)

## 工作招聘

有没有需要看大门的，要被毕业了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/074.html)
