---
layout: post
title:  第71期
---
# C++ 中文周刊 第71期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-337.html)摘抄一些c++动态



[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2022 07 15

---

## 资讯

CPPcon 2022要开始了。2021我还没有看完

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-07-13 第158期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-07-13.md)



## 文章

- [C++异步：structured concurrency实现解析](https://mp.weixin.qq.com/s/fnzuqT8LbneAPbxbwLDY1A?st=B8F4E33CCDEFA32C6F860FC741829EE624D8BB31D83729EB9293384F935C31D112052A4A22118CC1A63C259E48B147251E42C68850DA951176F4EA25C45BE31B1C1675C69774A851D10279FB74DC0CC9D764D5664E4DCDA9C1767EC9A0CC90EBE44AC07CDEB486337B892E3DB34C570D9206B9FE7CD3944ED51D022B545928C61D685D017953F795133206644D749152F63AFED373E3B6A8CA69D4906E42A6BE583FDF8F0CB252D4CCEBF01A10126393DCB944C73514758EB5F7C2C19C33D6EB38D3F2AF268A03772CD4A05123ECB70D&vid=1688850557715316&cst=0EDB5F344FBC65DC4293BA2A7AB0F77F1C9E30F8862C9E33A95B78C3A52B29F195A885C03F83B919795489B02B745099&deviceid=7cd8b283-1663-4180-9b21-44ee69551c54&version=4.0.8.90588&platform=mac)

值得一看

- [C++异步：libunifex的scheduler实现！](https://mp.weixin.qq.com/s?__biz=MzIxMzY5MzY4MQ==&mid=2247484519&idx=1&sn=52d6328b6afada62fe85da0eb3e19dc9&)

值得一看

- [asio如何处理eof错误](https://mp.weixin.qq.com/s?__biz=MzIxMzY5MzY4MQ==&mid=2247484517&idx=1&sn=5d7325eeb6d0812ab68c8bb002ebb515&chksm=97b3a1fba0c428ed516c98ac9435e03936060d4e462c30a903e9eecf2893b9f1b4bd21279e71)

了解一下asio的背景

- [C++20 约束 constraint 元对象化: detector 设计模式](https://mp.weixin.qq.com/s?__biz=MzIxMzY5MzY4MQ==&mid=2247484512&idx=1&sn=6d12435bf728b3df9c5b1217d6001c31&)

上面这四篇都是purecpp公众号的。大家也可以去公众号看看

- [Programming PCA From Scratch In C++](https://blog.demofox.org/2022/07/10/programming-pca-from-scratch-in-c/)
- [Calculating SVD and PCA in C++](https://blog.demofox.org/2022/07/12/calculating-svd-and-pca-in-c/)

感兴趣的看下吧。数学和图形学？看不懂

- [Processing a ValueSet or PropertySet even in the face of possible mutation, part 1](https://devblogs.microsoft.com/oldnewthing/20220712-00/?p=106858)
- [Processing a ValueSet or PropertySet even in the face of possible mutation, part 2](https://devblogs.microsoft.com/oldnewthing/20220713-00/?p=106861)
- [Processing a ValueSet or PropertySet even in the face of possible mutation, part 3](https://devblogs.microsoft.com/oldnewthing/20220714-00/?p=106864)

手把手教你写代码，考虑各种场景

- [New std::optional Checks in Visual Studio 2022 version 17.3 Preview 3](https://devblogs.microsoft.com/cppblog/new-stdoptional-checks-in-visual-studio-2022-version-17-3-preview-3/)

介绍msvc特性

- [Filtering numbers faster with SVE on Graviton 3 processors](https://lemire.me/blog/2022/07/14/filtering-numbers-faster-with-sve-on-amazon-graviton-3-processors/)

arm的特性。现在arm的机器越来越多了。省钱
代码长这样。有兴趣的可以看看，我看不懂
```cpp
void remove_negatives(const int32_t *input, int64_t count, int32_t *output) {
  int64_t j = 0;
  const int32_t* endPtr = input + count;
  const uint64_t vl_u32 = svcntw();

  svbool_t all_mask = svptrue_b32();
  while(input <= endPtr - (4*vl_u32))
  {
      svint32_t in0 = svld1_s32(all_mask, input + 0*vl_u32);
      svint32_t in1 = svld1_s32(all_mask, input + 1*vl_u32);
      svint32_t in2 = svld1_s32(all_mask, input + 2*vl_u32);
      svint32_t in3 = svld1_s32(all_mask, input + 3*vl_u32);

      svbool_t pos0 = svcmpge_n_s32(all_mask, in0, 0);
      svbool_t pos1 = svcmpge_n_s32(all_mask, in1, 0);
      svbool_t pos2 = svcmpge_n_s32(all_mask, in2, 0);
      svbool_t pos3 = svcmpge_n_s32(all_mask, in3, 0);

      in0 = svcompact_s32(pos0, in0);
      in1 = svcompact_s32(pos1, in1);
      in2 = svcompact_s32(pos2, in2);
      in3 = svcompact_s32(pos3, in3);

      svst1_s32(all_mask, output + j, in0);
      j += svcntp_b32(all_mask, pos0);
      svst1_s32(all_mask, output + j, in1);
      j += svcntp_b32(all_mask, pos1);
      svst1_s32(all_mask, output + j, in2);
      j += svcntp_b32(all_mask, pos2);
      svst1_s32(all_mask, output + j, in3);
      j += svcntp_b32(all_mask, pos3);

      input += 4*vl_u32;
  }

  int64_t i = 0;
  count = endPtr - input;

  svbool_t while_mask = svwhilelt_b32(i, count);
  do {
    svint32_t in = svld1_s32(while_mask, input + i);
    svbool_t positive = svcmpge_n_s32(while_mask, in, 0);
    svint32_t in_positive = svcompact_s32(positive, in);
    svst1_s32(while_mask, output + j, in_positive);
    i += svcntw();
    j += svcntp_b32(while_mask, positive);
    while_mask = svwhilelt_b32(i, count);
  } while (svptest_any(svptrue_b32(), while_mask));
}
```

- [Clang Debugging C++ Coroutines](https://clang.llvm.org/docs/DebuggingCoroutines.html)

目测协程还是不太成熟，clang的文档可以看看

- [Notes: folly::ThreadLocalPtr ](https://blog.mwish.me/2022/06/12/Notes-folly-ThreadLocalPtr/)


讲folly实现的。值得一看

- [The magic of bits "Bitwise"](https://antonio-cooler.gitbook.io/coolervoid-tavern/the-magic-of-bits-bitwise)

讲位运算的。不如看hacker‘s delight

## 视频

- [C++ Weekly- Ep 332 - C++ Lambda vs std::function vs Function Pointer](https://www.youtube.com/watch?v=aC-aAiS5Wuc)

抽象程度 std::function callable，是个能存的对象，能存lambda
lambda只是一个能call的对象。右值。比函数对象能灵活点，匿名函数对象
函数指针也是个能存的，但是比std::function残废，不能保存有状态的lambda，比如有捕获的lambda

- [Many an `any` - Alisdair Meredith - ACCU 2022](https://www.youtube.com/watch?v=kb0dSbVbJ-s)

手把手教你写any

- [Principia Mathematica: The Foundations of Arithmetic in C++ - Lisa Lippincott - CppNow 2022](https://www.youtube.com/watch?v=2OpcDKzrgtc)

讲的整型约束。这个在cppcoin 2021上讲过。听不动。很困



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [unordered_dense](https://github.com/martinus/unordered_dense) hashmap实现，flatmap
- [tinylisp](https://github.com/Robert-van-Engelen/tinylisp) 99行c实现lisp

## 工作招聘

有没有小卖铺缺收银员

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/071.html)
