---
layout: post
title:  第70期
---
# C++ 中文周刊 第70期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-336.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2022 07 11

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-07-06 第157期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-07-06.md)

## 文章

- [c++ tip of week Did you know about C++20 template specialization with concepts](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/285.md)

```cpp
template<class T> concept fooable = requires(T t) { t.foo; };
template<class T> concept barable = requires(T t) { t.bar; };

template<class T> constexpr auto foobar = "unknown"sv;
template<fooable T> constexpr auto foobar<T> = "foo"sv;
template<barable T> constexpr auto foobar<T> = "bar"sv;

struct none {};
static_assert("unknown"sv == foobar<none>);
struct f { int foo; };
static_assert("foo"sv == foobar<f>);
struct b { int bar; };
static_assert("bar"sv == foobar<b>)
```

- [void versus noreturn](https://quuxplusone.github.io/blog/2022/06/29/that-undiscovered-country/)

```cpp
int divide1(int a, int b) {
    if (b != 0) {
        return a / b;
    } else {
        throw std::runtime_error("div by zero");
    }
}

void throw_error() {
    throw std::runtime_error("div by zero");
}
int divide2(int a, int b) {
    if (b != 0) {
        return a / b;
    } else {
        throw_error();
    }
}
```

两个区别在于 throw = noreturn 你用函数封装，分析不出这个函数是否是noreturn的行为。可以给这个函数标记noreturn

- [RISC-V linker relaxation in lld ](https://maskray.me/blog/2022-07-10-riscv-linker-relaxation-in-lld)

做编译器的，介绍他的这个功能背景和实现

- [Under what conditions can I modify the memory that I received in the form a STGMEDIUM?](https://devblogs.microsoft.com/oldnewthing/20220701-00/?p=106817)

讲windows的。看不懂

- [An example where inline constexpr makes a difference](https://quuxplusone.github.io/blog/2022/07/08/inline-constexpr/)

```cpp
#ifndef _GLIBCXX17_INLINE
# if __cplusplus > 201402L
#  define _GLIBCXX17_INLINE inline
# else
#  define _GLIBCXX17_INLINE
# endif
#endif

_GLIBCXX17_INLINE constexpr
  piecewise_construct_t piecewise_construct =
    piecewise_construct_t();
```

inline constexpr有助于节省二进制

- [The case of the constructor that was being ignored](https://devblogs.microsoft.com/oldnewthing/20220704-00/?p=106828)

一个报错

```
error C2440: '<function-style-cast>': cannot convert from 'initializer list' to 'winrt::Windows::Web::Http::HttpFormUrlEncodedContent'
message : No constructor could take the source type, or constructor overload resolution was ambiguous
```

构造函数的参数不可见的，导致推导不出调用哪个构造函数

- [Won&#39;t extend it more than once!](https://www.sandordargo.com/blog/2022/07/06/lifetime-extension-bughunt)

```cpp
#include <iostream>
#include <string>
#include <boost/variant.hpp>

struct VariantA {
    std::string url;
    std::string port;
    std::string token;
};

struct VariantB {
    std::string username;
    std::string password;
};

class Parameters {
public:
    Parameters(VariantA a) : params(a) {}
    Parameters(VariantB b) : params(b) {}
    boost::variant<VariantA, VariantB> get() const {return params;}
private:
    boost::variant<VariantA, VariantB> params;
};

Parameters makeParams(VariantA a) {
    return {a};
}

void print(unsigned char* p) {
    std::cout << p << '\n';
}

void foo(const Parameters& p) {
     const auto& va = boost::get<VariantA>(
      p.get()
    );
     print((unsigned char*)va.url.c_str());
     print((unsigned char*)va.port.c_str());
     print((unsigned char*)va.token.c_str());
}

int main() {
    VariantA a;
    a.url = "url";
    a.port = "port";
    a.token = "token";
  
    auto p = makeParams(a);
  
    foo(p);
}
```

哪里有问题？ 这里 `const auto& va = boost::get<VariantA>(p.get());`

经典错误。右值的右值还能用吗。不能。这个问题在range for中也有
就是生命周期问题。右值的生命周期被意外的延长了，使用 clang的`-Wdangling-gsl`帮你查

## 视频

cppnow视频开始放流了。这里更新个

- [Rehashing Hash Tables And Associative Containers - Eduardo Madrid - CppNow 2022](https://www.youtube.com/watch?v=B4VxpvFX9YY&list=PL_AKIMJc4roVsG8SAQ0jpihpFrgOCZbtB&index=9)

几个优化点，二分查找要尽可能的cache friendly，这样并不慢。之前也提到过b-tree的二分查找不慢，因为cache热

然后讲了robin hood hashtable的实现，介绍SIMD with a register原理 SWAR，说了一大堆hash map和 trie结合的设计，以及swar应用。代码没有开源。看了个寂寞

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [fmt 9.0](https://github.com/fmtlib/fmt/releases/tag/9.0.0) 支持更新，性能提升
- [sanitizer_workflows](https://github.com/picanumber/sanitizer_workflows) 好用的CI工具 可以参照这个使用https://github.com/picanumber/yapp/blob/main/.github/workflows/asan.yml
- [CTAsm](https://github.com/garc0/CTAsm) 编译期汇编，这谁看得懂啊
- [qalloc](https://github.com/yusing/qalloc)一个malloc玩具，支持gc。不过不是线程安全的。玩具。看个乐

## 工作招聘

有没有需要看大门的

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/070.html)
