---
layout: post
title:  第69期
---

# C++ 中文周刊 第69期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-335.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2022 07 01

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-06-29 第156期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-06-29.md)



## 文章

- [**Did you know about C++23 ispanstream - A strstream replacement using span as buffer**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/284.md)

```c++
#include <span>
#include <spanstream>
#include <iostream>

int main() {
  char input[] = "1 2 3";
  std::ispanstream is{std::span<char>{input}};
  int i1, i2, i3;
  is >> i1 >> i2 >> i3;
  std::cout << i1 << i2 << i3; // prints 123
}
```

看不懂有啥用

- [co_context: （三）性能优化杂谈](https://zhuanlan.zhihu.com/p/533448896)

介绍一些优化经验

- [C++尝鲜：在C++中实现LINQ！](https://zhuanlan.zhihu.com/p/531809006)

介绍用range做轮子

- [C++ 数据结构设计：如何高效地存储并操作超大规模的 <KEY, VALUE>](https://zhuanlan.zhihu.com/p/533012798)

代码走读，挺有意思的

- [c++ 高性能编程实战系列（1）](https://zhuanlan.zhihu.com/p/533708198)

科普了一些基本概念

- [探秘最新Linux内核中的自旋锁](https://zhuanlan.zhihu.com/p/534411164)

好像没有很新啊，还是带排队的自选锁

- [编译器优化那些事儿（4）：归纳变量](https://mp.weixin.qq.com/s/9CQheIx4nlPfp-xPff5PJQ)

了解一点编译器知识

- [How can I parse URL query string in the Windows Runtime?](https://devblogs.microsoft.com/oldnewthing/20220629-00/?p=106803)

- [How can I build a URL query string in the Windows Runtime?](https://devblogs.microsoft.com/oldnewthing/20220630-00/?p=106805)

看不懂了

- [Bitwise enumerations](https://www.sandordargo.com/blog/2022/06/22/bitwise-enums)

让枚举更紧凑的语义

```c++
#include <iostream>

enum class CarOptions : char {
    isAutomaticFlag = 0b1,
    isElectricFlag = 0b10,
    is4x4Flag = 0b100,
    hasRooftopFlag = 0b100,
    hasGPSFlag = 0b10000,
};

CarOptions operator|(CarOptions lhs, CarOptions rhs) {
    using CarOptionsType = std::underlying_type<CarOptions>::type;
    return CarOptions(static_cast<CarOptionsType>(lhs) | static_cast<CarOptionsType>(rhs));
}

CarOptions operator&(CarOptions lhs, CarOptions rhs) {
    using CarOptionsType = std::underlying_type<CarOptions>::type;
    return CarOptions(static_cast<CarOptionsType>(lhs) & static_cast<CarOptionsType>(rhs));
}

int main() {
    // flag 32: mutually exclusive with 8, has skibox
    CarOptions flags = CarOptions::isElectricFlag | CarOptions::hasRooftopFlag;
    
    std::cout << std::boolalpha;
    std::cout << static_cast<bool>(flags & CarOptions::isAutomaticFlag) << '\n';
    std::cout << static_cast<bool>(flags & CarOptions::isElectricFlag) << '\n';
    std::cout << static_cast<bool>(flags & CarOptions::is4x4Flag) << '\n';
    std::cout << static_cast<bool>(flags & CarOptions::hasRooftopFlag) << '\n';
    std::cout << static_cast<bool>(flags & CarOptions::hasGPSFlag) << '\n';
    
}
```

- [2022-06-27 – tolower() in bulk at speed](https://dotat.at/@/2022-06-27-tolower-swar.html)

还是SWAR方法

```c++
uint64_t tolower8(uint64_t octets) {
    uint64_t all_bytes = 0x0101010101010101;
    uint64_t heptets = octets & (0x7F * all_bytes);
    uint64_t is_gt_Z = heptets + (0x7F - 'Z') * all_bytes;
    uint64_t is_ge_A = heptets + (0x80 - 'A') * all_bytes;
    //uint64_t is_ascii = ~octets;
    //uint64_t to_lower = (is_upper >> 2) & (0x20 * all_bytes);
    //return (octets | to_lower);
    uint64_t is_ascii = ~octets & (0x80 * all_bytes);
    uint64_t is_upper = is_ascii & (is_ge_A ^ is_gt_Z);
    return (octets | is_upper >> 2);
}
```

比默认实现快一倍。我简单压了一下，效果确实是快了一倍 https://quick-bench.com/q/DTrgQdcp2JIXG2UKP1_jQDjooUA

当然如果不考虑费ascii的话可以用更猥琐的



![](https://wanghenshui.github.io/assets/tolower.png)

- [Tutorial: Preparing libraries for CMake FetchContent](https://www.foonathan.net/2022/06/cmake-fetchcontent/)

```c++
include(FetchContent) # once in the project to include the module

FetchContent_Declare(googletest
                     GIT_REPOSITORY https://github.com/google/googletest.git
                     GIT_TAG        703bd9caab50b139428cea1aaff9974ebee5742e # release-1.10.0)
FetchContent_MakeAvailable(googletest)

# Link against googletest's CMake targets now.
```

fetchcontent也可以解析zip源码包

- [Looking at assembly code with gdb](https://lemire.me/blog/2022/06/28/looking-at-assembly-code-with-gdb/)

lamire常用的gdb

查某段代码的汇编

```c++
gdb -q ./benchmark -ex "set pagination off" -ex "set print asm-demangle" -ex "disas 0x000000000001b540" -ex quit > gdbasm.txt
```

关注生成的指令

```gdb
 gdb -q ./benchmark -ex "set pagination off" -ex "set print asm-demangle" -ex "disas 0x000000000001b540" -ex quit | awk '{print $3}' | sort |uniq -c | sort -r | head
     32 and
     24 tbl
     24 ext
     18 cmhi
     17 orr
     16 ushr
     16 eor
     14 ldr
     13 mov
     10 movi
```



## 视频

- [C++ Weekly - Ep 330 - Faster Builds with `extern template` (And How It Relates to LTO)](https://www.youtube.com/channel/UCxHAlbZQNFU2LgEtiqd2Maw)

用extern template能快点。

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [yap](https://github.com/picanumber/yap)  **multi-threaded implementation of the pipeline pattern**.
- [STTL](https://github.com/kelbon/STTL) stl-like algorithms for TYPES
- [simdutf: Unicode validation and transcoding at billions of characters per second](https://github.com/simdutf/simdutf) 这大哥真有simd all the things的意思了
- [efs](https://github.com/xitongsys/efs) 国人写的简单的分布式文件系统。共享文件用的。实现的还挺简单
- [tscns](https://github.com/MengRao/tscns) 上期提到的快速拿到时间。突然发现有人实现了一个。方法都差不多

## 工作招聘

有没有需要看大门的我要被开了

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/069.html)
