---
layout: post
title:  第67期
---

# C++ 中文周刊 第67期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-334.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2022 06 17

明天就618了。居然没啥想买的

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-06-15 第154期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-06-15.md)

## 文章

- [2022 Annual C++ Developer Survey "Lite"](https://isocpp.org/files/papers/CppDevSurvey-2022-summary.pdf)

年度报告 可以点开看看 38页。比较悲伤的是这个图

![](https://wanghenshui.github.io/assets/age.png)

新人少啊

- [c++ tip of week **Did you know about introduced in C++20 `object concepts`**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/282.md)

http://eel.is/c++draft/concepts.object

```c++
template<class T>
  concept movable = is_object_v<T> && move_constructible<T> &&
                    assignable_from<T&, T> && swappable<T>;
template<class T>
  concept copyable = copy_constructible<T> && movable<T> && assignable_from<T&, T&> &&
                     assignable_from<T&, const T&> && assignable_from<T&, const T>;
template<class T>
  concept semiregular = copyable<T> && default_initializable<T>;
template<class T>
  concept regular = semiregular<T> && equality_comparable<T>;
/*
The semiregular concept is modeled by types that behave similarly to built-in types like int, except that they need not be comparable with 

The regular concept is modeled by types that behave similarly to built-in types like int and that are comparable with 
*/
```

```c++
#include <concepts>

struct movable {
  constexpr movable(movable&&) = default;
  constexpr auto operator=(movable &&) -> movable & = default;
};

static_assert(std::movable<movable>);
```

https://godbolt.org/z/4WdaP45h7 

concept感觉还处于完善中。概念足够强大。能让接口语义更清楚

- Overload Journal 169 - June 2022

[这个比较有意思](https://accu.org/journals/overload/30/169/romeo/) 用编译器来玩编译期游戏。string和随机数都可以外部指定。感觉以前介绍过

- [Rust directory iterator 5x faster than CPP?](https://www.reddit.com/r/cpp/comments/vdtlzp/rust_directory_iterator_5x_faster_than_cpp/)

c++的标准库遍历文件夹确实慢。想用快的，可以用https://ned14.github.io/llfio/namespacellfio__v2__xxx_1_1algorithm.html#ae068bc16598189811d0ce2b3530f1de7 这个兄弟的提案修正貌似没进

- [range的编译开销所有人都要承担](https://build-bench.com/b/WfuR5KZvB6PPHgAZrEYU9dTDYp8)

点进链接就能看到c++20的简单编译明显慢一大截。只能说是range的锅

- [C++20 Ranges Algorithms - sorting, sets, other and C++23 updates ](https://www.cppstories.com/2022/ranges-alg-part-three/)

介绍了一些range的新api

## 视频

- [ C++ Weekly - Ep 328 - Recursive Lambdas in C++23 ](https://www.youtube.com/watch?v=hwD06FNXndI)

```c++
int main() {
  constexpr auto fact = []<typename Self>(this const Self self, int value) {
  	if (value == 1) {
    	return value;
    } else {
    	return value * self(value -1);
    }
  }
  return fact(4);
}
```

lambda递归调用 （没啥用，别模仿）

Cpp now视频也更新了。https://pages.jetbrains.com/cppnow2022 根本看不完啊。视频太多了。有没有想看的咱们分一分总结一下

- [A lock-free std::atomic std::shared_ptr - Timur Doumler - ACCU 2022](https://www.youtube.com/watch?v=a10JpqI-CvU&list=PL9hrFapz4dsNx4kjMVgGMP6u37U1dSy7F&index=4)

这个视频是介绍 atomic_shared_ptr真正的lock free怎么实现。视频很有意思。把作者自已以前的演讲否定了。哎。人啊，总是在自我否定

很巧，我最近也遇到了这个问题，我用的是经典的shared_ptr + atomic_load/store管理，这种写法并不是lock free的，对于非POD类型，非常容易暴露问题

因为c++引入了atomic_shared_ptr，我于是换上boost::atomic_shared_ptr试试，结果出现了完全一样的堆栈 

boost::atomic_shared_ptr并不是lock_free的。标准库的实现也不是lock_free的。这他妈，和shared_ptr + atomic_load/store 没啥区别

那么哪些库实现了真正的lock free atomic shared ptr？ folly。我用folly::atomic_shared_ptr最终不崩溃了。

这个演讲讲的就是folly::atomic_shared_ptr实现。这个演讲还是值得一看的

这里把堆栈贴一下

```gdb
0x0000000000a84f18 in KVStore::~KVStore (this=0x7fba5c08a7d0, __in_chrg=<optimized out>) at external/h:317
#13 0x0000000000a950ff in __gnu_cxx::new_allocator<KVStore >::destroy<KVStore > (this=0x7fba5c08a7d0, __p=0x7fba5c08a7d0)
    at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/ext/new_allocator.h:140
#14 0x0000000000a9507b in std::allocator_traits<std::allocator<KVStore > >::destroy<KVStore > (__a=..., __p=0x7fba5c08a7d0)
    at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/bits/alloc_traits.h:487
#15 0x0000000000a94d83 in std::_Sp_counted_ptr_inplace<KVStore, std::allocator<KVStore >, (__gnu_cxx::_Lock_policy)2>::_M_dispose (this=0x7fba5c08a7c0)
    at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/bits/shared_ptr_base.h:535
#16 0x00000000004863f4 in std::_Sp_counted_base<(__gnu_cxx::_Lock_policy)2>::_M_release (this=0x7fba5c08a7c0) at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/bits/shared_ptr_base.h:154
#17 0x000000000047c05d in std::__shared_count<(__gnu_cxx::_Lock_policy)2>::~__shared_count (this=0x7fba6bfa9358, __in_chrg=<optimized out>) at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/bits/shared_ptr_base.h:684
#18 0x0000000000473afe in std::__shared_ptr<KVStore, (__gnu_cxx::_Lock_policy)2>::~__shared_ptr (this=0x7fba6bfa9350, __in_chrg=<optimized out>)
    at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/bits/shared_ptr_base.h:1123
#19 0x0000000000473b1a in std::shared_ptr<KVStore >::~shared_ptr (this=0x7fba6bfa9350, __in_chrg=<optimized out>) at /usr/lib/gcc/x86_64-redhat-linux/7/../../../../include/c++/7/bits/shared_ptr.h:93
//这里atomic_load，之后就触发析构！
```

boost的堆栈

```gdb
#13 0x0000000000a85120 in KVStore::~KVStore (this=0x7fc914004e40, __in_chrg=<optimized out>) at external/.h:319
#14 0x0000000000a8dc4f in boost::checked_delete<KVStore > (x=0x7fc914004e40) at external/boost/boost/core/checked_delete.hpp:36
#15 0x0000000000a94704 in boost::detail::sp_counted_impl_p<KVStore >::dispose (this=0x7fc914003910) at external/boost/boost/smart_ptr/detail/sp_counted_impl.hpp:89
#16 0x0000000000471a43 in boost::detail::sp_counted_base::release (this=0x7fc914003910) at external/boost/boost/smart_ptr/detail/sp_counted_base_gcc_atomic.hpp:120
#17 0x0000000000471ab9 in boost::detail::shared_count::~shared_count (this=0x7fc91efaf358, __in_chrg=<optimized out>) at external/boost/boost/smart_ptr/detail/shared_count.hpp:432
#18 0x0000000000473bd0 in boost::shared_ptr<KVStore >::~shared_ptr (this=0x7fc91efaf350, __in_chrg=<optimized out>) at external/boost/boost/smart_ptr/shared_ptr.hpp:335
//这里atomic_load，之后就触发析构！
```



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

- 本周报也需要看cpp视频的。有时间的可以看看cppnow2022给我投稿。我一个人根本看不完

## 新项目介绍/版本更新

- [librapid](https://github.com/LibRapid/librapid) 矩阵计算库
- [metapp -- C++ library for runtime reflection, introspection and meta types](https://github.com/wqking/metapp) 国人写的反射库

## 工作招聘

有没有需要看大门的可以找我

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/067.html)
