---
layout: post
title:  第66期
---

# C++ 中文周刊 第66期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-333.html/)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

20220610更新。本期内容少的可怜

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-06-08 第153期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-06-08.md)

博览网之前的送书活动又开始了，需要付个邮费

扫码就行了

<img src="https://wanghenshui.github.io/assets/cppbook.jpg" alt=""  width="50%">

## 文章

- [C++协程在阿里的推广和大规模应用](https://mp.weixin.qq.com/s/2XpvfVQVQ7PzkOn9jTQFkA)

阿里居然有c++编译器团队

- [源码阅读 gflags，发现设计缺陷](https://mp.weixin.qq.com/s/tsOOlYw0k2rDCNQ42LfPaw)

值得一看

- [Data structure size and cache-line accesses](https://lemire.me/blog/2022/06/06/data-structure-size-and-cache-line-accesses/)

测了一组不同大小的结构体用的数据

- [Assessing a read-after free for security implications: The string comparison](https://devblogs.microsoft.com/oldnewthing/20220603-00/?p=106710)

```c++
std::string GetThemeName();

void Vulnerable()
{
    auto theme = GetThemeName().c_str();
    if (strcmp(theme, "Light") == 0) {
        SetLightTheme();
    } else if (strcmp(theme, "Dark") == 0) {
        SetDarkTheme();
    } else {
        SetDefaultTheme();
    }
}
```

这种异常泄漏有被攻击的可能性

- [https://www.sandordargo.com/blog/2022/06/08/smart-pointers-and-deleters](https://www.sandordargo.com/blog/2022/06/08/smart-pointers-and-deleters)

Unique ptr的指定delete是模版参数的一部分，没有type erease，不同类型deleter就不能赋值了

```c++
template <typename T>
struct FakeDeleter {
  void operator()(T *ptr){
    std::cout << "FakeDeleter doesn't delete\n";
  } 
};

template <typename T>
struct LoggingDeleter {
    void operator()(T *ptr){
    std::cout << "LoggingDeleter is at work\n";
    delete ptr;
  } 
};
std::unique_ptr<int, FakeDeleter<int>> upFD (new int(42), FakeDeleter<int>());
std::unique_ptr<int, FakeDeleter<int>> upFD2 (new int(51), FakeDeleter<int>());
std::unique_ptr<int, LoggingDeleter<int>> upLD (new int(42), LoggingDeleter<int>());
upFD = std::move(upFD2); // OK
upFD = std::move(upLD); // NOT OK, fails to compile!
std::shared_ptr<int> spFD (new int(51), FakeDeleter<int>());
std::shared_ptr<int> spFD2 (new int(51), FakeDeleter<int>());
std::shared_ptr<int> spLD (new int(51), LoggingDeleter<int>());
spFD = spFD2;
spFD = spLD;
```

- [The true cost of linked lists](http://ykarroum.com/2022/05/30/true-cost-list/)

压测对比vector 和list，结果vector表现很好，主要是局部性的优势，把list底层的内存搞成一个整块内存，效果也不差。熟悉这种压测思路



## 视频

- [Jason Turner YT - C++ Weekly - Ep 327 - C++23's Multidimensional Subscript Operator Support](https://www.youtube.com/watch?v=g4aNGgLzVqw)

没啥说的。

ACCU 结束了。视频还没看。cppcon也没看完。最近挺忙。视频看得少

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

没啥可推荐的

给大家整个梗图吧

<img src="https://wanghenshui.github.io/assets/int.jpg" alt=""  width="50%">

## 工作招聘

有没有可以远程的工作可以联系我

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/066.html)
