---
layout: post
title:  第65期
---

# C++ 中文周刊 第65期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-332.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

2020 0606上周周五放假就忘记更了

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  2022-06-01 第152期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-06-01.md)

## 文章

- [**Did you know about use cases for type-based `reserved` decorator?** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/280.md)

```c++
template<class T, std::size_t Size>
struct reserved : T {
  constexpr reserved() {
    T::reserve(Size);
  }
};

int main() {
  std::cout << std::vector<int>{}.capacity();               // prints 0
  std::cout << reserved<std::vector<int>, 42>{}.capacity(); // prints 42
}
```

看不懂有啥实际用途。。[这里体验](https://godbolt.org/z/sKKzzx64z)

- [Embracing Modern C++ Safely, Book Review ](https://www.cppstories.com/2022/embracing-modern-cpp-book/)

介绍这本书的。主要是现代c++背景下的异常安全

- [Vectorized and performance-portable Quicksort](https://opensource.googleblog.com/2022/06/Vectorized%20and%20performance%20portable%20Quicksort.html)

又是simd 代码在这里https://github.com/google/highway

- [How dare they say ++it is faster than it++](https://mohitmv.github.io/blog/How-dare-they-say-Pre-Increment-is-faster/)

不一定++it比it++快。这种事看个人习惯

- [Using the mold linker for fun and 3x-8x link time speedups](https://www.productive-cpp.com/using-the-mold-linker-for-fun-and-3x-8x-link-time-speedups/)

也介绍很多次了mold连接器非常快

- [C++23: Consteval if to make compile time programming easier](https://www.sandordargo.com/blog/2022/06/01/cpp23-if-consteval)

```c++
consteval int bar(int i) {
    return 2*i;
}

int foo(int i) {
    if consteval {
        return bar(i);
    }
    return 2*i;
}

int main() {
  [[maybe_unused]] auto a = foo(5);
}
```

编译期利器

- [ Retrofitting Temporal Memory Safety on C++ ](https://security.googleblog.com/2022/05/retrofitting-temporal-memory-safety-on-c.html)

讲v8遇到的指针问题以及引入的解决方案，olipan gc之类的。之前讲过， 代码在这里https://chromium.googlesource.com/v8/v8.git/+/main/include/cppgc

- [Potential issue with C++20's initialization change](https://gist.github.com/s9w/ad9b1dd1ea6fb17e956559c8b352e246)

```c++
std::vector<int> vec0(5, 9); // 9, 9, 9, 9, 9
std::vector<int> vec1{5, 9}; // 5, 9
```

- [C++20’s parenthesized aggregate initialization has some downsides](https://quuxplusone.github.io/blog/2022/06/03/aggregate-parens-init-considered-kinda-bad/)

这个和上面讨论的差不多。这个新的构造函数引入了更多的歧义

- [Pretty-Printable Enumerations in Pure C](https://hirrolot.github.io/posts/pretty-printable-enumerations-in-pure-c.html#)

打印枚举几种实现

```c
// 基本
const char *Colour_print(Colour c) {
    switch (c) {
    case Red: return "Red";
    case Green: return "Green";
    case Blue: return "Blue";
    case Orange: return "Orange";
    case White: return "White";
    case Black: return "Black";
    case Pink: return "Pink";
    case Yellow: return "Yellow";
    default: return "Unknown";
    }
}

// X Marco 没省多少
#define COLOURS \
    X(Red)      \
    X(Green)    \
    X(Blue)     \
    X(Orange)   \
    X(White)    \
    X(Black)    \
    X(Pink)     \
    X(Yellow)

#define X(c) c,
typedef enum { COLOURS } Colour;
#undef X

const char *Colour_print(Colour c) {
    switch (c) {
#define X(c) case c: return #c;
        COLOURS;
#undef X
    default: return "Unknown";
    }
}
```

也可以抽象一下X macro

```c
#define ENUM_PRINTABLE(name, list) \
    typedef enum { list(DEF_ENUM_VARIANT) } name; \
 \
    const char *name##_print(name val) { \
        switch (val) { \
            list(CASE_ENUM_VARIANT) \
        default: return "Unknown"; \
        } \
    }

#define DEF_ENUM_VARIANT(c)  c,
#define CASE_ENUM_VARIANT(c) case c: return #c;


#define COLOURS(f) \
    f(Red)         \
    f(Green)       \
    f(Blue)        \
    f(Orange)      \
    f(White)       \
    f(Black)       \
    f(Pink)        \
    f(Yellow)

ENUM_PRINTABLE(Colour, COLOURS)
```

或者直接用metalang99. 感觉和boost pp差不多

```c++
#include <metalang99.h>

#define ENUM_PRINTABLE(name, ...) \
    typedef enum { __VA_ARGS__ } name; \
 \
    const char *name##_print(name val) { \
        switch (val) { \
            ML99_EVAL(ML99_variadicsForEach(ML99_reify(v(CASE_ENUM_VARIANT)), \
                                            v(__VA_ARGS__))) \
        default: return "Unknown"; \
        } \
    }

#define CASE_ENUM_VARIANT(c) case c: return #c;
```



## 视频

- [Jason Turner YT - C++ Weekly - Ep 326 - C++23's Deducing `this`](https://www.youtube.com/watch?v=5EGw4_NKZlY)

没啥说的，说了很多次了



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [expected](https://github.com/RishabhRD/expected) 一个std::expected实现
- [Precise pauseless concurrent Garbage Collector for C++    ](https://github.com/pebal/sgcl/blob/main/sgcl.h) 一个gc实现
- [JoltPhysics](https://github.com/jrouwe/JoltPhysics) vr的库

## 工作招聘

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/065.html)
