---
layout: post
title:  第64期
---

# C++ 中文周刊 第64期


从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-331.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

更新于5月27日晚九点

---

## 资讯

[标准委员会五月邮件](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-05)

[编译器信息最新动态推荐关注hellogcc公众号 2022-05-25 第151期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-05-25.md)



## 文章

- [Did you know that C++20 made `std::string` constexpr? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/279.md)

```c++
#include <string>

constexpr auto foo() {
  return std::string{"bar"};
}

static_assert("bar" == foo());
```

没啥说的

- [gcc profiler internals](https://trofi.github.io/posts/243-gcc-profiler-internals.html)

介绍gcc profiler原理。很长

- [`std::relocate`’s implementation is cute](https://quuxplusone.github.io/blog/2022/05/18/std-relocate/)

语言律师Arthur O’Dwyer的提案以及实现，看个乐

- [C standard library headers in C++    ](https://maskray.me/blog/2022-05-15-c-standard-library-headers-in-c++)

介绍封装c标准库文件c++做了啥额外的工作，一些额外的名字mangle，不同的分支调用，noexcept之类的

- [Assignment for `optional<T>`](https://brevzin.github.io/c++/2022/05/24/optional-assignment/)

如果是你，你怎么实现optional的复制呢？

比较简单的想法是析构再构造

```c++
template <typename T>
auto Optional<T>::operator=(Optional<T> const& rhs) -> Optional<T>& {
    if (has_value_ and rhs.has_value_) {
        value_ = rhs.value_;
    } else if (has_value_ and not rhs.has_value_) {
        value_.~T();
        has_value_ = false;
    } else if (not has_value_ and rhs.has_value_) {
        ::new (&value_) T(rhs.value_);
        has_value_ = true;
    } else {
        // nothing
    }
    return *this;
}

```

但如果是简单类型，这未免太杀鸡牛刀

如果是Optional<T&>，这可能又不正确。作者仔细的讨论了一番。这里不展开了。复杂

- [Branch/cmove and compiler optimizations](https://kristerw.github.io/2022/05/24/branchless/)

分支和条件移除优化（比如:?表达式）哪个更好？很难说，不一定没有分支更好。但相对好一些

因为:?表达式编译器可能给你加私货，插入if，甚至生成jump，感觉更复杂了

就算你是一行代码，编译器还是可能给你加东西的

```c++
unsigned r = ((a & 0xffff0000) != 0) << 4;


unsigned r;
if (a > 65535)
  r = 16;
else
  r = 0;

```



`__builtin_expect` 对编译器来说帮助不大，用这个是优化pipeline的，要知道你的业务场景

Gcc 9加了个`__builtin_expect_with_probability` 比 `__builtin_expect`更准点

- [RFC: Improving Clang’s Diagnostics](https://discourse.llvm.org/t/rfc-improving-clang-s-diagnostics/62584)

没啥说的

- [Parsing JSON faster with Intel AVX-512](https://lemire.me/blog/2022/05/25/parsing-json-faster-with-intel-avx-512/)

simdjson支持avx512更快了

- [Memory consumption, dataset size and performance: how does it all relate?](https://johnysswlab.com/memory-consumption-dataset-size-and-performance-how-does-it-all-relate/)

这人***Johny’s Software Lab LLC***博客挺不错。原来是个咨询公司啊 这怎么能赚到钱的。

我对国外很多软件的咨询赚钱模式感到不可思议。国内根本没有这个环境。归根到底是国内人才太多了？

说回正题

这篇文章讲了一些性能优化点，比如用定制内存分配器让数据局部性更好，以及各种省数据集的操作

说过很多次，cache应用/proxy应用，定制的内存分配器，非常有用，非常降低延迟，比如这个https://github.com/moya-lang/Allocator/blob/master/Allocator.h 别看实现挫，非常够用

还介绍了一些工具，比如https://github.com/andikleen/pmu-tools

- [Writing a sort comparison function, part 4: descending sort](https://devblogs.microsoft.com/oldnewthing/20220520-00/?p=106676)

看不懂了。

- [How to check if an Array is Sorted in C++](https://thispointer.com/how-to-check-if-an-array-is-sorted-in-c/)

怎么判定一个数组已经排好序了。正常来说遍历一边就行了。不过c++有个is_sorted接口，

另外用  `adjacent_find`也是可以的

- [My take on "where's all the code"](https://nullprogram.com/blog/2022/05/22/)

作者写了个c版的工具，输出代码目录的各种数据（行数，大小等等）这个博客是心路历程，代码在这里https://github.com/skeeto/scratch/blob/master/misc/watc.c 

- [Sometimes, it *is* a compiler bug](https://quick-lint-js.com/blog/bug-journey/)

作者写VS Code js插件的，查bug查到编译器头上了。这个是心路历程。

- [Safety and Performance - Threadsafe Datastructures in C++](https://sheep.horse/2022/5/safety_and_performance_-_threadsafe_datastructures.html)

手把手教你用锁

## 视频

- [C++ Weekly - Ep 325 - Why vector of bool is Weird ](https://www.youtube.com/watch?v=OP9IDIeicZE)

没啥说的。`vector<bool>`没人用。



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [Extract code from a screenshot](https://www.codefromscreenshot.com/) 小网站，把代码从截图里提取出来。有点意思
- [svector](https://github.com/martinus/svector)小对象优化的vector
- [HPX 1.8.0 released](https://hpx.stellar-group.org/2022/05/25/hpx-1-8-0-released/) c++20全实现
- [nod](Small, header only signals and slots C++11 library.    ) 一个信号槽实现
- [ReactivePlusPlus](https://github.com/victimsnino/ReactivePlusPlus)一个ReactiveX实现

## 工作招聘

有没有可以居家办公的工作啊，我想居家吉林农村办公

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/064.html)
