---
layout: post
title:  第61期
---

# C++ 中文周刊 第61期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-328.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-05-04 第148期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-05-04.md)

[GCC 12.1 Released](https://gcc.gnu.org/pipermail/gcc/2022-May/238653.html)

## 文章

- [Did you know that C++23 added `bind_back` to simplify writing higher order functions? ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/276.md)

```c++
#define FWD(...) static_cast<decltype(__VA_ARGS__)&&>(__VA_ARGS__)

[[nodiscard]] constexpr auto bind_back(const auto& func, auto... bound_args) {
    return [=] [[nodiscard]] (auto&&... unbound_args) {
        return func(FWD(unbound_args)..., bound_args...);
    };
}

int main() {
  //std::cout << std::bind_front(std::divides{}, 2.)(1.); // prints 2
  std::cout << std::bind_back (std::divides{}, 2.)(1.); // prints 0.5
}
```

- [C++20 Ranges: The Key Advantage - Algorithm Composition ](https://www.cppstories.com/2022/ranges-composition/)

range代码更干净

```c++
#include <algorithm>
#include <vector>
#include <iostream>
#include <ranges>   // new header!

int main() {
    const std::vector numbers = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    auto even = [](int i) { return 0 == i % 2; };
 
    std::ranges::reverse_view rv{ 
        std::ranges::drop_view { 
            std::ranges::filter_view{ numbers, even }, 1 
        }
    };
    for (auto& i : rv)
        std::cout << i << ' ';;                                 
}

```



- [How do I decode a `#pragma detect_mismatch` error?](https://devblogs.microsoft.com/oldnewthing/20220427-00/?p=106537)

一般都是多版本不兼容的问题

- [How can I force a `WriteFile` or `ReadFile` to complete synchronously or hang, in order to test something?](https://devblogs.microsoft.com/oldnewthing/20220425-00/?p=106526)

windows环境，代码我就不贴了

- [Comparing Memory Sanitizers](https://julienjorge.medium.com/comparing-memory-sanitizers-d4a944120418)

对比各种测试工具查内存报错，[测试报告](https://github.com/mediakind-video/memory-sanitizer-benchmark/blob/master/docs/analysis.md) valgrind效果非常好

- [Unpatched DNS Related Vulnerability Affects a Wide Range of IoT Devices](https://thehackernews.com/2022/05/unpatched-dns-related-vulnerability.html)

uClibc有bug，尽快升级。否则会被DNS污染

- [Make declaration order layout mandated](https://www.sandordargo.com/blog/2022/05/04/cpp23-P1847R4-Make-declaration-order-mandated)

介绍[`std::is_standard_layout`](https://en.cppreference.com/w/cpp/types/is_standard_layout)的

```c++
#include <iostream>
#include <type_traits>

class A {
  int a;
  int b;
};


class C {
  C (int& ib) : b(ib) {}
  int a;
  int& b;
};


int main() {
  std::cout << std::boolalpha;
  std::cout << std::is_standard_layout_v<A> << '\n';
  std::cout << std::is_standard_layout_v<C> << '\n';
}
```



- [Producing an empty Windows Runtime type in C++/WinRT](https://devblogs.microsoft.com/oldnewthing/20220429-00/?p=106543)

```c++
template<typename T>
constexpr T winrt_empty_value() noexcept
{
    if constexpr (std::is_base_of_v<winrt::Windows::Foundation::IUnknown, T>) {
        return nullptr;
    } else {
        return {};
    }
}
```



- [The case of the failed exchange of the vtable slot](https://devblogs.microsoft.com/oldnewthing/20220429-00/?p=106543)

Virtual­Protect使用问题

## 视频

- [C++ Weekly - Ep 322 - Top 4 Places To Never Use `const` ](https://www.youtube.com/watch?v=dGCxMmGvocE)

不要用const T做返回值的声明，会破坏move

```c++
struct S;
const S foo(); // bad
```



返回临时变量，临时变量不要用 const T，会破坏copy elision

```c++
struct S;
S foo() {
  const S s1;
  const S s2;
  if (/*some condition */) {
  	return s1;
  } else {
  	return s2;
  }
}
```



如果要在传进来的参数上改动返回，没必要const T

```c++
struct S;
S foo(const S s) {
	// do sth with s
  return s;
}
```

以及不要const 成员,先确定你的类是不是需要拷贝/move，如果是单例模式没啥问题，如果需要，别const成员

```c++
struct S {
 const int a;
}
```





## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [Spock SLAF is a Shared Library Application Firewall "SLAF".    ](https://github.com/CoolerVoid/spock_slaf)  保护使用openssl的应用？
- [anchors](https://github.com/oluwatimilehin/anchors) 类似timely dataflow的东西，不过写的非常简单
- [catch2 3.0发布](https://github.com/catchorg/Catch2/releases/tag/v3.0.0-preview5)



---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/061.html)
