---
layout: post
title:  第60期
---

# C++ 中文周刊 第60期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

五一劳动节快乐。

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[标准委员会四月邮件列表](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-04)

[编译器信息最新动态推荐关注hellogcc公众号 2022-04-27 第147期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-04-27.md)



## 文章

- [写给入门者的LLVM介绍](https://zhuanlan.zhihu.com/p/472813616)

手把手教你入门

- [Google “战败”后，C++20 用微软的提案进入协程时代！](https://mp.weixin.qq.com/s?__biz=MjM5MjAwODM4MA==&mid=2650915394&idx=1&sn=89d74456577921999fc66fd89a89b5b4)

忽略标题，一个协程的教程

- [a = b = c, a strange consequence of operator associativity](https://belaycpp.com/2022/04/28/a-b-c-a-strange-consequence-of-operator-associativity/)

赋值返回的是个左值，所以还能继续赋值。

```c++
int main() {
    int a = 1, b = 2, c = 3;
    (a = b) = c
    std::cout << a << b << c << std::endl; // 323
    return 0;
}
```

所以见到这种代码，不要惊慌，没啥毛病

```c++
class Foo;
Foo * make_Foo();
int main() {
    Foo * my_foo;
    if (my_foo = make_Foo()) //这么些能行吗？能行，就是让人难受
    {
        // ... Do things with the my_foo pointer
    }
    return 0;
}
```

如果你自己实现`operator =`，可能就有其他行为了

- [What’s up with `std::piecewise_construct` and `std::forward_as_tuple`?](https://devblogs.microsoft.com/oldnewthing/20220428-00/?p=106540)

```c++
template<typename...Args>
auto make_t1_with_default_t2(Args&&...args)
{
    return std::pair<T1, T2>(
        std::piecewise_construct,
        std::forward_as_tuple(std::forward<Args>(args)...),
        std::make_tuple());
}
```

piecewise_construct相当于一个指引，能把tuple拆成一个个元素方便pair构造

forward_as_tuple简单打包把一堆参数封装成tuple

这俩玩意就这意思，省掉逐个构造/取参数的功夫

- [Removing characters from strings faster with AVX-512](https://lemire.me/blog/2022/04/28/removing-characters-from-strings-faster-with-avx-512/)

代码在[这里](https://github.com/lemire/despacer) 感兴趣的可以玩一下

这里就不展开了。我看不懂avx-512这套东西

- [Shocking Examples of Undefined Behaviour](https://mohitmv.github.io/blog/Shocking-Undefined-Behaviour-In-Action/)

```c++
int main() {
  char buf[50] = "y";
  for (int j = 0; j < 9; ++j) {
    std::cout << (j * 0x20000001) << std::endl;
    if (buf[0] == 'x') break;
  }
}
```

O3优化直接死循环

```c++
typedef int (*Function)();

static Function Do;

static int EraseAll() {
  std::cout << "Disaster Ahead" << std::endl;
  // system("rm -rf /");
  return 0;
}

void NeverCalled() {
  Do = EraseAll;  
}

int main() {
  return Do();
}
```

clang优化直接把Do替换成了EraseAll

- [Dangerous Usage of GTest's EXPECT Macro](https://mohitmv.github.io/blog/Dangerous_use_of_gtest_expect_macro/)

```c++
// a.h
std::vector<int> FetchTwoValues(NetworkSocket& socket);

// a.cpp
std::vector<int> FetchTwoValues(NetworkSocket& socket) {
  return {socket.Fetch(), socket.Fetch()};
}

// a_test.cpp
TEST(A, Basic) {
  auto socket = MockSocket();
  std::vector<int> values = FetchTwoValues(socket);
  EXPECT_TRUE(values.size() >= 2);
  EXPECT_TRUE(0 == values[0]);
  EXPECT_TRUE(0 == values[1]);
}
```

如果 FetchTwoValues返回空 这个单测也可能成功，尽量用ASSERT_TRUE

- [C++20 Ranges Algorithms - 7 Non-modifying Operations](https://www.cppstories.com/2022/ranges-alg-part-one/)

 `all_of`, `any_of`, `none_of` `for_each`  `count_if`  `find_if` `find_first_of`  `mismatch` `search`

没啥说的

- [Local Time](https://akrzemi1.wordpress.com/2022/04/24/local-time/)

```c++
#include <chrono>
#include <format>
#include <iostream>
 
int main()
{
  namespace krn = std::chrono;
  using TwentyMins = krn::duration<int, std::ratio<20*60>>;
 
  krn::time_zone const* myTimeZone = krn::current_zone(); 
 
  krn::time_point p1 = krn::system_clock::now();
  krn::time_point p2 = myTimeZone->to_local(p1);
  krn::time_point p3 = krn::floor<TwentyMins>(p2);
 
  std::cout << std::format("{:%Y-%m-%d %H:%M}\n", p3);
}
```

目前c++20支持有问题，vs2022能编过



- [**Did you know what is the underlying type of NTTP string aka `fixed_string`**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/275.md)

```c++
template <std::size_t N> struct fixed_string final {
  constexpr explicit(false) fixed_string(const char (&str)[N + 1]) {
    std::copy_n(str, N + 1, std::data(data));
  }

  [[nodiscard]] constexpr auto operator<=>(const fixed_string &) const = default;

  std::array<char, N + 1> data{};
};

template <std::size_t N>
fixed_string(const char (&str)[N]) -> fixed_string<N - 1>;

template<fixed_string> struct foo;

int main() {
  what_is_my_type<"Quantlab">{}; // clang: 'what_is_my_type<{{"Quantlab"}}>'
                                 // gcc: struct what_is_my_type<fixed_string<8>{std::array<char, 9>{"Quantlab"}}>
}
```

https://godbolt.org/z/fqWo5nvTa

- [如何使用 GDB 分析 C/C++ Coroutine](https://zhuanlan.zhihu.com/p/489753875)

值得一看

- [Changing std::sort at Google’s Scale and Beyond](https://danlark.org/2022/04/20/changing-stdsort-at-googles-scale-and-beyond/)

sort太复杂了

另外， libstdcxx libcxx也有debug mode，以前我以为只有msvc有  [链接](https://gcc.gnu.org/onlinedocs/libstdc++/manual/debug_mode_using.html#debug_mode.using.mode) [链接](https://gcc.gnu.org/onlinedocs/libstdc++/manual/debug.html) [链接](https://libcxx.llvm.org/DesignDocs/DebugMode.html) 

- [Conformance Should Mean Something - fputc, and Freestanding](https://thephd.dev/conformance-should-mean-something-fputc-and-freestanding)

fputc的接口很让人难受，返回值和写入的值不相等

- [New C++ features in GCC 12](https://developers.redhat.com/articles/2022/04/25/new-c-features-gcc-12#corrections_and_internal_improvements)

介绍gcc12特性 支持c++23部分功能了，比如逗号多维数组支持

- [Data-Driven, Descriptor Based Generative C++](https://philippegroarke.com/posts/2022/data_driven_descriptor_based_generative_cpp/)



```c++
// A schema defined language and compiler beginning.
// OK OK, prelude.
enum class lang_directive {
	include,
	foreach,
	var,
	count,
};

enum class argument_requirement {
	required,
	optional,
	prohibited,
	count,
};

enum class argument_type {
	expression, // (auto v : vec)
	string, // "a string with quotes"
	name, // a single word without quotes
	count,
};

enum class compile_phase {
	preprocessor, // Parser will search for '#' + 'token'.
	compile,
	count,
};

// etc.

// I personally like to hide the descriptors in 'detail', if at all possible.
namespace detail {

struct include_descriptor {
	static constexpr auto key = lang_directive::include;
	static constexpr std::string_view token = "include";
	static constexpr auto arg_requirement = argument_requirement::required;
	static constexpr auto arg_type = argument_type::string;
	static constexpr auto phase = compile_phase::preprocessor;

	// etc.
};

struct foreach_descriptor {
	static constexpr auto key = lang_directive::foreach;
	static constexpr std::string_view token = "foreach";
	static constexpr auto arg_requirement = argument_requirement::required;
	static constexpr auto arg_type = argument_type::expression;
	static constexpr auto phase = compile_phase::compile;
};

struct var_descriptor {
	static constexpr auto key = lang_directive::var;
	static constexpr std::string_view token = "var";
	static constexpr auto arg_requirement = argument_requirement::required;
	static constexpr auto arg_type = argument_type::name;
	static constexpr auto phase = compile_phase::compile;
};


template <class Key, class... Descriptors>
struct lang_db {
	static constexpr size_t size = sizeof...(Descriptors);

	// Create compiletime or runtime accessible arrays, indexable with descriptors' key.
	static constexpr std::array<std::string_view, size> tokens{ Descriptors::token... };
	static constexpr std::array<argument_requirement, size> arg_requirements{ Descriptors::arg_requirement... };
	static constexpr std::array<argument_type, size> arg_types{ Descriptors::arg_type... };

	// Add useful helpers.
	static constexpr auto get_preprocessor_directives() {
		// Find all preprocessor directives and return std::array of their lang_directive keys.
	}

	// A LOT of static_asserts

	// etc.
};
} // namespace detail

// This is the "global" database which we'll be interrogating and interacting with.
using lang_directive_db = detail::lang_db<
	lang_directive,
	detail::include_descriptor,
	detail::foreach_descriptor,
	detail::var_descriptor
>;
```



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [ikos](https://github.com/NASA-SW-VnV/ikos) 开源静态分析工具
- [CTwik](https://mohitmv.github.io/blog/CTwik-General-Purpose-Hot-Patcher-For-Cpp/) 热更库
- [libparse](https://github.com/RishabhRD/libparse)
- [xmake 2.6.5发布支持远程编译](https://github.com/xmake-io/xmake/wiki/Xmake-v2.6.5-released,-Support-remote-compilation)
- [tomlplusplus 3.1发布修复bug](https://github.com/marzer/tomlplusplus/releases/tag/v3.1.0)
- [Goose](https://github.com/SzymonZos/Goose) 打印 容器(为啥不用fmt)
- [fccf](https://github.com/p-ranav/fccf) 代码查询小工具



---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/060.html)
