---
layout: post
title:  第59期
---
# C++ 中文周刊 第59期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-326.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)

欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新2022-04-20 第146期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-04-20.md)

## 文章

- [**Did you know about C++23 proposal `Structured Bindings can introduce a Pack`?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/274.md)

```c++
#include <tuple>
#include <cassert>

int main() {
  auto [first, ...ts] = std::tuple{1, 2 ,3};
  assert(1 == first);
}
```

看个乐。提案中

- [The infamous bug of range-based for loops](https://www.sandordargo.com/blog/2022/04/20/range-base-p2012)

```c++
#include <iostream>
#include <string>
#include <vector>

std::vector<std::string> createStrings() {
    return {"This", "is", "a", "vector", "of", "strings"};
}

int main()
{
  for (auto w: createStrings()) {
      std::cout << w << " "; // this works fine
  }
  std::cout << std::endl;
  for (auto c: createStrings()[0]) {
      std::cout << c << " "; // this is UB
  }
  std::cout << std::endl;
}
```

经典bug :range for里面的变量生命周期有问题

聪明的你想到了用optional，照样不行

```c++
#include <iostream>
#include <optional>
#include <string>
#include <vector>

std::vector<std::string> createStrings() {
    return {"This", "is", "a", "vector", "of", "strings"};
}

std::optional<std::vector<int>> createOptionalInts() {
    return std::vector<int>{1,2,3,4,5,6};
}


int main()
{
  for (auto i: createOptionalInts().value()) {
      std::cout << i << " "; // UB
  }
  const auto v = createOptionalInts().value(); //注意，必须是值，写成const auto& 一样是UB
  for (auto i: v) {
      std::cout << i << " ";
  }
  std::cout << std::endl;
}
//0 0 27344912 0 5 6 1 2 3 4 5 6 
```

其实range for是语法糖，上面的代码等价于

```c++
#include <iostream>
#include <optional>
#include <string>
#include <vector>

std::optional<std::vector<int>> createOptionalInts() {
    return std::optional<std::vector<int>>1;
}

int main()
{  
  auto&& range = createOptionalInts().value();
  auto position = range.begin();
  auto end = range.end();
  for(; position != end; ++position) {
      std::cout << *(position) << " "; // UB
  }
  std::cout << std::endl; 
}
```

问题就在这个range已经消失了，访问这个指针就有问题

- [How can I `co_await` on a Windows Runtime async action or operation with a timeout?](https://devblogs.microsoft.com/oldnewthing/20220415-00/?p=106486)

有点看不懂了

```c++
auto timedOut = std::make_shared<bool>();
auto widgetOperation = GetWidgetAsync();
auto widgetTimeout = [](auto timedOut) -> IAsyncOperation<Widget>
    {
        co_await winrt::resume_after(15s);
        *timedOut = true;
        co_return nullptr;
    }(timedOut);
auto widget = co_await winrt::when_any(widgetOperation, widgetTimeout);

widgetOperation.Cancel();
widgetTimeout.Cancel();

if (*timedOut) {
    // timed out
} else {
    // GetWidgetAsync() produced something (possibly nullptr)
}

```

```c++
auto widgetOperation = GetWidgetAsync();
auto widgetTimeout = [] -> IAsyncOperation<Widget>
    {
        co_await winrt::resume_after(15s);
        co_return nullptr;
    }();
auto widget = co_await winrt::when_any(widgetOperation, widgetTimeout);
auto timedOut = widgetTimeout.Status() == AsyncStatus::Completed;

widgetOperation.Cancel();
widgetTimeout.Cancel();

if (timedOut) {
    // timed out
} else {
    // GetWidgetAsync() produced something (possibly nullptr)
}
```

- [Class template argument deduction may be the new hotness, but we’ll always have maker functions](https://devblogs.microsoft.com/oldnewthing/20220420-00/?p=106506)

CTAD把活交给了编译器推导，但大家没咋用，还是有make_xx函数来构造对象，清晰，明确

- [Multi-GPU Programming with Standard Parallel C++, Part 1](https://developer.nvidia.com/blog/multi-gpu-programming-with-standard-parallel-c-part-1/)
- [Multi-GPU Programming with Standard Parallel C++, Part 2](https://developer.nvidia.com/blog/multi-gpu-programming-with-standard-parallel-c-part-2/)

`nvc++ compiler`软文的感觉。介绍了一些算法可以并行，比如

```c++
// Step 1: compute the number of variables contributed by every node.
int* numValuesPtr = allocateMemory(numberOfCells);
for_each(execution::par_unseq, numValuesPtr,
         numValuesPtrl + numberOfCells, [=](int& numValues)
{
    int i = &numValues - numValuesPtr;
    // Compute number of variables contributed by current node.
    numValues = computeNumValues(i);
} );
// 2. Compute the buffer index for every node.
int* indexPtr = allocateMemory(numberOfCells);
exclusive_scan(execution::par_unseq, numValuesPtr,
         numValuesPtr + numberOfCells, indexPtr, 0);
// 3. Pack the data into the buffer.
for_each(execution::par_unseq, indexPtr,
         indexPtr + numberOfCells, [=](int& index)
{
    int i = &index - indexPtr;
    packCellData(i, index);
} );
```

- [Faster GDB Startup](https://tromey.com/blog/?p=1084)

介绍gdb启动都做了什么以及如何优化启动速度

- [What’s new for C++ Debugging in Visual Studio Code](https://devblogs.microsoft.com/cppblog/whats-new-for-c-debugging-in-visual-studio-code/?WT.mc_id=academic-0000-abartolo)

介绍vscode更新的调试功能（谁用vscode调试啊）

## 视频

- [C++ Weekly - Ep 320 - Using `inline namespace` To Save Your ABI ](https://www.youtube.com/watch?v=rUESOjhvLw0)

```c++
namespace tool {
inline namespace v1_0_0 {
struct Data {
  int a;
  bool b;
  std::string c;
};
bool foo(const Data d);
}
}

int main() {
  const tool::Data d;
  return tool::foo(d);
}
```

看到这个用法，inline namespace在调用的时候可以省掉，但是这个inline namespace的符号可以保证唯一，这样就避免了不同版本造成的ABI break

很妙，但没人用。这属于项目管理的一部分。严格来说很难出现ABI break

2024-0121更新：

和群友讨论，如果用using namespace detail_v1_0_0那种嵌套命名空间的玩法，其实也可以

inline namespace能有啥优势，省符号？

我写了两版对比 https://godbolt.org/z/TK1PTf4bG 实际上汇编符号基本差不多，没省什么玩意。

inline省一行，也行吧

## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线

## 新项目介绍/版本更新

- [mleak](https://github.com/mini-rose/mleak) 劫持malloc/free 分析内存泄漏
- [boostdep-report](https://pdimov.github.io/boostdep-report/) 分析boost各个组件的依赖关系 比如asio依赖boost core之类的
- [vcpkg April 2022 Release is Now Available](https://devblogs.microsoft.com/cppblog/vcpkg-april-2022-release-is-now-available/)
- [poco Release 1.11.2 Available](https://pocoproject.org/blog/?p=1156)

## 工作招聘

互联网寒冬了胖友们

---

[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/059.html)
