---
layout: post
title:  第58期
---

# C++ 中文周刊 第58期



从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-325.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

你们说整个代码走读周会/项目分享 靠谱么。我感觉拉不到人

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号  2022-04-13 第145期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-04-13.md)

## 文章

- [**Did you know that concept can be passed via lambda expression** ](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/273.md/)

```c++
static_assert([]<class T>{ return std::integral<T>; }.operator()<int>());

struct f { auto foo() -> void; };
static_assert([](auto t){ return requires { t.foo(); }; }(f{}));
```

我觉得这玩意还是不要知道的好

- [可怕！CPU暗藏了这些未公开的指令！](https://zhuanlan.zhihu.com/p/498014297)

看个乐，挺有意思的

- [Pointers Are Complicated III, or: Pointer-integer casts exposed](https://www.ralfj.de/blog/2022/04/11/provenance-exposed.html)

一些c指针的缺陷。老生常谈了属于是

- [Using std::chrono](https://akrzemi1.wordpress.com/2022/04/11/using-stdchrono/)

复习一下chrono，c++20有个[file_clock](https://zh.cppreference.com/w/cpp/chrono/file_clock)，干嘛的

- [SnapdragonProfiler崩溃问题分析](https://zhuanlan.zhihu.com/p/498034539)

windbg调试手把手教学

- [Three Benchmarks of C++20 Ranges vs Standard Algorithms ](https://www.cppstories.com/2022/ranges-perf/)

测了几种算法range和标准实现的表现。range下限稳定。能用range尽量用range

- [Please repeat yourself: The `noexcept(noexcept(…))` idiom](https://devblogs.microsoft.com/oldnewthing/20220408-00/?p=106438)

```c++
template<typename T>
struct Holder
{
    T value;

    template<typename... Args>
    Holder(Args&&... args) :
        value(std::forward<Args>(args)...) {}
};

template<typename U> Holder(U&&) ->
    Holder<std::remove_reference_t<U>>
```

省一个类型缩写 `Holder(42)`而不是`Holder<int>42` 但是问题来了，如果T的构造抛异常就完了

标记noexcept，怎么标？

```c++
    template<typename... Args>
    Holder(Args&&... args)
        noexcept(noexcept(T(std::forward<Args>(args)...))) :
        value(std::forward<Args>(args)...) {}
```



- [Type Erasure](http://www.modernescpp.com/index.php/type-erasure)

```c++
#include <iostream>
#include <memory>
#include <string>
#include <vector>

class Object {                                              // (2)
public:
    template <typename T>                                   // (3)
    Object(T&& obj): object(std::make_shared<Model<T>>(std::forward<T>(obj))){}
    std::string getName() const {                           // (4)
        return object->getName(); 
    }
   struct Concept {                                         // (5)
       virtual ~Concept() {}
	   	 virtual std::string getName() const = 0;
   };

   template< typename T >                                   // (6)
   struct Model : Concept {
       Model(const T& t) : object(t) {}
	   std::string getName() const override {
		   return object.getName();
	   }
     private:
       T object;
   };

   std::shared_ptr<const Concept> object;
};

void printName(std::vector<Object> vec){                    // (7)
    for (auto v: vec) std::cout << v.getName() << '\n';
}

struct Bar{
    std::string getName() const {                           // (8)
        return "Bar";
    }
};

struct Foo{
    std::string getName() const {                           // (8)
        return "Foo";
    }
};

int main(){
    std::vector<Object> vec{Object(Foo()), Object(Bar())};  // (1)
    printName(vec);
    std::cout << '\n';
}
```

学会这种封装思想.虽然不太会用到 

- [Memory-Size Literals](https://wunkolo.github.io/post/2022/02/memory-size-literals/)

```c++
constexpr unsigned long long operator""_KiB(unsigned long long int x) {
    return 1024ULL * x;
}

constexpr unsigned long long operator""_MiB(unsigned long long int x) {
    return 1024_KiB * x;
}

constexpr unsigned long long operator""_GiB(unsigned long long int x) {
    return 1024_MiB * x;
}

constexpr unsigned long long operator""_TiB(unsigned long long int x) {
    return 1024_GiB * x;
}

constexpr unsigned long long operator""_PiB(unsigned long long int x) {
    return 1024_TiB * x;
}
```

就是这段代码，分享给大家，增加代码可读性 

作者拿这段代码到处提MR ，比如这个https://github.com/xenia-project/xenia/pull/1935/

- [Stringy Templates](https://vector-of-bool.github.io/2021/10/22/string-templates.html)

还是fix_string

```c++
template <size_t Length>
struct fixed_string {
    char _chars[Length+1] = {}; // +1 for null terminator
};
template <size_t N>
fixed_string(const char (&arr)[N])
    -> fixed_string<N-1>;  // Drop the null terminator

template <fixed_string<6> Str>
struct foo;

foo<"Hello!"> hello;
foo<"world!"> world;
foo<"nope"> b;  // FAIL!

```

foo的这个6非常碍眼且不合理。c++20，可以自动推导了

```c++
template <fixed_string S>
struct ctad_foo {};
ctad_foo<"Hello"> h
ctad_foo<"user"> u;

```

更离谱的

```c++
template <fixed_string> // [1]
struct named_type {};

template <> // [2]
struct named_type<"integer"> { using type = int; };

template <> // [2]
struct named_type<"boolean"> { using type = bool; };

template <fixed_string S> // [3]
using named_type_t = named_type<S>::type;

named_type_t<"integer"> v = 42;
named_type_t<"boolean"> b = false;



template <fixed_string Name>
concept names_a_type = requires {
    // Require that `named_type_t<Name>` produces a valid type
    typename named_type_t<Name>;
};

static_assert(names_a_type<"integer">);
static_assert(!names_a_type<"widget">);

template <fixed_string S>
auto do_something() {
    static_assert(
        names_a_type<S>,
        "The given string must name a registered type!");
}

```

类型信息真正的存下来了。不过一时半会用不上





concept+ lambda

```c++
#include <concepts>

template <auto Constraint> struct requires_ {
  template <class T> requires (Constraint.template operator()<T>()) operator T();
};

#define $requires(...) requires_<[]<class _>{ return __VA_ARGS__; }>{}

template<class T>
concept fooable = requires(T t) {
  t.foo(
    $requires(std::integral<_>),
    $requires(std::same_as<short, _>)
  );
};

struct bar { void foo(); };
static_assert(not fooable<bar>);

struct foo1 { void foo(int, short); };
static_assert(fooable<foo1>);

struct foo2 { void foo(int, auto); };
static_assert(fooable<foo2>);
```



## 视频

- [C++ Weekly - Ep 319 - A JSON To C++ Converter ](https://www.youtube.com/watch?v=HROQPE59q_w)

一个编译期的json parser。代码在这里https://github.com/lefticus/json2cpp 玩出花来了





## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [C++20 library for comfortable and efficient dynamic polymorphism    ](https://github.com/kelbon/AnyAny) 
- [seer](https://github.com/epasveer/seer) 一个gdb前端
- [perf-ninja](https://github.com/dendibakh/perf-ninja) 一个c++实验课程，推荐大家都做一做，他的书这里可以领https://book.easyperf.net/perf_book
- [boost 179](https://www.boost.org/users/history/version_1_79_0.html) 一些fix。没有新库，都是fix



---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/058.html)
