---
layout: post
title:  第57期
---

# C++ 中文周刊 第57期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-324.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

最近非常忙，更新也有拖延，见谅。解不出bug我都想跳楼了

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新  第144期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-04-06.md)

### 安全问题报告

- Chromium "Type confusion" 的bug影响QtWebEngine，请升级到Qt 5.15.9, Qt 6.2.5 or Qt 6.3.0.
- [zlib1.2.11 安全问题 CVE-2018-25032 which allows memory corruption when deflating (i.e., when compressing) if the input has many distant matches.](https://github.com/madler/zlib/issues/605)
请使用到的尽快升级版本，qt的qCompress也受影响，如果使用，务必升级


## 文章

- [Did you know that C++20 added std::ranges::{all_of, any_of, none_of} algorithms?](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/blob/master/272.md)


```c++
int main() {
  assert(std::ranges::all_of (std::array{1, 1, 1}, [](const auto& value) { return value == 1; }));
  assert(std::ranges::any_of (std::array{1, 2, 3}, [](const auto& value) { return value == 2; }));
  assert(std::ranges::none_of(std::array{1, 2, 3}, [](const auto& value) { return value == 4; }));
}
```

没啥说的，algorithm算法的range版本


- [go style协程设计](https://zhuanlan.zhihu.com/p/492928946)

作者写了个库，很有意思

- [TCMalloc引起的 bad_alloc bug 记录](https://zhuanlan.zhihu.com/p/491970556)

查bug要先看issue和release信息。不过tcmalloc有很多都替换成mimalloc和jemalloc了。

- [拥抱xmake，Win C++编译新体验](https://zhuanlan.zhihu.com/p/492035106)

xmake真的挺好用的。自己构建小东西，推荐使用

- [技术简报（第三期）](https://zhuanlan.zhihu.com/p/490430775)

赵工的这个整理挺不错的。会介绍一些系统知识

- [Use strong types instead of bool parameters](https://www.sandordargo.com/blog/2022/04/06/use-strong-types-instead-booleans)

老生常谈了，bool语义不清晰，要是多个参数都是bool那可要了老命了，最好不要用
几种解决办法，用enum不同类型区分，或者写注释，多写注释

- [Fuzzy search for C++ Reference, Qt documentation and more from shell, Vim or Neovim](https://cukic.co/2022/04/02/fuzzy-search-documentation/)

主要是使用zeal的cli工具嵌入，最近才知道zeal支持linux了。可以下载cpp的文档然后用[zeal-cli](https://gitlab.com/ivan-cukic/zeal-lynx-cli)来搜索，省一个搜索的功夫

- [Design Patterns VS Design Principles: Abstract Factory](https://www.fluentcpp.com/2022/04/06/design-patterns-vs-design-principles-abstract-factory/)

介绍工厂模式怎么组织代码的。这里不展开了。

- [The std::invoke function does more than invoke functions](https://devblogs.microsoft.com/oldnewthing/20220401-00/?p=106426)

```c++
struct S
{
    std::function<void()> do_something;
    int v;
};

S s;
s.do_something = []() { std::cout << "hello"; };

// does not print anything
std::invoke(&S::do_something, s);
```
为什么不打印？？？我明明调用了invoke

事实上得这么用
```c++
std::invoke(&S::do_something, s)();
```
一旦理解了这种用法，代码就有了新的写法，面向invoke编程

```c++
// Old and busted
this->dict.find(3)->second = "meow";

// New hotness
std::invoke(
    static_cast<std::map<int, std::string>::iterator
        (std::map<int, std::string>::*)(int const&)>(
        &std::map<int, std::string>::find),
        std::invoke(&MyClass::dict, this), 3)->second = "meow";

// Beyond hot
std::invoke(
    static_cast<std::string& (std::string::*)(char const*)>
        (&std::string::operator=), 
    std::invoke(&std::pair<int const, std::string>::second,
        std::invoke(
            static_cast<std::pair<int const, std::string>& (
                std::map<int, std::string>::iterator::*)() const noexcept>
                (&std::map<int, std::string>::iterator::operator*),
        std::invoke(
            static_cast<std::map<int, std::string>::iterator
                (std::map<int, std::string>::*)(int const&)>
                (&std::map<int, std::string>::find),
            std::invoke(&MyClass::dict, this), 3))), "meow");
```
我已经看不懂invoke啥意思了

这代码里还有赋值还有引用啥的太啰嗦，封装一下

```c++

namespace mfptr
{
    template<typename Object, typename...Args>
    decltype(auto) find(Object&& object, Args&&...args) {
        return std::forward<Object>(object).find(std::forward<Args>(args)...);
    }

    template<typename Object>
    decltype(auto) dereference(Object&& object) {
        return *std::forward<Object>(object);
    }

    template<typename Object, typename Arg>
    decltype(auto) assign(Object&& object, Arg&& arg) {
        return std::forward<Object>(object) = arg;
    }
}

std::invoke(
    &mfptr::assign<std::string&, char const*>, 
    std::invoke(&std::pair<int const, std::string>::second,
        std::invoke(
            &mfptr::dereference<std::map<int, std::string>::iterator>, 
            std::invoke(
                &mfptr::find<std::map<int, std::string>&, int>,
                std::invoke(&MyClass::dict, this), 3))), "meow");
```
看个乐，可别学。

- [All Windows threadpool waits can now be handled by a single thread](https://devblogs.microsoft.com/oldnewthing/20220406-00/?p=106434)

windows相关的api我不了解，这里贴出来感兴趣的自己看看吧


- [Adventures in application compatibility: The case of the RAII type that failed to run its destructor](https://devblogs.microsoft.com/oldnewthing/20220405-00/?p=106432)

涉及到硬件交互，硬件直接抛异常  structured exception 导致RAII没执行成功？这里和COM相关。我没有搞懂


- [Compressing looping animation clips](http://nfrechette.github.io/2022/04/03/anim_compression_looping/)

讲压缩动画的，不了解，这里贴出来感兴趣的自己看

- [String representations are not unique: learn to normalize!](https://lemire.me/blog/2022/04/05/string-representations-are-not-unique-learn-to-normalize/)

一个字符可能有不同的表达方式，需要归一
```python
 "\u0065\u0301".normalize() == "\u00e9".normalize()
true
```


## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线


## 新项目介绍/版本更新

- [wxWidgets - wxWidgets 3.1.6 Released](https://www.wxwidgets.org/news/2022/04/wxwidgets-3.1.6-released/)

---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/057.html)
