---
layout: post
title:  第55期
---

# C++ 中文周刊 第55期

从[reddit](https://www.reddit.com/r/cpp/)/[hackernews](https://news.ycombinator.com/)/[lobsters](https://lobste.rs/)/[meetingcpp](https://www.meetingcpp.com/blog/blogroll/items/Meeting-Cpp-Blogroll-322.html)摘抄一些c++动态

[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)｜[在线地址](https://wanghenshui.github.io/cppweeklynews/) ｜[知乎专栏](https://www.zhihu.com/column/jieyaren) |[腾讯云+社区](https://cloud.tencent.com/developer/column/92884)



欢迎投稿，推荐或自荐文章/软件/资源等，请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)

本期内容非常少

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[三月邮件](http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2022/#mailing2022-03)

把标题简单列一下

| [N4908](https://wg21.link/N4908)       | Working Draft, C++ Extensions for Library Fundamentals, Version 3 | Thomas Köppe        | 2022-02-19 | 2022-03 |                                        | All of WG21                                               |
| -------------------------------------- | ------------------------------------------------------------ | ------------------- | ---------- | ------- | -------------------------------------- | --------------------------------------------------------- |
| [N4909](https://wg21.link/N4909)       | Editor’s Report: C++ Extensions for Library Fundamentals, Version 3 | Thomas Köppe        | 2022-02-19 | 2022-03 |                                        | All of WG21                                               |
| [N4910](https://wg21.link/N4910)       | Working Draft, Standard for Programming Language C++         | Thomas Köppe        | 2022-03-17 | 2022-03 |                                        | All of WG21                                               |
| [N4911](https://wg21.link/N4911)       | Editors’ Report - Programming Languages - C++                | Thomas Köppe        | 2022-03-17 | 2022-03 |                                        | All of WG21                                               |
| [P0009R16](https://wg21.link/P0009R16) | MDSPAN                                                       | Christian Trott     | 2022-03-15 | 2022-03 | [P0009R15](https://wg21.link/P0009R15) | LWG Library                                               |
| [P0957R6](https://wg21.link/P0957R6)   | Proxy: A Polymorphic Programming Library                     | Mingxin Wang        | 2022-03-15 | 2022-03 | [P0957R5](https://wg21.link/P0957R5)   | LEWGI SG18: LEWG Incubator,LEWG Library Evolution         |
| [P1083R5](https://wg21.link/P1083R5)   | Move resource_adaptor from Library TS to the C++ WP          | Pablo Halpern       | 2022-02-24 | 2022-03 | [P1083R4](https://wg21.link/P1083R4)   | LEWG Library Evolution                                    |
| [P1684R1](https://wg21.link/P1684R1)   | mdarray: An Owning Multidimensional Array Analog of mdspan   | Christian Trott     | 2022-03-20 | 2022-03 | [P1684R0](https://wg21.link/P1684R0)   | LEWG Library Evolution                                    |
| [P1708R6](https://wg21.link/P1708R6)   | Simple Statistical Functions                                 | Richard Dosselman   | 2022-03-15 | 2022-03 | [P1708R5](https://wg21.link/P1708R5)   | SG6 Numerics,SG19 Machine Learning,LEWG Library Evolution |
| [P1839R4](https://wg21.link/P1839R4)   | Accessing Object Representations                             | Krystian Stasiowski | 2022-03-16 | 2022-03 | [P1839R3](https://wg21.link/P1839R3)   | CWG Core                                                  |
| [P2264R3](https://wg21.link/P2264R3)   | Make assert() macro user friendly for C and C++              | Peter Sommerlad     | 2022-02-27 | 2022-03 | [P2264R2](https://wg21.link/P2264R2)   | SG22 Compatability,LEWG Library Evolution                 |
| [P2290R3](https://wg21.link/P2290R3)   | Delimited escape sequences                                   | Corentin Jabot      | 2022-02-25 | 2022-03 | [P2290R2](https://wg21.link/P2290R2)   | SG22 Compatability,CWG Core                               |
| [P2465R3](https://wg21.link/P2465R3)   | Standard Library Modules std and std.compat                  | Stephan T. Lavavej  | 2022-03-11 | 2022-03 | [P2465R2](https://wg21.link/P2465R2)   | CWG Core,LWG Library                                      |
| [P2510R1](https://wg21.link/P2510R1)   | Formatting pointers                                          | Mark de Wever       | 2022-03-20 | 2022-03 | [P2510R0](https://wg21.link/P2510R0)   | LWG Library                                               |
| [P2511R1](https://wg21.link/P2511R1)   | Beyond operator(): NTTP callables in type-erased call wrappers | Zhihao Yuan         | 2022-03-15 | 2022-03 | [P2511R0](https://wg21.link/P2511R0)   | LEWG Library Evolution                                    |
| [P2521R2](https://wg21.link/P2521R2)   | Contract support – Working Paper                             | Andrzej Krzemieński | 2022-03-15 | 2022-03 | [P2521R1](https://wg21.link/P2521R1)   | SG21 Contracts                                            |
| [P2539R0](https://wg21.link/P2539R0)   | Should the output of std::print to a terminal be synchronized with the underlying stream? | Victor Zverovich    | 2022-03-11 | 2022-03 |                                        | LEWG Library Evolution                                    |
| [P2540R1](https://wg21.link/P2540R1)   | Empty Product for certain Views                              | Steve Downey        | 2022-03-14 | 2022-03 | [P2540R0](https://wg21.link/P2540R0)   | SG9 Ranges,LEWG Library Evolution                         |
| [P2553R1](https://wg21.link/P2553R1)   | Make mdspan size_type controllable                           | Christian Trott     | 2022-03-15 | 2022-03 | [P2553R0](https://wg21.link/P2553R0)   | LEWG Library Evolution,LWG Library                        |
| [P2555R1](https://wg21.link/P2555R1)   | Naming improvements for std::execution                       | Jens Maurer         | 2022-03-13 | 2022-03 | [P2555R0](https://wg21.link/P2555R0)   | LEWG Library Evolution                                    |
| [P2558R0](https://wg21.link/P2558R0)   | Add @, $, and ` to the basic character set                   | Steve Downey        | 2022-03-16 | 2022-03 |                                        | SG16 Unicode,EWGI SG17: EWG Incubator,SG22 Compatability  |
| [P2560R0](https://wg21.link/P2560R0)   | Comparing value- and type-based reflection                   | Matúš Chochlı́k      | 2022-02-23 | 2022-03 |                                        | SG7 Reflection                                            |
| [P2562R0](https://wg21.link/P2562R0)   | constexpr Stable Sorting                                     | Oliver Rosten       | 2022-03-09 | 2022-03 |                                        | LEWG Library Evolution,LWG Library                        |
| [P2564R0](https://wg21.link/P2564R0)   | consteval needs to propagate up                              | Barry Revzin        | 2022-03-14 | 2022-03 |                                        | EWG Evolution                                             |
| [P2565R0](https://wg21.link/P2565R0)   | Supporting User-Defined Attributes                           | Bret Brown          | 2022-03-15 | 2022-03 |                                        | SG15 Tooling                                              |
| [P2568R0](https://wg21.link/P2568R0)   | Proposal of std::map::at_ptr                                 | Andrew Tomazos      | 2022-03-18 | 2022-03 |                                        | LEWG Library Evolution                                    |
| [P2569R0](https://wg21.link/P2569R0)   | *_HAS_SUBNORM==0 implies what?                               | Fred Tydeman        | 2022-03-18 | 2022-03 |                                        | SG6 Numerics,SG22 Compatability                           |

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2022-03-23 第142期](https://github.com/hellogcc/osdt-weekly/blob/master/weekly-2022/2022-03-23.md)



## 文章

- [c++ tip of week **Did you know that C++23 added `std::to_underlying`?**](https://github.com/QuantlabFinancial/cpp_tip_of_the_week/)

```c++
enum { QL = 42 };

int main() {
    std::cout << std::to_underlying(QL); // prints 42
    static_assert(typeid(std::to_underlying(QL)) == typeid(unsigned));
}
```

没啥说的

- [A tour of the Rust and C++ interoperability ecosystem ](https://blog.tetrane.com/2022/Rust-Cxx-interop.html)

c++/rust混合编程的一些问题

- [Minimum viable declarative GUI in C++](https://ossia.io/posts/minimum-viable/)

讲UI实现的。看不懂

- [SFINAE, Immediate Context, Operator <<  and '\n' ](https://www.cppstories.com/2022/sfinea-immediate-context/)

```c++
std::tuple tp { 10, 20, "hello"};
std::cout << tp << '\n';		  // << err ??
```

tuple不能这么打印。重载有问题

只好这么写

```c++
template <typename TupleT, std::size_t TupSize = std::tuple_size_v<TupleT>>
std::ostream& operator <<(std::ostream& os, const TupleT& tp) {
    return printTupleImp(os, tp, std::make_index_sequence<TupSize>{}); 
}

```



## 视频

- [C++ Weekly - Ep 316 - What Are `const` Member Functions?](https://www.youtube.com/watch?v=bqd9ILyQRxQ)

没啥说的



## 开源项目需要人手

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线






---



[本文永久链接](https://wanghenshui.github.io/cppweeklynews/posts/055.html)
